/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldQRDecomposition;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FieldAngularCoordinates<T extends CalculusFieldElement<T>>
implements FieldTimeShiftable<FieldAngularCoordinates<T>, T> {
    private final FieldRotation<T> rotation;
    private final FieldVector3D<T> rotationRate;
    private final FieldVector3D<T> rotationAcceleration;

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate) {
        this(rotation, rotationRate, FieldVector3D.getZero((Field)rotation.getQ0().getField()));
    }

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        this.rotation = rotation;
        this.rotationRate = rotationRate;
        this.rotationAcceleration = rotationAcceleration;
    }

    public FieldAngularCoordinates(FieldPVCoordinates<T> u1, FieldPVCoordinates<T> u2, FieldPVCoordinates<T> v1, FieldPVCoordinates<T> v2, double tolerance) {
        try {
            this.rotation = new FieldRotation(u1.getPosition(), u2.getPosition(), v1.getPosition(), v2.getPosition());
            FieldVector3D ru1Dot = this.rotation.applyTo(u1.getVelocity());
            FieldVector3D ru2Dot = this.rotation.applyTo(u2.getVelocity());
            this.rotationRate = FieldAngularCoordinates.inverseCrossProducts(v1.getPosition(), ru1Dot.subtract(v1.getVelocity()), v2.getPosition(), ru2Dot.subtract(v2.getVelocity()), tolerance);
            FieldVector3D ru1DotDot = this.rotation.applyTo(u1.getAcceleration());
            FieldVector3D oDotv1 = FieldVector3D.crossProduct(this.rotationRate, v1.getVelocity());
            FieldVector3D oov1 = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)this.rotationRate.crossProduct(v1.getPosition()));
            FieldVector3D c1 = new FieldVector3D(1.0, ru1DotDot, -2.0, oDotv1, -1.0, oov1, -1.0, v1.getAcceleration());
            FieldVector3D ru2DotDot = this.rotation.applyTo(u2.getAcceleration());
            FieldVector3D oDotv2 = FieldVector3D.crossProduct(this.rotationRate, v2.getVelocity());
            FieldVector3D oov2 = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)this.rotationRate.crossProduct(v2.getPosition()));
            FieldVector3D c2 = new FieldVector3D(1.0, ru2DotDot, -2.0, oDotv2, -1.0, oov2, -1.0, v2.getAcceleration());
            this.rotationAcceleration = FieldAngularCoordinates.inverseCrossProducts(v1.getPosition(), c1, v2.getPosition(), c2, tolerance);
        }
        catch (MathIllegalArgumentException miae) {
            throw new OrekitException((MathRuntimeException)((Object)miae));
        }
    }

    public FieldAngularCoordinates(Field<T> field, AngularCoordinates ang) {
        this.rotation = new FieldRotation(field, ang.getRotation());
        this.rotationRate = new FieldVector3D(field, ang.getRotationRate());
        this.rotationAcceleration = new FieldVector3D(field, ang.getRotationAcceleration());
    }

    public <U extends FieldDerivative<T, U>> FieldAngularCoordinates(FieldRotation<U> r) {
        CalculusFieldElement q0 = ((FieldDerivative)r.getQ0()).getValue();
        CalculusFieldElement q1 = ((FieldDerivative)r.getQ1()).getValue();
        CalculusFieldElement q2 = ((FieldDerivative)r.getQ2()).getValue();
        CalculusFieldElement q3 = ((FieldDerivative)r.getQ3()).getValue();
        this.rotation = new FieldRotation(q0, q1, q2, q3, false);
        if (((FieldDerivative)r.getQ0()).getOrder() >= 1) {
            CalculusFieldElement q0Dot = ((FieldDerivative)r.getQ0()).getPartialDerivative(new int[]{1});
            CalculusFieldElement q1Dot = ((FieldDerivative)r.getQ1()).getPartialDerivative(new int[]{1});
            CalculusFieldElement q2Dot = ((FieldDerivative)r.getQ2()).getPartialDerivative(new int[]{1});
            CalculusFieldElement q3Dot = ((FieldDerivative)r.getQ3()).getPartialDerivative(new int[]{1});
            this.rotationRate = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q0Dot, (FieldElement)q0, (FieldElement)q1Dot, (FieldElement)q3, (FieldElement)q2Dot, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q3Dot)).multiply(2), (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q0Dot, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q1Dot, (FieldElement)q0, (FieldElement)q2Dot, (FieldElement)q1, (FieldElement)q3Dot)).multiply(2), (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q0Dot, (FieldElement)q2, (FieldElement)q1Dot, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q2Dot, (FieldElement)q0, (FieldElement)q3Dot)).multiply(2));
            if (((FieldDerivative)r.getQ0()).getOrder() >= 2) {
                CalculusFieldElement q0DotDot = ((FieldDerivative)r.getQ0()).getPartialDerivative(new int[]{2});
                CalculusFieldElement q1DotDot = ((FieldDerivative)r.getQ1()).getPartialDerivative(new int[]{2});
                CalculusFieldElement q2DotDot = ((FieldDerivative)r.getQ2()).getPartialDerivative(new int[]{2});
                CalculusFieldElement q3DotDot = ((FieldDerivative)r.getQ3()).getPartialDerivative(new int[]{2});
                this.rotationAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q0DotDot, (FieldElement)q0, (FieldElement)q1DotDot, (FieldElement)q3, (FieldElement)q2DotDot, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q3DotDot)).multiply(2), (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q0DotDot, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q1DotDot, (FieldElement)q0, (FieldElement)q2DotDot, (FieldElement)q1, (FieldElement)q3DotDot)).multiply(2), (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q0DotDot, (FieldElement)q2, (FieldElement)q1DotDot, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q2DotDot, (FieldElement)q0, (FieldElement)q3DotDot)).multiply(2));
            } else {
                this.rotationAcceleration = FieldVector3D.getZero((Field)q0.getField());
            }
        } else {
            this.rotationRate = FieldVector3D.getZero((Field)q0.getField());
            this.rotationAcceleration = FieldVector3D.getZero((Field)q0.getField());
        }
    }

    public static <T extends CalculusFieldElement<T>> FieldAngularCoordinates<T> getIdentity(Field<T> field) {
        return new FieldAngularCoordinates<T>(field, AngularCoordinates.IDENTITY);
    }

    private static <T extends CalculusFieldElement<T>> FieldVector3D<T> inverseCrossProducts(FieldVector3D<T> v1, FieldVector3D<T> c1, FieldVector3D<T> v2, FieldVector3D<T> c2, double tolerance) throws MathIllegalArgumentException {
        CalculusFieldElement v12 = v1.getNormSq();
        CalculusFieldElement v1n = (CalculusFieldElement)v12.sqrt();
        CalculusFieldElement v22 = v2.getNormSq();
        CalculusFieldElement v2n = (CalculusFieldElement)v22.sqrt();
        CalculusFieldElement threshold = v1n.getReal() >= v2n.getReal() ? (CalculusFieldElement)v1n.multiply(tolerance) : (CalculusFieldElement)v2n.multiply(tolerance);
        FieldVector3D omega = null;
        try {
            FieldMatrix m = MatrixUtils.createFieldMatrix((Field)v12.getField(), (int)6, (int)3);
            m.setEntry(0, 1, (FieldElement)v1.getZ());
            m.setEntry(0, 2, (FieldElement)((CalculusFieldElement)v1.getY().negate()));
            m.setEntry(1, 0, (FieldElement)((CalculusFieldElement)v1.getZ().negate()));
            m.setEntry(1, 2, (FieldElement)v1.getX());
            m.setEntry(2, 0, (FieldElement)v1.getY());
            m.setEntry(2, 1, (FieldElement)((CalculusFieldElement)v1.getX().negate()));
            m.setEntry(3, 1, (FieldElement)v2.getZ());
            m.setEntry(3, 2, (FieldElement)((CalculusFieldElement)v2.getY().negate()));
            m.setEntry(4, 0, (FieldElement)((CalculusFieldElement)v2.getZ().negate()));
            m.setEntry(4, 2, (FieldElement)v2.getX());
            m.setEntry(5, 0, (FieldElement)v2.getY());
            m.setEntry(5, 1, (FieldElement)((CalculusFieldElement)v2.getX().negate()));
            CalculusFieldElement[] kk = (CalculusFieldElement[])MathArrays.buildArray((Field)v2n.getField(), (int)6);
            kk[0] = c1.getX();
            kk[1] = c1.getY();
            kk[2] = c1.getZ();
            kk[3] = c2.getX();
            kk[4] = c2.getY();
            kk[5] = c2.getZ();
            FieldVector rhs = MatrixUtils.createFieldVector((FieldElement[])kk);
            FieldDecompositionSolver solver = new FieldQRDecomposition(m).getSolver();
            FieldVector v = solver.solve(rhs);
            omega = new FieldVector3D((CalculusFieldElement)v.getEntry(0), (CalculusFieldElement)v.getEntry(1), (CalculusFieldElement)v.getEntry(2));
        }
        catch (MathIllegalArgumentException miae) {
            if (miae.getSpecifier() == LocalizedCoreFormats.SINGULAR_MATRIX) {
                CalculusFieldElement c12 = c1.getNormSq();
                CalculusFieldElement c1n = (CalculusFieldElement)c12.sqrt();
                CalculusFieldElement c22 = c2.getNormSq();
                CalculusFieldElement c2n = (CalculusFieldElement)c22.sqrt();
                if (c1n.getReal() <= threshold.getReal() && c2n.getReal() <= threshold.getReal()) {
                    return new FieldVector3D((CalculusFieldElement)v12.getField().getZero(), (CalculusFieldElement)v12.getField().getZero(), (CalculusFieldElement)v12.getField().getZero());
                }
                if (v1n.getReal() <= threshold.getReal() && c1n.getReal() >= threshold.getReal()) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{c1n.getReal(), 0, true});
                }
                if (v2n.getReal() <= threshold.getReal() && c2n.getReal() >= threshold.getReal()) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{c2n.getReal(), 0, true});
                }
                if (v1.crossProduct(v1).getNorm().getReal() <= threshold.getReal() && v12.getReal() > threshold.getReal()) {
                    omega = new FieldVector3D((CalculusFieldElement)v12.reciprocal(), v1.crossProduct(c1));
                }
                throw miae;
            }
            throw miae;
        }
        CalculusFieldElement d1 = FieldVector3D.distance((FieldVector3D)omega.crossProduct(v1), c1);
        if (d1.getReal() > threshold.getReal()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{0, true});
        }
        CalculusFieldElement d2 = FieldVector3D.distance((FieldVector3D)omega.crossProduct(v2), c2);
        if (d2.getReal() > threshold.getReal()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE, new Object[]{0, true});
        }
        return omega;
    }

    public FieldRotation<FieldDerivativeStructure<T>> toDerivativeStructureRotation(int order) {
        FieldDerivativeStructure q3DS;
        FieldDerivativeStructure q2DS;
        FieldDerivativeStructure q1DS;
        FieldDerivativeStructure q0DS;
        CalculusFieldElement q0 = this.rotation.getQ0();
        CalculusFieldElement q1 = this.rotation.getQ1();
        CalculusFieldElement q2 = this.rotation.getQ2();
        CalculusFieldElement q3 = this.rotation.getQ3();
        CalculusFieldElement oX = this.rotationRate.getX();
        CalculusFieldElement oY = this.rotationRate.getY();
        CalculusFieldElement oZ = this.rotationRate.getZ();
        CalculusFieldElement q0Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oX, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oY, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q1Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q0, (FieldElement)oX, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oY, (FieldElement)q2, (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q2Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q3, (FieldElement)oX, (FieldElement)q0, (FieldElement)oY, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q3Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oX, (FieldElement)q1, (FieldElement)oY, (FieldElement)q0, (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement oXDot = this.rotationAcceleration.getX();
        CalculusFieldElement oYDot = this.rotationAcceleration.getY();
        CalculusFieldElement oZDot = this.rotationAcceleration.getZ();
        CalculusFieldElement q0DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q1, q2, q3, q1Dot, q2Dot, q3Dot), (FieldElement[])this.array6(oXDot, oYDot, oZDot, oX, oY, oZ))).multiply(-0.5);
        CalculusFieldElement q1DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q0, q2, (CalculusFieldElement)q3.negate(), q0Dot, q2Dot, (CalculusFieldElement)q3Dot.negate()), (FieldElement[])this.array6(oXDot, oZDot, oYDot, oX, oZ, oY))).multiply(0.5);
        CalculusFieldElement q2DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q0, q3, (CalculusFieldElement)q1.negate(), q0Dot, q3Dot, (CalculusFieldElement)q1Dot.negate()), (FieldElement[])this.array6(oYDot, oXDot, oZDot, oY, oX, oZ))).multiply(0.5);
        CalculusFieldElement q3DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q0, q1, (CalculusFieldElement)q2.negate(), q0Dot, q1Dot, (CalculusFieldElement)q2Dot.negate()), (FieldElement[])this.array6(oZDot, oYDot, oXDot, oZ, oY, oX))).multiply(0.5);
        switch (order) {
            case 0: {
                FDSFactory factory = new FDSFactory(q0.getField(), 1, order);
                q0DS = factory.build(new CalculusFieldElement[]{q0});
                q1DS = factory.build(new CalculusFieldElement[]{q1});
                q2DS = factory.build(new CalculusFieldElement[]{q2});
                q3DS = factory.build(new CalculusFieldElement[]{q3});
                break;
            }
            case 1: {
                FDSFactory factory = new FDSFactory(q0.getField(), 1, order);
                q0DS = factory.build(new CalculusFieldElement[]{q0, q0Dot});
                q1DS = factory.build(new CalculusFieldElement[]{q1, q1Dot});
                q2DS = factory.build(new CalculusFieldElement[]{q2, q2Dot});
                q3DS = factory.build(new CalculusFieldElement[]{q3, q3Dot});
                break;
            }
            case 2: {
                FDSFactory factory = new FDSFactory(q0.getField(), 1, order);
                q0DS = factory.build(new CalculusFieldElement[]{q0, q0Dot, q0DotDot});
                q1DS = factory.build(new CalculusFieldElement[]{q1, q1Dot, q1DotDot});
                q2DS = factory.build(new CalculusFieldElement[]{q2, q2Dot, q2DotDot});
                q3DS = factory.build(new CalculusFieldElement[]{q3, q3Dot, q3DotDot});
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
            }
        }
        return new FieldRotation((CalculusFieldElement)q0DS, (CalculusFieldElement)q1DS, (CalculusFieldElement)q2DS, (CalculusFieldElement)q3DS, false);
    }

    public FieldRotation<FieldUnivariateDerivative1<T>> toUnivariateDerivative1Rotation() {
        CalculusFieldElement q0 = this.rotation.getQ0();
        CalculusFieldElement q1 = this.rotation.getQ1();
        CalculusFieldElement q2 = this.rotation.getQ2();
        CalculusFieldElement q3 = this.rotation.getQ3();
        CalculusFieldElement oX = this.rotationRate.getX();
        CalculusFieldElement oY = this.rotationRate.getY();
        CalculusFieldElement oZ = this.rotationRate.getZ();
        CalculusFieldElement q0Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oX, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oY, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q1Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q0, (FieldElement)oX, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oY, (FieldElement)q2, (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q2Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q3, (FieldElement)oX, (FieldElement)q0, (FieldElement)oY, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q3Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oX, (FieldElement)q1, (FieldElement)oY, (FieldElement)q0, (FieldElement)oZ)).multiply(0.5);
        FieldUnivariateDerivative1 q0UD = new FieldUnivariateDerivative1(q0, q0Dot);
        FieldUnivariateDerivative1 q1UD = new FieldUnivariateDerivative1(q1, q1Dot);
        FieldUnivariateDerivative1 q2UD = new FieldUnivariateDerivative1(q2, q2Dot);
        FieldUnivariateDerivative1 q3UD = new FieldUnivariateDerivative1(q3, q3Dot);
        return new FieldRotation((CalculusFieldElement)q0UD, (CalculusFieldElement)q1UD, (CalculusFieldElement)q2UD, (CalculusFieldElement)q3UD, false);
    }

    public FieldRotation<FieldUnivariateDerivative2<T>> toUnivariateDerivative2Rotation() {
        CalculusFieldElement q0 = this.rotation.getQ0();
        CalculusFieldElement q1 = this.rotation.getQ1();
        CalculusFieldElement q2 = this.rotation.getQ2();
        CalculusFieldElement q3 = this.rotation.getQ3();
        CalculusFieldElement oX = this.rotationRate.getX();
        CalculusFieldElement oY = this.rotationRate.getY();
        CalculusFieldElement oZ = this.rotationRate.getZ();
        CalculusFieldElement q0Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oX, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oY, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q1Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q0, (FieldElement)oX, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oY, (FieldElement)q2, (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q2Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q3, (FieldElement)oX, (FieldElement)q0, (FieldElement)oY, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q3Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oX, (FieldElement)q1, (FieldElement)oY, (FieldElement)q0, (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement oXDot = this.rotationAcceleration.getX();
        CalculusFieldElement oYDot = this.rotationAcceleration.getY();
        CalculusFieldElement oZDot = this.rotationAcceleration.getZ();
        CalculusFieldElement q0DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q1, q2, q3, q1Dot, q2Dot, q3Dot), (FieldElement[])this.array6(oXDot, oYDot, oZDot, oX, oY, oZ))).multiply(-0.5);
        CalculusFieldElement q1DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q0, q2, (CalculusFieldElement)q3.negate(), q0Dot, q2Dot, (CalculusFieldElement)q3Dot.negate()), (FieldElement[])this.array6(oXDot, oZDot, oYDot, oX, oZ, oY))).multiply(0.5);
        CalculusFieldElement q2DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q0, q3, (CalculusFieldElement)q1.negate(), q0Dot, q3Dot, (CalculusFieldElement)q1Dot.negate()), (FieldElement[])this.array6(oYDot, oXDot, oZDot, oY, oX, oZ))).multiply(0.5);
        CalculusFieldElement q3DotDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement[])this.array6(q0, q1, (CalculusFieldElement)q2.negate(), q0Dot, q1Dot, (CalculusFieldElement)q2Dot.negate()), (FieldElement[])this.array6(oZDot, oYDot, oXDot, oZ, oY, oX))).multiply(0.5);
        FieldUnivariateDerivative2 q0UD = new FieldUnivariateDerivative2(q0, q0Dot, q0DotDot);
        FieldUnivariateDerivative2 q1UD = new FieldUnivariateDerivative2(q1, q1Dot, q1DotDot);
        FieldUnivariateDerivative2 q2UD = new FieldUnivariateDerivative2(q2, q2Dot, q2DotDot);
        FieldUnivariateDerivative2 q3UD = new FieldUnivariateDerivative2(q3, q3Dot, q3DotDot);
        return new FieldRotation((CalculusFieldElement)q0UD, (CalculusFieldElement)q1UD, (CalculusFieldElement)q2UD, (CalculusFieldElement)q3UD, false);
    }

    private T[] array6(T e1, T e2, T e3, T e4, T e5, T e6) {
        CalculusFieldElement[] array = (CalculusFieldElement[])MathArrays.buildArray((Field)e1.getField(), (int)6);
        array[0] = e1;
        array[1] = e2;
        array[2] = e3;
        array[3] = e4;
        array[4] = e5;
        array[5] = e6;
        return array;
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> estimateRate(FieldRotation<T> start, FieldRotation<T> end, double dt) {
        return FieldAngularCoordinates.estimateRate(start, end, (CalculusFieldElement)((CalculusFieldElement)start.getQ0().getField().getZero()).newInstance(dt));
    }

    public static <T extends CalculusFieldElement<T>> FieldVector3D<T> estimateRate(FieldRotation<T> start, FieldRotation<T> end, T dt) {
        FieldRotation evolution = start.compose(end.revert(), RotationConvention.VECTOR_OPERATOR);
        return new FieldVector3D((CalculusFieldElement)evolution.getAngle().divide(dt), evolution.getAxis(RotationConvention.VECTOR_OPERATOR));
    }

    public FieldAngularCoordinates<T> revert() {
        return new FieldAngularCoordinates<T>(this.rotation.revert(), this.rotation.applyInverseTo(this.rotationRate.negate()), this.rotation.applyInverseTo(this.rotationAcceleration.negate()));
    }

    public FieldRotation<T> rotationShiftedBy(T dt) {
        CalculusFieldElement rate = this.rotationRate.getNorm();
        FieldRotation rateContribution = rate.getReal() == 0.0 ? FieldRotation.getIdentity((Field)dt.getField()) : new FieldRotation(this.rotationRate, (CalculusFieldElement)rate.multiply(dt), RotationConvention.FRAME_TRANSFORM);
        FieldRotation linearPart = rateContribution.compose(this.rotation, RotationConvention.VECTOR_OPERATOR);
        CalculusFieldElement acc = this.rotationAcceleration.getNorm();
        if (acc.getReal() == 0.0) {
            return linearPart;
        }
        FieldRotation quadraticContribution = new FieldRotation(this.rotationAcceleration, (CalculusFieldElement)((CalculusFieldElement)acc.multiply((FieldElement)((CalculusFieldElement)dt.square()))).multiply(0.5), RotationConvention.FRAME_TRANSFORM);
        return quadraticContribution.compose(linearPart, RotationConvention.VECTOR_OPERATOR);
    }

    @Override
    public FieldAngularCoordinates<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.rotation.getQ0().getField().getZero()).newInstance(dt));
    }

    @Override
    public FieldAngularCoordinates<T> shiftedBy(T dt) {
        CalculusFieldElement rate = this.rotationRate.getNorm();
        CalculusFieldElement zero = (CalculusFieldElement)rate.getField().getZero();
        CalculusFieldElement one = (CalculusFieldElement)rate.getField().getOne();
        FieldRotation rateContribution = rate.getReal() == 0.0 ? new FieldRotation(one, zero, zero, zero, false) : new FieldRotation(this.rotationRate, (CalculusFieldElement)rate.multiply(dt), RotationConvention.FRAME_TRANSFORM);
        FieldAngularCoordinates<T> linearPart = new FieldAngularCoordinates<T>(rateContribution.compose(this.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate);
        CalculusFieldElement acc = this.rotationAcceleration.getNorm();
        if (acc.getReal() == 0.0) {
            return linearPart;
        }
        FieldAngularCoordinates<T> quadraticContribution = new FieldAngularCoordinates<T>(new FieldRotation(this.rotationAcceleration, (CalculusFieldElement)acc.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)dt.square()).multiply(0.5))), RotationConvention.FRAME_TRANSFORM), new FieldVector3D(dt, this.rotationAcceleration), this.rotationAcceleration);
        return quadraticContribution.addOffset(linearPart);
    }

    public FieldRotation<T> getRotation() {
        return this.rotation;
    }

    public FieldVector3D<T> getRotationRate() {
        return this.rotationRate;
    }

    public FieldVector3D<T> getRotationAcceleration() {
        return this.rotationAcceleration;
    }

    public FieldAngularCoordinates<T> addOffset(FieldAngularCoordinates<T> offset) {
        FieldVector3D rOmega = this.rotation.applyTo(offset.rotationRate);
        FieldVector3D rOmegaDot = this.rotation.applyTo(offset.rotationAcceleration);
        return new FieldAngularCoordinates<T>(this.rotation.compose(offset.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate.add(rOmega), new FieldVector3D(1.0, this.rotationAcceleration, 1.0, rOmegaDot, -1.0, FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)rOmega)));
    }

    public FieldAngularCoordinates<T> subtractOffset(FieldAngularCoordinates<T> offset) {
        return this.addOffset(offset.revert());
    }

    public AngularCoordinates toAngularCoordinates() {
        return new AngularCoordinates(this.rotation.toRotation(), this.rotationRate.toVector3D(), this.rotationAcceleration.toVector3D());
    }

    public FieldPVCoordinates<T> applyTo(PVCoordinates pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates(transformedP, transformedV, transformedA);
    }

    public TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedPVCoordinates pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public FieldPVCoordinates<T> applyTo(FieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates(transformedP, transformedV, transformedA);
    }

    public TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedFieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedP);
        FieldVector3D transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, (FieldVector3D)crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, (FieldVector3D)transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public T[][] getModifiedRodrigues(double sign) {
        CalculusFieldElement q0 = (CalculusFieldElement)this.getRotation().getQ0().multiply(sign);
        CalculusFieldElement q1 = (CalculusFieldElement)this.getRotation().getQ1().multiply(sign);
        CalculusFieldElement q2 = (CalculusFieldElement)this.getRotation().getQ2().multiply(sign);
        CalculusFieldElement q3 = (CalculusFieldElement)this.getRotation().getQ3().multiply(sign);
        CalculusFieldElement oX = this.getRotationRate().getX();
        CalculusFieldElement oY = this.getRotationRate().getY();
        CalculusFieldElement oZ = this.getRotationRate().getZ();
        CalculusFieldElement oXDot = this.getRotationAcceleration().getX();
        CalculusFieldElement oYDot = this.getRotationAcceleration().getY();
        CalculusFieldElement oZDot = this.getRotationAcceleration().getZ();
        CalculusFieldElement q0Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oX, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oY, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q1Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q0, (FieldElement)oX, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)oY, (FieldElement)q2, (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q2Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)q3, (FieldElement)oX, (FieldElement)q0, (FieldElement)oY, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q3Dot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)oX, (FieldElement)q1, (FieldElement)oY, (FieldElement)q0, (FieldElement)oZ)).multiply(0.5);
        CalculusFieldElement q0DotDot = (CalculusFieldElement)this.linearCombination(q1, oXDot, q2, oYDot, q3, oZDot, q1Dot, oX, q2Dot, oY, q3Dot, oZ).multiply(-0.5);
        CalculusFieldElement q1DotDot = (CalculusFieldElement)this.linearCombination(q0, oXDot, q2, oZDot, (CalculusFieldElement)q3.negate(), oYDot, q0Dot, oX, q2Dot, oZ, (CalculusFieldElement)q3Dot.negate(), oY).multiply(0.5);
        CalculusFieldElement q2DotDot = (CalculusFieldElement)this.linearCombination(q0, oYDot, q3, oXDot, (CalculusFieldElement)q1.negate(), oZDot, q0Dot, oY, q3Dot, oX, (CalculusFieldElement)q1Dot.negate(), oZ).multiply(0.5);
        CalculusFieldElement q3DotDot = (CalculusFieldElement)this.linearCombination(q0, oZDot, q1, oYDot, (CalculusFieldElement)q2.negate(), oXDot, q0Dot, oZ, q1Dot, oY, (CalculusFieldElement)q2Dot.negate(), oX).multiply(0.5);
        CalculusFieldElement inv = (CalculusFieldElement)((CalculusFieldElement)q0.add(1.0)).reciprocal();
        CalculusFieldElement mTwoInvQ0Dot = (CalculusFieldElement)((CalculusFieldElement)inv.multiply((FieldElement)q0Dot)).multiply(-2);
        CalculusFieldElement r1 = (CalculusFieldElement)inv.multiply((FieldElement)q1);
        CalculusFieldElement r2 = (CalculusFieldElement)inv.multiply((FieldElement)q2);
        CalculusFieldElement r3 = (CalculusFieldElement)inv.multiply((FieldElement)q3);
        CalculusFieldElement mInvR1 = (CalculusFieldElement)((CalculusFieldElement)inv.multiply((FieldElement)r1)).negate();
        CalculusFieldElement mInvR2 = (CalculusFieldElement)((CalculusFieldElement)inv.multiply((FieldElement)r2)).negate();
        CalculusFieldElement mInvR3 = (CalculusFieldElement)((CalculusFieldElement)inv.multiply((FieldElement)r3)).negate();
        CalculusFieldElement r1Dot = (CalculusFieldElement)q0.linearCombination((FieldElement)inv, (FieldElement)q1Dot, (FieldElement)mInvR1, (FieldElement)q0Dot);
        CalculusFieldElement r2Dot = (CalculusFieldElement)q0.linearCombination((FieldElement)inv, (FieldElement)q2Dot, (FieldElement)mInvR2, (FieldElement)q0Dot);
        CalculusFieldElement r3Dot = (CalculusFieldElement)q0.linearCombination((FieldElement)inv, (FieldElement)q3Dot, (FieldElement)mInvR3, (FieldElement)q0Dot);
        CalculusFieldElement r1DotDot = (CalculusFieldElement)q0.linearCombination((FieldElement)inv, (FieldElement)q1DotDot, (FieldElement)mTwoInvQ0Dot, (FieldElement)r1Dot, (FieldElement)mInvR1, (FieldElement)q0DotDot);
        CalculusFieldElement r2DotDot = (CalculusFieldElement)q0.linearCombination((FieldElement)inv, (FieldElement)q2DotDot, (FieldElement)mTwoInvQ0Dot, (FieldElement)r2Dot, (FieldElement)mInvR2, (FieldElement)q0DotDot);
        CalculusFieldElement r3DotDot = (CalculusFieldElement)q0.linearCombination((FieldElement)inv, (FieldElement)q3DotDot, (FieldElement)mTwoInvQ0Dot, (FieldElement)r3Dot, (FieldElement)mInvR3, (FieldElement)q0DotDot);
        CalculusFieldElement[][] rodrigues = (CalculusFieldElement[][])MathArrays.buildArray((Field)q0.getField(), (int)3, (int)3);
        rodrigues[0][0] = r1;
        rodrigues[0][1] = r2;
        rodrigues[0][2] = r3;
        rodrigues[1][0] = r1Dot;
        rodrigues[1][1] = r2Dot;
        rodrigues[1][2] = r3Dot;
        rodrigues[2][0] = r1DotDot;
        rodrigues[2][1] = r2DotDot;
        rodrigues[2][2] = r3DotDot;
        return rodrigues;
    }

    private T linearCombination(T a1, T b1, T a2, T b2, T a3, T b3, T a4, T b4, T a5, T b5, T a6, T b6) {
        CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray((Field)a1.getField(), (int)6);
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        a[3] = a4;
        a[4] = a5;
        a[5] = a6;
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray((Field)b1.getField(), (int)6);
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        b[3] = b4;
        b[4] = b5;
        b[5] = b6;
        return (T)((CalculusFieldElement)a1.linearCombination((FieldElement[])a, (FieldElement[])b));
    }

    public static <T extends CalculusFieldElement<T>> FieldAngularCoordinates<T> createFromModifiedRodrigues(T[][] r) {
        CalculusFieldElement rSquared = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r[0][0].square()).add((FieldElement)((CalculusFieldElement)r[0][1].square()))).add((FieldElement)((CalculusFieldElement)r[0][2].square()));
        CalculusFieldElement oPQ0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rSquared.add(1.0)).reciprocal()).multiply(2);
        CalculusFieldElement q0 = (CalculusFieldElement)oPQ0.subtract(1.0);
        CalculusFieldElement q1 = (CalculusFieldElement)oPQ0.multiply(r[0][0]);
        CalculusFieldElement q2 = (CalculusFieldElement)oPQ0.multiply(r[0][1]);
        CalculusFieldElement q3 = (CalculusFieldElement)oPQ0.multiply(r[0][2]);
        CalculusFieldElement oPQ02 = (CalculusFieldElement)oPQ0.multiply((FieldElement)oPQ0);
        CalculusFieldElement q0Dot = (CalculusFieldElement)((CalculusFieldElement)oPQ02.multiply((FieldElement)((CalculusFieldElement)q0.linearCombination(r[0][0], r[1][0], r[0][1], r[1][1], r[0][2], r[1][2])))).negate();
        CalculusFieldElement q1Dot = (CalculusFieldElement)((CalculusFieldElement)oPQ0.multiply(r[1][0])).add((FieldElement)((CalculusFieldElement)r[0][0].multiply((FieldElement)q0Dot)));
        CalculusFieldElement q2Dot = (CalculusFieldElement)((CalculusFieldElement)oPQ0.multiply(r[1][1])).add((FieldElement)((CalculusFieldElement)r[0][1].multiply((FieldElement)q0Dot)));
        CalculusFieldElement q3Dot = (CalculusFieldElement)((CalculusFieldElement)oPQ0.multiply(r[1][2])).add((FieldElement)((CalculusFieldElement)r[0][2].multiply((FieldElement)q0Dot)));
        CalculusFieldElement oX = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q0Dot, (FieldElement)q0, (FieldElement)q1Dot, (FieldElement)q3, (FieldElement)q2Dot, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q3Dot)).multiply(2);
        CalculusFieldElement oY = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q0Dot, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q1Dot, (FieldElement)q0, (FieldElement)q2Dot, (FieldElement)q1, (FieldElement)q3Dot)).multiply(2);
        CalculusFieldElement oZ = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q0Dot, (FieldElement)q2, (FieldElement)q1Dot, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q2Dot, (FieldElement)q0, (FieldElement)q3Dot)).multiply(2);
        CalculusFieldElement q0DotDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q0.subtract(1.0)).negate()).divide((FieldElement)oPQ0)).multiply((FieldElement)((CalculusFieldElement)q0Dot.square()))).subtract((FieldElement)((CalculusFieldElement)oPQ02.multiply((FieldElement)((CalculusFieldElement)q0.linearCombination(r[0][0], r[2][0], r[0][1], r[2][1], r[0][2], r[2][2])))))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q1Dot.square()).add((FieldElement)((CalculusFieldElement)q2Dot.square()))).add((FieldElement)((CalculusFieldElement)q3Dot.square()))));
        CalculusFieldElement q1DotDot = (CalculusFieldElement)q0.linearCombination((FieldElement)oPQ0, r[2][0], (FieldElement)((CalculusFieldElement)r[1][0].add(r[1][0])), (FieldElement)q0Dot, r[0][0], (FieldElement)q0DotDot);
        CalculusFieldElement q2DotDot = (CalculusFieldElement)q0.linearCombination((FieldElement)oPQ0, r[2][1], (FieldElement)((CalculusFieldElement)r[1][1].add(r[1][1])), (FieldElement)q0Dot, r[0][1], (FieldElement)q0DotDot);
        CalculusFieldElement q3DotDot = (CalculusFieldElement)q0.linearCombination((FieldElement)oPQ0, r[2][2], (FieldElement)((CalculusFieldElement)r[1][2].add(r[1][2])), (FieldElement)q0Dot, r[0][2], (FieldElement)q0DotDot);
        CalculusFieldElement oXDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q0DotDot, (FieldElement)q0, (FieldElement)q1DotDot, (FieldElement)q3, (FieldElement)q2DotDot, (FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q3DotDot)).multiply(2);
        CalculusFieldElement oYDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q2.negate()), (FieldElement)q0DotDot, (FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q1DotDot, (FieldElement)q0, (FieldElement)q2DotDot, (FieldElement)q1, (FieldElement)q3DotDot)).multiply(2);
        CalculusFieldElement oZDot = (CalculusFieldElement)((CalculusFieldElement)q0.linearCombination((FieldElement)((CalculusFieldElement)q3.negate()), (FieldElement)q0DotDot, (FieldElement)q2, (FieldElement)q1DotDot, (FieldElement)((CalculusFieldElement)q1.negate()), (FieldElement)q2DotDot, (FieldElement)q0, (FieldElement)q3DotDot)).multiply(2);
        return new FieldAngularCoordinates<T>(new FieldRotation(q0, q1, q2, q3, false), new FieldVector3D(oX, oY, oZ), new FieldVector3D(oXDot, oYDot, oZDot));
    }
}

