/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Frame;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldAbsolutePVCoordinates;

public class FieldAbsolutePVCoordinatesHermiteInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldTimeInterpolator<FieldAbsolutePVCoordinates<KK>, KK> {
    private final CartesianDerivativesFilter filter;
    private final Frame outputFrame;

    public FieldAbsolutePVCoordinatesHermiteInterpolator(Frame outputFrame) {
        this(2, outputFrame);
    }

    public FieldAbsolutePVCoordinatesHermiteInterpolator(int interpolationPoints, Frame outputFrame) {
        this(interpolationPoints, outputFrame, CartesianDerivativesFilter.USE_PVA);
    }

    public FieldAbsolutePVCoordinatesHermiteInterpolator(int interpolationPoints, Frame outputFrame, CartesianDerivativesFilter filter) {
        super(interpolationPoints, 0.001);
        this.outputFrame = outputFrame;
        this.filter = filter;
    }

    public FieldAbsolutePVCoordinatesHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, CartesianDerivativesFilter filter) {
        super(interpolationPoints, extrapolationThreshold);
        this.outputFrame = outputFrame;
        this.filter = filter;
    }

    public CartesianDerivativesFilter getFilter() {
        return this.filter;
    }

    public Frame getOutputFrame() {
        return this.outputFrame;
    }

    @Override
    protected FieldAbsolutePVCoordinates<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldAbsoluteDate date = interpolationData.getInterpolationDate();
        List<FieldAbsolutePVCoordinates> sample = interpolationData.getNeighborList();
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        switch (this.filter) {
            case USE_P: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{position.toArray()});
                });
                break;
            }
            case USE_PV: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    FieldVector3D velocity = pv.getVelocity();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{position.toArray(), velocity.toArray()});
                });
                break;
            }
            case USE_PVA: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    FieldVector3D velocity = pv.getVelocity();
                    FieldVector3D acceleration = pv.getAcceleration();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (FieldElement[][])new CalculusFieldElement[][]{position.toArray(), velocity.toArray(), acceleration.toArray()});
                });
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        Object zero = interpolationData.getZero();
        CalculusFieldElement[][] p = (CalculusFieldElement[][])interpolator.derivatives(zero, 2);
        return new FieldAbsolutePVCoordinates(this.outputFrame, date, new FieldVector3D(p[0]), new FieldVector3D(p[1]), new FieldVector3D(p[2]));
    }
}

