/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldAbsolutePVCoordinates<T extends CalculusFieldElement<T>>
extends TimeStampedFieldPVCoordinates<T>
implements FieldTimeStamped<T>,
FieldPVCoordinatesProvider<T> {
    private final Frame frame;

    public FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldVector3D<T> position, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        super(date, position, velocity, acceleration);
        this.frame = frame;
    }

    public FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldVector3D<T> position, FieldVector3D<T> velocity) {
        this(frame, date, position, velocity, FieldVector3D.getZero(date.getField()));
    }

    public FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pva) {
        super(date, pva);
        this.frame = frame;
    }

    public FieldAbsolutePVCoordinates(Frame frame, TimeStampedFieldPVCoordinates<T> pva) {
        super(pva.getDate(), pva);
        this.frame = frame;
    }

    public FieldAbsolutePVCoordinates(Field<T> field, AbsolutePVCoordinates pva) {
        this(pva.getFrame(), new TimeStampedFieldPVCoordinates<T>(field, pva));
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a, FieldAbsolutePVCoordinates<T> AbsPva) {
        super(date, a, AbsPva);
        this.frame = AbsPva.frame;
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, FieldAbsolutePVCoordinates<T> start, FieldAbsolutePVCoordinates<T> end) {
        super(date, start, end);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(start, end);
        this.frame = start.frame;
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldAbsolutePVCoordinates<T> absPv1, T a2, FieldAbsolutePVCoordinates<T> absPv2) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates());
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        this.frame = absPv1.getFrame();
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldAbsolutePVCoordinates<T> absPv1, T a2, FieldAbsolutePVCoordinates<T> absPv2, T a3, FieldAbsolutePVCoordinates<T> absPv3) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates(), a3, absPv3.getPVCoordinates());
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv3);
        this.frame = absPv1.getFrame();
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldAbsolutePVCoordinates<T> absPv1, T a2, FieldAbsolutePVCoordinates<T> absPv2, T a3, FieldAbsolutePVCoordinates<T> absPv3, T a4, FieldAbsolutePVCoordinates<T> absPv4) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates(), a3, absPv3.getPVCoordinates(), a4, absPv4.getPVCoordinates());
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv3);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv4);
        this.frame = absPv1.getFrame();
    }

    public <U extends FieldDerivative<T, U>> FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldVector3D<U> p) {
        super(date, p);
        this.frame = frame;
    }

    private static <T extends CalculusFieldElement<T>> void ensureIdenticalFrames(FieldAbsolutePVCoordinates<T> absPv1, FieldAbsolutePVCoordinates<T> absPv2) throws OrekitIllegalArgumentException {
        if (!absPv1.frame.equals(absPv2.frame)) {
            throw new OrekitIllegalArgumentException(OrekitMessages.INCOMPATIBLE_FRAMES, absPv1.frame.getName(), absPv2.frame.getName());
        }
    }

    @Override
    public FieldAbsolutePVCoordinates<T> shiftedBy(T dt) {
        FieldPVCoordinates spv = super.shiftedBy((CalculusFieldElement)dt);
        return new FieldAbsolutePVCoordinates<T>(this.frame, spv);
    }

    @Override
    public FieldAbsolutePVCoordinates<T> shiftedBy(double dt) {
        FieldPVCoordinates spv = super.shiftedBy(dt);
        return new FieldAbsolutePVCoordinates<T>(this.frame, spv);
    }

    public FieldPVCoordinatesProvider<T> toTaylorProvider() {
        return new FieldPVCoordinatesProvider<T>(){

            @Override
            public FieldVector3D<T> getPosition(FieldAbsoluteDate<T> d, Frame f) {
                TimeStampedFieldPVCoordinates shifted = FieldAbsolutePVCoordinates.this.shiftedBy((CalculusFieldElement)d.durationFrom(FieldAbsolutePVCoordinates.this.getDate()));
                FieldStaticTransform transform = FieldAbsolutePVCoordinates.this.frame.getStaticTransformTo(f, d);
                return transform.transformPosition(shifted.getPosition());
            }

            @Override
            public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> d, Frame f) {
                TimeStampedFieldPVCoordinates shifted = FieldAbsolutePVCoordinates.this.shiftedBy((CalculusFieldElement)d.durationFrom(FieldAbsolutePVCoordinates.this.getDate()));
                FieldTransform transform = FieldAbsolutePVCoordinates.this.frame.getTransformTo(f, d);
                return transform.transformPVCoordinates(shifted);
            }
        };
    }

    public Frame getFrame() {
        return this.frame;
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates() {
        return this;
    }

    public FieldVector3D<T> getPosition(Frame outputFrame) {
        if (outputFrame == this.frame) {
            return this.getPosition();
        }
        FieldStaticTransform t = this.frame.getStaticTransformTo(outputFrame, this.getDate());
        return t.transformPosition(this.getPosition());
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(Frame outputFrame) {
        if (outputFrame == this.frame) {
            return this.getPVCoordinates();
        }
        FieldTransform<T> t = this.frame.getTransformTo(outputFrame, this.getDate());
        return t.transformPVCoordinates(this.getPVCoordinates());
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> otherDate, Frame outputFrame) {
        return ((FieldAbsolutePVCoordinates)this.shiftedBy((CalculusFieldElement)otherDate.durationFrom(this.getDate()))).getPVCoordinates(outputFrame);
    }

    public AbsolutePVCoordinates toAbsolutePVCoordinates() {
        return new AbsolutePVCoordinates(this.frame, this.getDate().toAbsoluteDate(), this.getPVCoordinates().toPVCoordinates());
    }
}

