/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public interface ExtendedPositionProvider
extends PVCoordinatesProvider {
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> getPosition(FieldAbsoluteDate<T> var1, Frame var2);

    @Override
    default public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        UnivariateDerivative2Field ud2Field = UnivariateDerivative2Field.getInstance();
        UnivariateDerivative2 ud2Shift = new UnivariateDerivative2(0.0, 1.0, 0.0);
        FieldTimeShiftable fieldDate = new FieldAbsoluteDate(ud2Field, date).shiftedBy((CalculusFieldElement)ud2Shift);
        FieldVector3D ud2Position = this.getPosition((FieldAbsoluteDate)fieldDate, frame);
        Vector3D position = ud2Position.toVector3D();
        Vector3D velocity = new Vector3D(((UnivariateDerivative2)ud2Position.getX()).getFirstDerivative(), ((UnivariateDerivative2)ud2Position.getY()).getFirstDerivative(), ((UnivariateDerivative2)ud2Position.getZ()).getFirstDerivative());
        Vector3D acceleration = new Vector3D(((UnivariateDerivative2)ud2Position.getX()).getSecondDerivative(), ((UnivariateDerivative2)ud2Position.getY()).getSecondDerivative(), ((UnivariateDerivative2)ud2Position.getZ()).getSecondDerivative());
        return new TimeStampedPVCoordinates(date, new PVCoordinates(position, velocity, acceleration));
    }

    default public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        FieldAbsoluteDate<FieldUnivariateDerivative2<T>> fud2Date = date.toFUD2Field();
        FieldVector3D<FieldUnivariateDerivative2<T>> fud2Position = this.getPosition(fud2Date, frame);
        FieldVector3D position = new FieldVector3D(((FieldUnivariateDerivative2)fud2Position.getX()).getValue(), ((FieldUnivariateDerivative2)fud2Position.getY()).getValue(), ((FieldUnivariateDerivative2)fud2Position.getZ()).getValue());
        FieldVector3D velocity = new FieldVector3D(((FieldUnivariateDerivative2)fud2Position.getX()).getFirstDerivative(), ((FieldUnivariateDerivative2)fud2Position.getY()).getFirstDerivative(), ((FieldUnivariateDerivative2)fud2Position.getZ()).getFirstDerivative());
        FieldVector3D acceleration = new FieldVector3D(((FieldUnivariateDerivative2)fud2Position.getX()).getSecondDerivative(), ((FieldUnivariateDerivative2)fud2Position.getY()).getSecondDerivative(), ((FieldUnivariateDerivative2)fud2Position.getZ()).getSecondDerivative());
        return new TimeStampedFieldPVCoordinates<T>(date, position, velocity, acceleration);
    }

    default public <T extends CalculusFieldElement<T>> FieldPVCoordinatesProvider<T> toFieldPVCoordinatesProvider(Field<T> field) {
        return new FieldPVCoordinatesProvider<T>(){

            @Override
            public FieldVector3D<T> getPosition(FieldAbsoluteDate<T> date, Frame frame) {
                return ExtendedPositionProvider.this.getPosition(date, frame);
            }

            @Override
            public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
                return ExtendedPositionProvider.this.getPVCoordinates(date, frame);
            }
        };
    }
}

