/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.UnivariateVectorFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.StateFunction;
import org.orekit.utils.StateJacobian;

public class Differentiation {
    private static final DSFactory FACTORY = new DSFactory(1, 1);

    private Differentiation() {
    }

    public static ParameterFunction differentiate(final ParameterFunction function, final int nbPoints, final double step) {
        return new ParameterFunction(){
            private final FiniteDifferencesDifferentiator differentiator;
            {
                this.differentiator = new FiniteDifferencesDifferentiator(nbPoints, step);
            }

            @Override
            public double value(final ParameterDriver driver, final AbsoluteDate date) {
                UnivariateFunction uf = new UnivariateFunction(){

                    public double value(double value) {
                        double saved = driver.getValue(date);
                        driver.setValue(value, date);
                        double functionValue = function.value(driver, date);
                        driver.setValue(saved, date);
                        return functionValue;
                    }
                };
                DerivativeStructure dsParam = FACTORY.variable(0, driver.getValue(date));
                DerivativeStructure dsValue = (DerivativeStructure)this.differentiator.differentiate(uf).value((Derivative)dsParam);
                return dsValue.getPartialDerivative(new int[]{1});
            }
        };
    }

    public static StateJacobian differentiate(final StateFunction function, final int dimension, final AttitudeProvider provider, final OrbitType orbitType, final PositionAngleType positionAngleType, final double dP, final int nbPoints) {
        return new StateJacobian(){

            @Override
            public double[][] value(SpacecraftState state) {
                double[] tolerances = NumericalPropagator.tolerances(dP, state.getOrbit(), orbitType)[0];
                double[][] jacobian = new double[dimension][6];
                for (int j = 0; j < 6; ++j) {
                    StateComponentFunction componentJ = new StateComponentFunction(j, function, provider, state, orbitType, positionAngleType);
                    FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(nbPoints, tolerances[j]);
                    UnivariateDifferentiableVectorFunction differentiatedJ = differentiator.differentiate((UnivariateVectorFunction)componentJ);
                    DerivativeStructure[] c = (DerivativeStructure[])differentiatedJ.value((Derivative)FACTORY.variable(0, 0.0));
                    for (int i = 0; i < dimension; ++i) {
                        jacobian[i][j] = c[i].getPartialDerivative(new int[]{1});
                    }
                }
                return jacobian;
            }
        };
    }

    private static class StateComponentFunction
    implements UnivariateVectorFunction {
        private final int index;
        private final StateFunction f;
        private final OrbitType orbitType;
        private final PositionAngleType positionAngleType;
        private final SpacecraftState baseState;
        private final AttitudeProvider provider;

        StateComponentFunction(int index, StateFunction f, AttitudeProvider provider, SpacecraftState baseState, OrbitType orbitType, PositionAngleType positionAngleType) {
            this.index = index;
            this.f = f;
            this.provider = provider;
            this.orbitType = orbitType;
            this.positionAngleType = positionAngleType;
            this.baseState = baseState;
        }

        public double[] value(double x) {
            double[] array = new double[6];
            double[] arrayDot = new double[6];
            this.orbitType.mapOrbitToArray(this.baseState.getOrbit(), this.positionAngleType, array, arrayDot);
            int n = this.index;
            array[n] = array[n] + x;
            Orbit orbit = this.orbitType.mapArrayToOrbit(array, arrayDot, this.positionAngleType, this.baseState.getDate(), this.baseState.getMu(), this.baseState.getFrame());
            SpacecraftState state = new SpacecraftState(orbit, this.provider.getAttitude(orbit, orbit.getDate(), orbit.getFrame()), this.baseState.getMass());
            return this.f.value(state);
        }
    }
}

