/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ConstantPVCoordinatesProvider
implements PVCoordinatesProvider {
    private final PVCoordinates pva;
    private final Frame sourceFrame;

    public ConstantPVCoordinatesProvider(Vector3D pos, Frame frame) {
        this(new PVCoordinates(pos), frame);
    }

    public ConstantPVCoordinatesProvider(GeodeticPoint pos, OneAxisEllipsoid body) {
        this(body.transform(pos), body.getBodyFrame());
    }

    public ConstantPVCoordinatesProvider(PVCoordinates pva, Frame frame) {
        this.pva = pva;
        this.sourceFrame = frame;
    }

    @Override
    public Vector3D getPosition(AbsoluteDate date, Frame frame) {
        return this.sourceFrame.getStaticTransformTo(frame, date).transformPosition(this.pva.getPosition());
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        PVCoordinates pv = this.sourceFrame.getTransformTo(frame, date).transformPVCoordinates(this.pva);
        return new TimeStampedPVCoordinates(date, pv);
    }
}

