/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.frames.Frame;
import org.orekit.frames.KinematicTransform;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class CartesianCovarianceUtils {
    private CartesianCovarianceUtils() {
    }

    public static RealMatrix changeReferenceFrame(Frame inputFrame, RealMatrix covarianceMatrix, AbsoluteDate date, Frame outputFrame) {
        KinematicTransform kinematicTransform = inputFrame.getKinematicTransformTo(outputFrame, date);
        return CartesianCovarianceUtils.changePositionVelocityFrame(covarianceMatrix, kinematicTransform);
    }

    public static RealMatrix convertToLofType(Vector3D position, Vector3D velocity, RealMatrix covarianceMatrix, LOFType lofType) {
        Transform transformFromInertial = CartesianCovarianceUtils.transformToLofType(lofType, position, velocity);
        return CartesianCovarianceUtils.changePositionVelocityFrame(covarianceMatrix, transformFromInertial);
    }

    public static RealMatrix convertFromLofType(LOFType lofType, RealMatrix covarianceMatrix, Vector3D position, Vector3D velocity) {
        Transform transformFromInertial = CartesianCovarianceUtils.transformToLofType(lofType, position, velocity);
        return CartesianCovarianceUtils.changePositionVelocityFrame(covarianceMatrix, transformFromInertial.getInverse());
    }

    private static Transform transformToLofType(LOFType lofType, Vector3D position, Vector3D velocity) {
        return lofType.transformFromInertial(null, new PVCoordinates(position, velocity));
    }

    private static RealMatrix changePositionVelocityFrame(RealMatrix covarianceMatrix, KinematicTransform kinematicTransform) {
        RealMatrix jacobianTransformPV = MatrixUtils.createRealMatrix((double[][])kinematicTransform.getPVJacobian());
        return jacobianTransformPV.multiply(covarianceMatrix.multiplyTransposed(jacobianTransformPV));
    }
}

