/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Objects;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AggregatedPVCoordinatesProvider
implements PVCoordinatesProvider {
    private final TimeSpanMap<PVCoordinatesProvider> pvProvMap;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;

    public AggregatedPVCoordinatesProvider(TimeSpanMap<PVCoordinatesProvider> map) {
        this(map, null, null);
    }

    public AggregatedPVCoordinatesProvider(TimeSpanMap<PVCoordinatesProvider> map, AbsoluteDate minDate, AbsoluteDate maxDate) {
        this.pvProvMap = Objects.requireNonNull(map, "PVCoordinatesProvider map must be non-null");
        this.minDate = minDate == null ? AbsoluteDate.PAST_INFINITY : minDate;
        this.maxDate = maxDate == null ? AbsoluteDate.FUTURE_INFINITY : maxDate;
    }

    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Vector3D getPosition(AbsoluteDate date, Frame frame) {
        if (date.isBefore(this.minDate) || date.isAfter(this.maxDate)) {
            throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_DATE, date, this.minDate, this.maxDate);
        }
        return this.pvProvMap.get(date).getPosition(date, frame);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        if (date.isBefore(this.minDate) || date.isAfter(this.maxDate)) {
            throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_DATE, date, this.minDate, this.maxDate);
        }
        return this.pvProvMap.get(date).getPVCoordinates(date, frame);
    }

    public static class InvalidPVProvider
    implements PVCoordinatesProvider {
        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
            throw new IllegalStateException();
        }
    }

    public static class Builder {
        private TimeSpanMap<PVCoordinatesProvider> pvProvMap = null;

        public Builder() {
            this(new InvalidPVProvider());
        }

        public Builder(PVCoordinatesProvider initialProvider) {
            this.pvProvMap = new TimeSpanMap<PVCoordinatesProvider>(initialProvider);
        }

        public Builder addPVProviderAfter(AbsoluteDate date, PVCoordinatesProvider pvProv, boolean erasesLater) {
            this.pvProvMap.addValidAfter(pvProv, date, erasesLater);
            return this;
        }

        public Builder addPVProviderBefore(AbsoluteDate date, PVCoordinatesProvider pvProv, boolean erasesEarlier) {
            this.pvProvMap.addValidBefore(pvProv, date, erasesEarlier);
            return this;
        }

        public Builder invalidBefore(AbsoluteDate firstValidDate) {
            this.pvProvMap.addValidBefore(new InvalidPVProvider(), firstValidDate, true);
            return this;
        }

        public Builder invalidAfter(AbsoluteDate lastValidDate) {
            this.pvProvMap.addValidAfter(new InvalidPVProvider(), lastValidDate, true);
            return this;
        }

        public AggregatedPVCoordinatesProvider build() {
            AbsoluteDate minDate = null;
            AbsoluteDate maxDate = null;
            if (this.pvProvMap.getFirstTransition() != null && this.pvProvMap.getFirstTransition().getBefore() instanceof InvalidPVProvider) {
                minDate = this.pvProvMap.getFirstTransition().getDate();
            }
            if (this.pvProvMap.getLastTransition() != null && this.pvProvMap.getLastTransition().getAfter() instanceof InvalidPVProvider) {
                maxDate = this.pvProvMap.getLastTransition().getDate();
            }
            return new AggregatedPVCoordinatesProvider(this.pvProvMap, minDate, maxDate);
        }
    }
}

