/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.MultipleShooting;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractMultipleShooting
implements MultipleShooting {
    private final List<SpacecraftState> patchedSpacecraftStates;
    private final List<NumericalPropagator> propagatorList;
    private final double[] propagationTime;
    private final boolean[] freeCompsMap;
    private final boolean[] freeEpochMap;
    private int nComps;
    private final int nDuration;
    private int nEpoch;
    private double scaleTime;
    private double scaleLength;
    private final Map<Integer, Double> mapConstraints;
    private final boolean isAutonomous;
    private final double tolerance;
    private final int maxIter;
    private final String additionalName;

    protected AbstractMultipleShooting(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, double tolerance, int maxIter, boolean isAutonomous, String additionalName) {
        this.patchedSpacecraftStates = initialGuessList;
        this.propagatorList = propagatorList;
        this.isAutonomous = isAutonomous;
        this.additionalName = additionalName;
        int propagationNumber = initialGuessList.size() - 1;
        this.propagationTime = new double[propagationNumber];
        for (int i = 0; i < propagationNumber; ++i) {
            this.propagationTime[i] = initialGuessList.get(i + 1).getDate().durationFrom(initialGuessList.get(i).getDate());
        }
        this.freeCompsMap = new boolean[6 * initialGuessList.size()];
        Arrays.fill(this.freeCompsMap, true);
        if (isAutonomous) {
            this.freeEpochMap = new boolean[0];
        } else {
            this.freeEpochMap = new boolean[initialGuessList.size()];
            Arrays.fill(this.freeEpochMap, true);
        }
        this.nComps = 6 * initialGuessList.size();
        this.nDuration = propagationNumber;
        this.nEpoch = this.freeEpochMap.length;
        this.tolerance = tolerance;
        this.maxIter = maxIter;
        this.scaleTime = 1.0;
        this.scaleLength = 1.0;
        this.mapConstraints = new HashMap<Integer, Double>();
    }

    protected SpacecraftState getPatchPoint(int i) {
        return this.patchedSpacecraftStates.get(i);
    }

    public void setPatchPointComponentFreedom(int patchIndex, int componentIndex, boolean isFree) {
        if (this.freeCompsMap[6 * patchIndex + componentIndex] != isFree) {
            this.freeCompsMap[6 * patchIndex + componentIndex] = isFree;
            this.nComps += isFree ? 1 : -1;
        }
    }

    public void setEpochFreedom(int patchIndex, boolean isFree) {
        if (this.freeEpochMap[patchIndex] != isFree) {
            this.freeEpochMap[patchIndex] = isFree;
            this.nEpoch += isFree ? 1 : -1;
        }
    }

    public void setScaleTime(double scaleTime) {
        this.scaleTime = scaleTime;
    }

    public void setScaleLength(double scaleLength) {
        this.scaleLength = scaleLength;
    }

    public void addConstraint(int patchIndex, int componentIndex, double constraintValue) {
        this.mapConstraints.put(patchIndex * 6 + componentIndex, constraintValue);
    }

    @Override
    public List<SpacecraftState> compute() {
        int iter = 0;
        while (iter < this.maxIter) {
            RealVector dx;
            ++iter;
            List<SpacecraftState> propagatedSP = this.propagatePatchedSpacecraftState();
            RealVector fx = MatrixUtils.createRealVector((double[])this.computeConstraint(propagatedSP));
            double fxNorm = fx.getNorm();
            if (fxNorm < this.tolerance) break;
            RealMatrix M = this.computeJacobianMatrix(propagatedSP);
            RealMatrix MMt = M.multiplyTransposed(M);
            try {
                dx = M.transpose().operate(new LUDecomposition(MMt, 0.0).getSolver().solve(fx));
            }
            catch (MathIllegalArgumentException e) {
                dx = M.transpose().operate(new QRDecomposition(MMt, 0.0).getSolver().solve(fx));
            }
            this.updateTrajectory(dx);
        }
        return this.patchedSpacecraftStates;
    }

    private RealMatrix computeJacobianMatrix(List<SpacecraftState> propagatedSP) {
        double[][] subF;
        int nArcs = this.patchedSpacecraftStates.size() - 1;
        double scaleVel = this.scaleLength / this.scaleTime;
        double scaleAcc = scaleVel / this.scaleTime;
        RealMatrix M = MatrixUtils.createRealMatrix((int)this.getNumberOfConstraints(), (int)this.getNumberOfFreeVariables());
        int index = 0;
        int indexDuration = this.nComps;
        int indexEpoch = indexDuration + this.nDuration;
        for (int i = 0; i < nArcs; ++i) {
            SpacecraftState finalState = propagatedSP.get(i);
            TimeStampedPVCoordinates pvf = finalState.getPVCoordinates();
            double[][] phi = this.getStateTransitionMatrix(finalState);
            for (int j = 0; j < 6; ++j) {
                if (!this.freeCompsMap[6 * i + j]) continue;
                for (int k = 0; k < 6; ++k) {
                    M.setEntry(6 * i + k, index, phi[k][j]);
                }
                if (i > 0) {
                    M.setEntry(6 * (i - 1) + j, index, -1.0);
                }
                ++index;
            }
            double[][] pvfArray = new double[][]{{pvf.getVelocity().getX() / scaleVel}, {pvf.getVelocity().getY() / scaleVel}, {pvf.getVelocity().getZ() / scaleVel}, {pvf.getAcceleration().getX() / scaleAcc}, {pvf.getAcceleration().getY() / scaleAcc}, {pvf.getAcceleration().getZ() / scaleAcc}};
            M.setSubMatrix((double[][])pvfArray, 6 * i, indexDuration);
            ++indexDuration;
            if (this.isAutonomous || !this.freeEpochMap[i]) continue;
            double[] derivatives = finalState.getAdditionalState(this.additionalName);
            double[][] subC = new double[6][1];
            for (int j = 0; j < 3; ++j) {
                subC[j][0] = derivatives[derivatives.length - 6 + j] / scaleVel;
                subC[j + 3][0] = derivatives[derivatives.length - 3 + j] / scaleAcc;
            }
            M.setSubMatrix(subC, 6 * i, indexEpoch);
            ++indexEpoch;
        }
        for (int j = 0; j < 6; ++j) {
            if (!this.freeCompsMap[6 * nArcs + j]) continue;
            M.setEntry(6 * (nArcs - 1) + j, index, -1.0);
            ++index;
        }
        if (!this.isAutonomous) {
            double[][] subDE = this.computeEpochJacobianMatrix(propagatedSP);
            M.setSubMatrix(subDE, 6 * nArcs, this.nComps);
        }
        if ((subF = this.computeAdditionalJacobianMatrix(propagatedSP)).length > 0) {
            M.setSubMatrix(subF, this.isAutonomous ? 6 * nArcs : 7 * nArcs, 0);
        }
        return M;
    }

    private double[] computeConstraint(List<SpacecraftState> propagatedSP) {
        double[] additionalConstraints;
        int nPoints = this.patchedSpacecraftStates.size();
        double scaleVel = this.scaleLength / this.scaleTime;
        double[] fx = new double[this.getNumberOfConstraints()];
        for (int i = 0; i < nPoints - 1; ++i) {
            AbsolutePVCoordinates absPvi = this.patchedSpacecraftStates.get(i + 1).getAbsPVA();
            AbsolutePVCoordinates absPvf = propagatedSP.get(i).getAbsPVA();
            double[] deltaPos = absPvf.getPosition().subtract((Vector)absPvi.getPosition()).toArray();
            double[] deltaVel = absPvf.getVelocity().subtract((Vector)absPvi.getVelocity()).toArray();
            for (int j = 0; j < 3; ++j) {
                fx[6 * i + j] = deltaPos[j] / this.scaleLength;
                fx[6 * i + 3 + j] = deltaVel[j] / scaleVel;
            }
        }
        int index = 6 * (nPoints - 1);
        if (!this.isAutonomous) {
            for (int i = 0; i < nPoints - 1; ++i) {
                double deltaEpoch = this.patchedSpacecraftStates.get(i + 1).getDate().durationFrom(this.patchedSpacecraftStates.get(i).getDate());
                fx[index] = (deltaEpoch - this.propagationTime[i]) / this.scaleTime;
                ++index;
            }
        }
        double[] dArray = additionalConstraints = this.computeAdditionalConstraints(propagatedSP);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double constraint;
            fx[index] = constraint = dArray[i];
            ++index;
        }
        return fx;
    }

    private void updateTrajectory(RealVector dx) {
        double scaleVel = this.scaleLength / this.scaleTime;
        int indexDuration = this.nComps;
        int i = 0;
        while (i < this.nDuration) {
            int n = i++;
            this.propagationTime[n] = this.propagationTime[n] - dx.getEntry(indexDuration) * this.scaleTime;
            ++indexDuration;
        }
        int index = 0;
        int indexEpoch = this.nComps + this.nDuration;
        for (int i2 = 0; i2 < this.patchedSpacecraftStates.size(); ++i2) {
            double[] deltaPV = new double[6];
            for (int j = 0; j < 6; ++j) {
                if (!this.freeCompsMap[6 * i2 + j]) continue;
                deltaPV[j] = dx.getEntry(index);
                ++index;
            }
            Vector3D deltaP = new Vector3D(deltaPV[0], deltaPV[1], deltaPV[2]).scalarMultiply(this.scaleLength);
            Vector3D deltaV = new Vector3D(deltaPV[3], deltaPV[4], deltaPV[5]).scalarMultiply(scaleVel);
            AbsolutePVCoordinates currentAPV = this.patchedSpacecraftStates.get(i2).getAbsPVA();
            Vector3D position = currentAPV.getPosition().subtract((Vector)deltaP);
            Vector3D velocity = currentAPV.getVelocity().subtract((Vector)deltaV);
            PVCoordinates pv = new PVCoordinates(position, velocity);
            AbsoluteDate epoch = currentAPV.getDate();
            if (!this.isAutonomous) {
                if (this.freeEpochMap[i2]) {
                    epoch = epoch.shiftedBy(-dx.getEntry(indexEpoch) * this.scaleTime);
                    ++indexEpoch;
                }
            } else if (i2 > 0) {
                epoch = this.patchedSpacecraftStates.get(i2 - 1).getDate().shiftedBy(this.propagationTime[i2 - 1]);
            }
            AbsolutePVCoordinates updatedAPV = new AbsolutePVCoordinates(currentAPV.getFrame(), epoch, pv);
            int iAttitude = i2 < this.getPropagatorList().size() ? i2 : this.getPropagatorList().size() - 1;
            AttitudeProvider attitudeProvider = this.getPropagatorList().get(iAttitude).getAttitudeProvider();
            Attitude attitude = attitudeProvider.getAttitude(updatedAPV, epoch, currentAPV.getFrame());
            this.patchedSpacecraftStates.set(i2, new SpacecraftState(updatedAPV, attitude));
        }
    }

    private List<SpacecraftState> propagatePatchedSpacecraftState() {
        int nArcs = this.patchedSpacecraftStates.size() - 1;
        ArrayList<SpacecraftState> propagatedSP = new ArrayList<SpacecraftState>(nArcs);
        for (int i = 0; i < nArcs; ++i) {
            SpacecraftState augmentedInitialState = this.getAugmentedInitialState(i);
            this.propagatorList.get(i).setInitialState(augmentedInitialState);
            AbsoluteDate target = augmentedInitialState.getDate().shiftedBy(this.propagationTime[i]);
            SpacecraftState finalState = this.propagatorList.get(i).propagate(target);
            propagatedSP.add(finalState);
        }
        return propagatedSP;
    }

    private double[][] getStateTransitionMatrix(SpacecraftState s) {
        DoubleArrayDictionary dictionary = s.getAdditionalStatesValues();
        int dim = 6;
        double[][] phiM = new double[6][6];
        for (DoubleArrayDictionary.Entry entry : dictionary.getData()) {
            String name = entry.getKey();
            if (!this.additionalName.equals(name)) continue;
            double[] stm = entry.getValue();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    phiM[i][j] = stm[6 * i + j];
                    phiM[i][j + 3] = stm[6 * i + j + 3] / this.scaleTime;
                    phiM[i + 3][j] = stm[6 * i + j + 18] * this.scaleTime;
                    phiM[i + 3][j + 3] = stm[6 * i + j + 21];
                }
            }
        }
        return phiM;
    }

    protected double[][] computeEpochJacobianMatrix(List<SpacecraftState> propagatedSP) {
        int nRows = this.patchedSpacecraftStates.size() - 1;
        double[][] M = new double[nRows][this.nDuration + this.nEpoch];
        int index = this.nDuration;
        for (int i = 0; i < nRows; ++i) {
            M[i][i] = -1.0;
            if (this.freeEpochMap[i]) {
                M[i][index] = -1.0;
                ++index;
            }
            if (!this.freeEpochMap[i + 1]) continue;
            M[i][index] = 1.0;
        }
        return M;
    }

    protected void updateAdditionalConstraints(int startIndex, double[] fxAdditional) {
        int iter = startIndex;
        double scaleVel = this.scaleLength / this.scaleTime;
        for (Map.Entry<Integer, Double> entry : this.getConstraintsMap().entrySet()) {
            int key = entry.getKey();
            double value = entry.getValue();
            int np = key / 6;
            int nc = key % 6;
            AbsolutePVCoordinates absPv = this.getPatchedSpacecraftState().get(np).getAbsPVA();
            fxAdditional[iter] = nc < 3 ? (absPv.getPosition().toArray()[nc] - value) / this.scaleLength : (absPv.getVelocity().toArray()[nc - 3] - value) / scaleVel;
            ++iter;
        }
    }

    protected abstract double[] computeAdditionalConstraints(List<SpacecraftState> var1);

    protected abstract double[][] computeAdditionalJacobianMatrix(List<SpacecraftState> var1);

    protected abstract SpacecraftState getAugmentedInitialState(int var1);

    protected int getNumberOfFreeComponents() {
        return this.nComps;
    }

    protected int getNumberOfConstraints() {
        int nArcs = this.patchedSpacecraftStates.size() - 1;
        return (this.isAutonomous ? 6 * nArcs : 7 * nArcs) + this.mapConstraints.size();
    }

    protected boolean[] getFreeCompsMap() {
        return this.freeCompsMap;
    }

    protected Map<Integer, Double> getConstraintsMap() {
        return this.mapConstraints;
    }

    protected List<SpacecraftState> getPatchedSpacecraftState() {
        return this.patchedSpacecraftStates;
    }

    private List<NumericalPropagator> getPropagatorList() {
        return this.propagatorList;
    }

    private int getNumberOfFreeVariables() {
        return this.nComps + this.nDuration + this.nEpoch;
    }
}

