/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.CartesianDerivativesFilter;

public class AbsolutePVCoordinatesHermiteInterpolator
extends AbstractTimeInterpolator<AbsolutePVCoordinates> {
    private final CartesianDerivativesFilter filter;
    private final Frame outputFrame;

    public AbsolutePVCoordinatesHermiteInterpolator(Frame outputFrame) {
        this(2, 0.001, outputFrame, CartesianDerivativesFilter.USE_PVA);
    }

    public AbsolutePVCoordinatesHermiteInterpolator(int interpolationPoints, Frame outputFrame) {
        this(interpolationPoints, 0.001, outputFrame, CartesianDerivativesFilter.USE_PVA);
    }

    public AbsolutePVCoordinatesHermiteInterpolator(int interpolationPoints, Frame outputFrame, CartesianDerivativesFilter filter) {
        this(interpolationPoints, 0.001, outputFrame, filter);
    }

    public AbsolutePVCoordinatesHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, CartesianDerivativesFilter filter) {
        super(interpolationPoints, extrapolationThreshold);
        this.outputFrame = outputFrame;
        this.filter = filter;
    }

    public CartesianDerivativesFilter getFilter() {
        return this.filter;
    }

    public Frame getOutputFrame() {
        return this.outputFrame;
    }

    @Override
    protected AbsolutePVCoordinates interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        AbsoluteDate date = interpolationData.getInterpolationDate();
        List<AbsolutePVCoordinates> sample = interpolationData.getNeighborList();
        HermiteInterpolator interpolator = new HermiteInterpolator();
        switch (this.filter) {
            case USE_P: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray()});
                });
                break;
            }
            case USE_PV: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray(), velocity.toArray()});
                });
                break;
            }
            case USE_PVA: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    Vector3D acceleration = pv.getAcceleration();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray(), velocity.toArray(), acceleration.toArray()});
                });
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        double[][] pva = interpolator.derivatives(0.0, 2);
        return new AbsolutePVCoordinates(this.outputFrame, date, new Vector3D(pva[0]), new Vector3D(pva[1]), new Vector3D(pva[2]));
    }
}

