/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.OffsetModel;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.UTCTAIOffset;

public class UTCScale
implements TimeScale {
    private static final long serialVersionUID = 20230302L;
    private final TimeScale tai;
    private final Collection<? extends OffsetModel> baseOffsets;
    private final UTCTAIOffset[] offsets;

    UTCScale(TimeScale tai, Collection<? extends OffsetModel> baseOffsets) {
        this.tai = tai;
        this.baseOffsets = baseOffsets;
        ArrayList<? extends OffsetModel> offsetModels = new ArrayList<OffsetModel>(baseOffsets);
        offsetModels.sort(Comparator.comparing(OffsetModel::getStart));
        if (((OffsetModel)offsetModels.get(0)).getStart().getYear() > 1968) {
            offsetModels.add(0, new OffsetModel(new DateComponents(1961, 1, 1), 37300, 1.422818, 0.001296));
            offsetModels.add(1, new OffsetModel(new DateComponents(1961, 8, 1), 37300, 1.372818, 0.001296));
            offsetModels.add(2, new OffsetModel(new DateComponents(1962, 1, 1), 37665, 1.845858, 0.0011232));
            offsetModels.add(3, new OffsetModel(new DateComponents(1963, 11, 1), 37665, 1.945858, 0.0011232));
            offsetModels.add(4, new OffsetModel(new DateComponents(1964, 1, 1), 38761, 3.24013, 0.001296));
            offsetModels.add(5, new OffsetModel(new DateComponents(1964, 4, 1), 38761, 3.34013, 0.001296));
            offsetModels.add(6, new OffsetModel(new DateComponents(1964, 9, 1), 38761, 3.44013, 0.001296));
            offsetModels.add(7, new OffsetModel(new DateComponents(1965, 1, 1), 38761, 3.54013, 0.001296));
            offsetModels.add(8, new OffsetModel(new DateComponents(1965, 3, 1), 38761, 3.64013, 0.001296));
            offsetModels.add(9, new OffsetModel(new DateComponents(1965, 7, 1), 38761, 3.74013, 0.001296));
            offsetModels.add(10, new OffsetModel(new DateComponents(1965, 9, 1), 38761, 3.84013, 0.001296));
            offsetModels.add(11, new OffsetModel(new DateComponents(1966, 1, 1), 39126, 4.31317, 0.002592));
            offsetModels.add(12, new OffsetModel(new DateComponents(1968, 2, 1), 39126, 4.21317, 0.002592));
        }
        this.offsets = new UTCTAIOffset[offsetModels.size()];
        UTCTAIOffset previous = null;
        for (int i = 0; i < offsetModels.size(); ++i) {
            OffsetModel o = (OffsetModel)offsetModels.get(i);
            DateComponents date = o.getStart();
            int mjdRef = o.getMJDRef();
            double offset = o.getOffset();
            double slope = o.getSlope();
            double previousOffset = previous == null ? 0.0 : previous.getOffset(date, TimeComponents.H00);
            AbsoluteDate leapStart = new AbsoluteDate(date, tai).shiftedBy(previousOffset);
            double startOffset = offset + slope * (double)(date.getMJD() - mjdRef);
            AbsoluteDate leapEnd = new AbsoluteDate(date, tai).shiftedBy(startOffset);
            double normalizedSlope = slope / 86400.0;
            double leap = leapEnd.durationFrom(leapStart) / (1.0 + normalizedSlope);
            AbsoluteDate reference = AbsoluteDate.createMJDDate(mjdRef, 0.0, tai).shiftedBy(offset);
            this.offsets[i] = previous = new UTCTAIOffset(leapStart, date.getMJD(), leap, offset, mjdRef, normalizedSlope, reference);
        }
    }

    public Collection<? extends OffsetModel> getBaseOffsets() {
        return this.baseOffsets;
    }

    public List<UTCTAIOffset> getUTCTAIOffsets() {
        ArrayList<UTCTAIOffset> offsetList = new ArrayList<UTCTAIOffset>(this.offsets.length);
        for (int i = 0; i < this.offsets.length; ++i) {
            offsetList.add(this.offsets[i]);
        }
        return offsetList;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        int offsetIndex = this.findOffsetIndex(date);
        if (offsetIndex < 0) {
            return 0.0;
        }
        return -this.offsets[offsetIndex].getOffset(date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        int offsetIndex = this.findOffsetIndex(date.toAbsoluteDate());
        if (offsetIndex < 0) {
            return (T)((CalculusFieldElement)date.getField().getZero());
        }
        return (T)((CalculusFieldElement)this.offsets[offsetIndex].getOffset(date).negate());
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        int minuteInDay = time.getHour() * 60 + time.getMinute() - time.getMinutesFromUTC();
        int correction = minuteInDay < 0 ? (minuteInDay - 1439) / 1440 : minuteInDay / 1440;
        int mjd = date.getMJD() + correction;
        UTCTAIOffset offset = this.findOffset(mjd);
        if (offset == null) {
            return 0.0;
        }
        return offset.getOffset(date, time);
    }

    @Override
    public String getName() {
        return "UTC";
    }

    public String toString() {
        return this.getName();
    }

    public AbsoluteDate getFirstKnownLeapSecond() {
        return this.offsets[0].getDate();
    }

    public AbsoluteDate getLastKnownLeapSecond() {
        return this.offsets[this.offsets.length - 1].getDate();
    }

    @Override
    public boolean insideLeap(AbsoluteDate date) {
        int offsetIndex = this.findOffsetIndex(date);
        if (offsetIndex < 0) {
            return false;
        }
        return date.compareTo(this.offsets[offsetIndex].getValidityStart()) < 0;
    }

    @Override
    public <T extends CalculusFieldElement<T>> boolean insideLeap(FieldAbsoluteDate<T> date) {
        return this.insideLeap(date.toAbsoluteDate());
    }

    @Override
    public int minuteDuration(AbsoluteDate date) {
        int offsetIndex = this.findOffsetIndex(date);
        UTCTAIOffset offset = offsetIndex >= 0 && date.compareTo(this.offsets[offsetIndex].getValidityStart()) < 0 ? this.offsets[offsetIndex] : (offsetIndex + 1 < this.offsets.length && this.offsets[offsetIndex + 1].getDate().durationFrom(date) <= 60.0 ? this.offsets[offsetIndex + 1] : null);
        if (offset != null) {
            return 60 + (int)FastMath.ceil((double)offset.getLeap());
        }
        return 60;
    }

    @Override
    public <T extends CalculusFieldElement<T>> int minuteDuration(FieldAbsoluteDate<T> date) {
        return this.minuteDuration(date.toAbsoluteDate());
    }

    @Override
    public double getLeap(AbsoluteDate date) {
        int offsetIndex = this.findOffsetIndex(date);
        if (offsetIndex < 0) {
            return 0.0;
        }
        return this.offsets[offsetIndex].getLeap();
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getLeap(FieldAbsoluteDate<T> date) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(this.getLeap(date.toAbsoluteDate())));
    }

    private int findOffsetIndex(AbsoluteDate date) {
        int inf = 0;
        int sup = this.offsets.length;
        while (sup - inf > 1) {
            int middle = inf + sup >>> 1;
            if (date.compareTo(this.offsets[middle].getDate()) < 0) {
                sup = middle;
                continue;
            }
            inf = middle;
        }
        if (sup == this.offsets.length) {
            return this.offsets.length - 1;
        }
        if (date.compareTo(this.offsets[inf].getDate()) < 0) {
            return -1;
        }
        return inf;
    }

    private UTCTAIOffset findOffset(int mjd) {
        int inf = 0;
        int sup = this.offsets.length;
        while (sup - inf > 1) {
            int middle = inf + sup >>> 1;
            if (mjd < this.offsets[middle].getMJD()) {
                sup = middle;
                continue;
            }
            inf = middle;
        }
        if (sup == this.offsets.length) {
            return this.offsets[this.offsets.length - 1];
        }
        if (mjd < this.offsets[inf].getMJD()) {
            return null;
        }
        return this.offsets[inf];
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.tai, this.baseOffsets);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20230302L;
        private final TimeScale tai;
        private final Collection<? extends OffsetModel> baseOffsets;

        DataTransferObject(TimeScale tai, Collection<? extends OffsetModel> baseOffsets) {
            this.tai = tai;
            this.baseOffsets = baseOffsets;
        }

        private Object readResolve() {
            try {
                return new UTCScale(this.tai, this.baseOffsets);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

