/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class TimeStampedPair<K extends TimeStamped, V extends TimeStamped>
implements TimeStamped {
    public static final double DEFAULT_DATE_EQUALITY_THRESHOLD = 1.0E-9;
    private final K first;
    private final V second;

    public TimeStampedPair(K first, V second) {
        this(first, second, 1.0E-9);
    }

    public TimeStampedPair(K first, V second, double dateEqualityThreshold) {
        TimeStampedPair.checkDatesConsistency(first.getDate(), second.getDate(), dateEqualityThreshold);
        this.first = first;
        this.second = second;
    }

    public static void checkDatesConsistency(AbsoluteDate firstDate, AbsoluteDate secondDate, double dateEqualityThreshold) {
        if (!firstDate.isCloseTo(secondDate, dateEqualityThreshold)) {
            throw new OrekitIllegalArgumentException(OrekitMessages.DATES_MISMATCH, firstDate, secondDate);
        }
    }

    @Override
    public AbsoluteDate getDate() {
        return this.first.getDate();
    }

    public K getFirst() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }
}

