/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.util.MathArrays;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeStampedField;

public class TimeStampedFieldHermiteInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldTimeInterpolator<TimeStampedField<KK>, KK> {
    public TimeStampedFieldHermiteInterpolator() {
        this(2);
    }

    public TimeStampedFieldHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, 0.001);
    }

    public TimeStampedFieldHermiteInterpolator(int interpolationPoints, double extrapolationThreshold) {
        super(interpolationPoints, extrapolationThreshold);
    }

    @Override
    protected TimeStampedField<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        Field field = interpolationData.getField();
        Object zero = interpolationData.getZero();
        FieldAbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List neighborList = interpolationData.getNeighborList();
        for (TimeStampedField value : neighborList) {
            Object deltaT = value.getDate().durationFrom(interpolationDate);
            CalculusFieldElement[] tempArray = (CalculusFieldElement[])MathArrays.buildArray(field, (int)1);
            tempArray[0] = value.getValue();
            interpolator.addSamplePoint(deltaT, (FieldElement[][])new CalculusFieldElement[][]{tempArray});
        }
        return new TimeStampedField<CalculusFieldElement>(((CalculusFieldElement[])interpolator.value(zero))[0], interpolationDate);
    }
}

