/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.List;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.time.TimeStampedDouble;

public class TimeStampedDoubleHermiteInterpolator
extends AbstractTimeInterpolator<TimeStampedDouble> {
    public TimeStampedDoubleHermiteInterpolator() {
        this(2);
    }

    public TimeStampedDoubleHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, 0.001);
    }

    public TimeStampedDoubleHermiteInterpolator(int interpolationPoints, double extrapolationThreshold) {
        super(interpolationPoints, extrapolationThreshold);
    }

    @Override
    protected TimeStampedDouble interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        HermiteInterpolator interpolator = new HermiteInterpolator();
        AbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List neighborList = interpolationData.getNeighborList();
        for (TimeStampedDouble value : neighborList) {
            double deltaT = value.getDate().durationFrom(interpolationDate);
            interpolator.addSamplePoint(deltaT, (double[][])new double[][]{{value.getValue()}});
        }
        return new TimeStampedDouble(interpolator.value(0.0)[0], interpolationDate);
    }
}

