/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.List;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.time.TimeStampedDoubleAndDerivative;

public class TimeStampedDoubleAndDerivativeHermiteInterpolator
extends AbstractTimeInterpolator<TimeStampedDoubleAndDerivative> {
    public TimeStampedDoubleAndDerivativeHermiteInterpolator() {
        this(2);
    }

    public TimeStampedDoubleAndDerivativeHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, 0.001);
    }

    public TimeStampedDoubleAndDerivativeHermiteInterpolator(int interpolationPoints, double extrapolationThreshold) {
        super(interpolationPoints, extrapolationThreshold);
    }

    @Override
    protected TimeStampedDoubleAndDerivative interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        HermiteInterpolator interpolator = new HermiteInterpolator();
        AbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List neighborList = interpolationData.getNeighborList();
        for (TimeStampedDoubleAndDerivative value : neighborList) {
            double deltaT = value.getDate().durationFrom(interpolationDate);
            interpolator.addSamplePoint(deltaT, (double[][])new double[][]{{value.getValue()}, {value.getDerivative()}});
        }
        double[][] y = interpolator.derivatives(0.0, 1);
        return new TimeStampedDoubleAndDerivative(y[0][0], y[1][0], interpolationDate);
    }
}

