/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.Collection;
import java.util.function.BiFunction;
import org.orekit.frames.EOPEntry;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.BDTScale;
import org.orekit.time.GLONASSScale;
import org.orekit.time.GMSTScale;
import org.orekit.time.GPSScale;
import org.orekit.time.GalileoScale;
import org.orekit.time.IRNSSScale;
import org.orekit.time.OffsetModel;
import org.orekit.time.PreloadedTimeScales;
import org.orekit.time.QZSSScale;
import org.orekit.time.TAIScale;
import org.orekit.time.TCBScale;
import org.orekit.time.TCGScale;
import org.orekit.time.TDBScale;
import org.orekit.time.TTScale;
import org.orekit.time.UT1Scale;
import org.orekit.time.UTCScale;
import org.orekit.utils.IERSConventions;

public interface TimeScales {
    public TAIScale getTAI();

    public UTCScale getUTC();

    public UT1Scale getUT1(IERSConventions var1, boolean var2);

    public TTScale getTT();

    public GalileoScale getGST();

    public GLONASSScale getGLONASS();

    public QZSSScale getQZSS();

    public GPSScale getGPS();

    public TCGScale getTCG();

    public TDBScale getTDB();

    public TCBScale getTCB();

    public GMSTScale getGMST(IERSConventions var1, boolean var2);

    public IRNSSScale getIRNSS();

    public BDTScale getBDT();

    public AbsoluteDate getJulianEpoch();

    public AbsoluteDate getModifiedJulianEpoch();

    public AbsoluteDate getFiftiesEpoch();

    public AbsoluteDate getCcsdsEpoch();

    public AbsoluteDate getGalileoEpoch();

    public AbsoluteDate getGpsEpoch();

    public AbsoluteDate getQzssEpoch();

    public AbsoluteDate getIrnssEpoch();

    public AbsoluteDate getBeidouEpoch();

    public AbsoluteDate getGlonassEpoch();

    public AbsoluteDate getJ2000Epoch();

    public AbsoluteDate getJavaEpoch();

    public AbsoluteDate getPastInfinity();

    public AbsoluteDate getFutureInfinity();

    public AbsoluteDate createJulianEpoch(double var1);

    public AbsoluteDate createBesselianEpoch(double var1);

    public static TimeScales of(Collection<? extends OffsetModel> utcMinusTai, BiFunction<? super IERSConventions, ? super TimeScales, ? extends Collection<? extends EOPEntry>> eopSupplier) {
        return new PreloadedTimeScales(utcMinusTai, eopSupplier);
    }
}

