/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockModel;
import org.orekit.time.ClockOffset;
import org.orekit.time.ClockOffsetHermiteInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldClockOffset;
import org.orekit.time.FieldClockOffsetHermiteInterpolator;
import org.orekit.utils.ImmutableTimeStampedCache;

public class SampledClockModel
implements ClockModel {
    private final ImmutableTimeStampedCache<ClockOffset> sample;

    public SampledClockModel(List<ClockOffset> sample, int nbInterpolationPoints) {
        this.sample = new ImmutableTimeStampedCache<ClockOffset>(nbInterpolationPoints, sample);
    }

    public ImmutableTimeStampedCache<ClockOffset> getCache() {
        return this.sample;
    }

    @Override
    public AbsoluteDate getValidityStart() {
        return this.sample.getEarliest().getDate();
    }

    @Override
    public AbsoluteDate getValidityEnd() {
        return this.sample.getLatest().getDate();
    }

    @Override
    public ClockOffset getOffset(AbsoluteDate date) {
        return (ClockOffset)new ClockOffsetHermiteInterpolator(this.sample.getMaxNeighborsSize()).interpolate(date, this.sample.getNeighbors(date));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldClockOffset<T> getOffset(FieldAbsoluteDate<T> date) {
        Field field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        Stream<FieldClockOffset> fieldSample = this.sample.getNeighbors(date.toAbsoluteDate()).map(c -> {
            CalculusFieldElement accelerationF;
            CalculusFieldElement rateF;
            FieldAbsoluteDate dateF = new FieldAbsoluteDate(field, c.getDate());
            CalculusFieldElement offsetF = (CalculusFieldElement)zero.newInstance(c.getOffset());
            if (Double.isNaN(c.getRate())) {
                rateF = null;
                accelerationF = null;
            } else {
                rateF = (CalculusFieldElement)zero.newInstance(c.getRate());
                accelerationF = Double.isNaN(c.getAcceleration()) ? null : (CalculusFieldElement)zero.newInstance(c.getAcceleration());
            }
            return new FieldClockOffset<Object>(dateF, offsetF, rateF, accelerationF);
        });
        FieldClockOffsetHermiteInterpolator<FieldClockOffset> interpolator = new FieldClockOffsetHermiteInterpolator<FieldClockOffset>(this.sample.getMaxNeighborsSize());
        return interpolator.interpolate(date, fieldSample);
    }
}

