/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistory;
import org.orekit.time.AbstractTimeScales;
import org.orekit.time.BDTScale;
import org.orekit.time.GLONASSScale;
import org.orekit.time.GPSScale;
import org.orekit.time.GalileoScale;
import org.orekit.time.IRNSSScale;
import org.orekit.time.OffsetModel;
import org.orekit.time.QZSSScale;
import org.orekit.time.TAIScale;
import org.orekit.time.TCBScale;
import org.orekit.time.TCGScale;
import org.orekit.time.TDBScale;
import org.orekit.time.TTScale;
import org.orekit.time.TimeScales;
import org.orekit.time.UTCScale;
import org.orekit.utils.IERSConventions;

class PreloadedTimeScales
extends AbstractTimeScales {
    private final TAIScale tai = new TAIScale();
    private final UTCScale utc;
    private final TTScale tt = new TTScale();
    private final GalileoScale gst;
    private final GLONASSScale glonass;
    private final QZSSScale qzss;
    private final GPSScale gps = new GPSScale();
    private final TCGScale tcg;
    private final TDBScale tdb;
    private final TCBScale tcb;
    private final IRNSSScale irnss;
    private final BDTScale bdt;
    private final BiFunction<? super IERSConventions, ? super TimeScales, ? extends Collection<? extends EOPEntry>> eopSupplier;
    private final ConcurrentMap<IERSConventions, Collection<? extends EOPEntry>> eopMap;

    PreloadedTimeScales(Collection<? extends OffsetModel> leapSeconds, BiFunction<? super IERSConventions, ? super TimeScales, ? extends Collection<? extends EOPEntry>> eopSupplier) {
        this.qzss = new QZSSScale();
        this.gst = new GalileoScale();
        this.irnss = new IRNSSScale();
        this.bdt = new BDTScale();
        this.tcg = new TCGScale(this.tt, this.tai);
        this.utc = new UTCScale(this.tai, leapSeconds);
        this.glonass = new GLONASSScale(this.utc);
        this.tdb = new TDBScale(this.tt, this.getJ2000Epoch());
        this.tcb = new TCBScale(this.tdb, this.tai);
        int n = IERSConventions.values().length;
        this.eopMap = new ConcurrentHashMap<IERSConventions, Collection<? extends EOPEntry>>(n);
        this.eopSupplier = eopSupplier;
    }

    @Override
    public TAIScale getTAI() {
        return this.tai;
    }

    @Override
    public UTCScale getUTC() {
        return this.utc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EOPHistory getEopHistory(IERSConventions conventions, boolean simpleEOP) {
        Collection data;
        PreloadedTimeScales preloadedTimeScales = this;
        synchronized (preloadedTimeScales) {
            data = this.eopMap.computeIfAbsent(conventions, c -> this.eopSupplier.apply((IERSConventions)((Object)c), this));
        }
        return new EOPHistory(conventions, 3, (Collection<? extends EOPEntry>)data, simpleEOP, (TimeScales)this);
    }

    @Override
    public TTScale getTT() {
        return this.tt;
    }

    @Override
    public GalileoScale getGST() {
        return this.gst;
    }

    @Override
    public GLONASSScale getGLONASS() {
        return this.glonass;
    }

    @Override
    public QZSSScale getQZSS() {
        return this.qzss;
    }

    @Override
    public GPSScale getGPS() {
        return this.gps;
    }

    @Override
    public TCGScale getTCG() {
        return this.tcg;
    }

    @Override
    public TDBScale getTDB() {
        return this.tdb;
    }

    @Override
    public TCBScale getTCB() {
        return this.tcb;
    }

    @Override
    public IRNSSScale getIRNSS() {
        return this.irnss;
    }

    @Override
    public BDTScale getBDT() {
        return this.bdt;
    }
}

