/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.LazyLoadedEop;
import org.orekit.time.AGILeapSecondFilesLoader;
import org.orekit.time.AbstractTimeScales;
import org.orekit.time.BDTScale;
import org.orekit.time.GLONASSScale;
import org.orekit.time.GMSTScale;
import org.orekit.time.GPSScale;
import org.orekit.time.GalileoScale;
import org.orekit.time.IRNSSScale;
import org.orekit.time.QZSSScale;
import org.orekit.time.TAIScale;
import org.orekit.time.TAIUTCDatFilesLoader;
import org.orekit.time.TCBScale;
import org.orekit.time.TCGScale;
import org.orekit.time.TDBScale;
import org.orekit.time.TTScale;
import org.orekit.time.UT1Scale;
import org.orekit.time.UTCScale;
import org.orekit.time.UTCTAIHistoryFilesLoader;
import org.orekit.time.UTCTAIOffsetsLoader;
import org.orekit.utils.IERSConventions;

public class LazyLoadedTimeScales
extends AbstractTimeScales {
    private final LazyLoadedEop lazyLoadedEop;
    private final List<UTCTAIOffsetsLoader> loaders = new ArrayList<UTCTAIOffsetsLoader>();
    private AtomicReference<UTCScale> utc = new AtomicReference();
    private AtomicReference<TAIScale> tai = new AtomicReference();
    private AtomicReference<TTScale> tt = new AtomicReference();
    private AtomicReference<GalileoScale> gst = new AtomicReference();
    private AtomicReference<GLONASSScale> glonass = new AtomicReference();
    private AtomicReference<QZSSScale> qzss = new AtomicReference();
    private AtomicReference<GPSScale> gps = new AtomicReference();
    private AtomicReference<TCGScale> tcg = new AtomicReference();
    private AtomicReference<TDBScale> tdb = new AtomicReference();
    private AtomicReference<TCBScale> tcb = new AtomicReference();
    private AtomicReference<IRNSSScale> irnss = new AtomicReference();
    private AtomicReference<BDTScale> bds = new AtomicReference();

    public LazyLoadedTimeScales(LazyLoadedEop lazyLoadedEop) {
        this.lazyLoadedEop = lazyLoadedEop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUTCTAIOffsetsLoader(UTCTAIOffsetsLoader loader) {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            this.loaders.add(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultUTCTAIOffsetsLoaders() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            DataProvidersManager dataProvidersManager = this.lazyLoadedEop.getDataProvidersManager();
            this.addUTCTAIOffsetsLoader(new TAIUTCDatFilesLoader("^tai-utc\\.dat$", dataProvidersManager));
            this.addUTCTAIOffsetsLoader(new UTCTAIHistoryFilesLoader(dataProvidersManager));
            this.addUTCTAIOffsetsLoader(new AGILeapSecondFilesLoader("^LeapSecond\\.dat$", dataProvidersManager));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUTCTAIOffsetsLoaders() {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            this.loaders.clear();
        }
    }

    @Override
    public TAIScale getTAI() {
        TAIScale refTai = this.tai.get();
        if (refTai == null) {
            this.tai.compareAndSet(null, new TAIScale());
            refTai = this.tai.get();
        }
        return refTai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UTCScale getUTC() {
        UTCScale refUtc = this.utc.get();
        if (refUtc == null) {
            LazyLoadedTimeScales lazyLoadedTimeScales = this;
            synchronized (lazyLoadedTimeScales) {
                if (this.utc.get() == null) {
                    UTCTAIOffsetsLoader loader;
                    List<Object> entries = Collections.emptyList();
                    if (this.loaders.isEmpty()) {
                        this.addDefaultUTCTAIOffsetsLoaders();
                    }
                    Iterator<UTCTAIOffsetsLoader> iterator = this.loaders.iterator();
                    while (iterator.hasNext() && (entries = (loader = iterator.next()).loadOffsets()).isEmpty()) {
                    }
                    if (entries.isEmpty()) {
                        throw new OrekitException((Localizable)OrekitMessages.NO_IERS_UTC_TAI_HISTORY_DATA_LOADED, new Object[0]);
                    }
                    this.utc.compareAndSet(null, new UTCScale(this.getTAI(), entries));
                }
                refUtc = this.utc.get();
            }
        }
        return refUtc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UT1Scale getUT1(IERSConventions conventions, boolean simpleEOP) {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            return super.getUT1(conventions, simpleEOP);
        }
    }

    @Override
    protected EOPHistory getEopHistory(IERSConventions conventions, boolean simpleEOP) {
        return this.lazyLoadedEop.getEOPHistory(conventions, simpleEOP, this);
    }

    @Override
    public UT1Scale getUT1(EOPHistory history) {
        return super.getUT1(history);
    }

    @Override
    public TTScale getTT() {
        TTScale refTt = this.tt.get();
        if (refTt == null) {
            this.tt.compareAndSet(null, new TTScale());
            refTt = this.tt.get();
        }
        return refTt;
    }

    @Override
    public GalileoScale getGST() {
        GalileoScale refGst = this.gst.get();
        if (refGst == null) {
            this.gst.compareAndSet(null, new GalileoScale());
            refGst = this.gst.get();
        }
        return refGst;
    }

    @Override
    public GLONASSScale getGLONASS() {
        GLONASSScale refGlonass = this.glonass.get();
        if (refGlonass == null) {
            this.glonass.compareAndSet(null, new GLONASSScale(this.getUTC()));
            refGlonass = this.glonass.get();
        }
        return refGlonass;
    }

    @Override
    public QZSSScale getQZSS() {
        QZSSScale refQzss = this.qzss.get();
        if (refQzss == null) {
            this.qzss.compareAndSet(null, new QZSSScale());
            refQzss = this.qzss.get();
        }
        return refQzss;
    }

    @Override
    public GPSScale getGPS() {
        GPSScale refGps = this.gps.get();
        if (refGps == null) {
            this.gps.compareAndSet(null, new GPSScale());
            refGps = this.gps.get();
        }
        return refGps;
    }

    @Override
    public TCGScale getTCG() {
        TCGScale refTcg = this.tcg.get();
        if (refTcg == null) {
            this.tcg.compareAndSet(null, new TCGScale(this.getTT(), this.getTAI()));
            refTcg = this.tcg.get();
        }
        return refTcg;
    }

    @Override
    public TDBScale getTDB() {
        TDBScale refTdb = this.tdb.get();
        if (refTdb == null) {
            this.tdb.compareAndSet(null, new TDBScale(this.getTT(), this.getJ2000Epoch()));
            refTdb = this.tdb.get();
        }
        return refTdb;
    }

    @Override
    public TCBScale getTCB() {
        TCBScale refTcb = this.tcb.get();
        if (refTcb == null) {
            this.tcb.compareAndSet(null, new TCBScale(this.getTDB(), this.getTAI()));
            refTcb = this.tcb.get();
        }
        return refTcb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GMSTScale getGMST(IERSConventions conventions, boolean simpleEOP) {
        LazyLoadedTimeScales lazyLoadedTimeScales = this;
        synchronized (lazyLoadedTimeScales) {
            return super.getGMST(conventions, simpleEOP);
        }
    }

    @Override
    public IRNSSScale getIRNSS() {
        IRNSSScale refIrnss = this.irnss.get();
        if (refIrnss == null) {
            this.irnss.compareAndSet(null, new IRNSSScale());
            refIrnss = this.irnss.get();
        }
        return refIrnss;
    }

    @Override
    public BDTScale getBDT() {
        BDTScale refBds = this.bds.get();
        if (refBds == null) {
            this.bds.compareAndSet(null, new BDTScale());
            refBds = this.bds.get();
        }
        return refBds;
    }
}

