/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPEntry;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeStamped;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;

public class GNSSDate
implements Serializable,
TimeStamped {
    private static final long serialVersionUID = 20221228L;
    private static final int WEEK_D = 7;
    private static final double WEEK_S = 604800.0;
    private static AtomicReference<DateComponents> rolloverReference = new AtomicReference<Object>(null);
    private final int weekNumber;
    private final double secondsInWeek;
    private final SatelliteSystem system;
    private final transient AbsoluteDate date;

    @DefaultDataContext
    public GNSSDate(int weekNumber, double secondsInWeek, SatelliteSystem system) {
        this(weekNumber, secondsInWeek, system, DataContext.getDefault().getTimeScales());
    }

    public GNSSDate(int weekNumber, double secondsInWeek, SatelliteSystem system, TimeScales timeScales) {
        int day = (int)FastMath.floor((double)(secondsInWeek / 86400.0));
        double secondsInDay = secondsInWeek - (double)day * 86400.0;
        int w = weekNumber;
        DateComponents dc = new DateComponents(this.getWeekReferenceDateComponents(system), weekNumber * 7 + day);
        int cycleW = GNSSDateType.getRollOverWeek(system);
        if (weekNumber < cycleW) {
            DateComponents reference = rolloverReference.get();
            if (reference == null) {
                UT1Scale ut1 = timeScales.getUT1(IERSConventions.IERS_2010, true);
                List<EOPEntry> eop = ut1.getEOPHistory().getEntries();
                int lastMJD = eop.get(eop.size() - 1).getMjd();
                reference = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, lastMJD);
                rolloverReference.compareAndSet(null, reference);
            }
            int cycleD = 7 * cycleW;
            while (dc.getJ2000Day() < reference.getJ2000Day() - cycleD / 2) {
                dc = new DateComponents(dc, cycleD);
                w += cycleW;
            }
        }
        this.weekNumber = w;
        this.secondsInWeek = secondsInWeek;
        this.system = system;
        this.date = new AbsoluteDate(dc, new TimeComponents(secondsInDay), this.getTimeScale(system, timeScales));
    }

    public GNSSDate(int weekNumber, double secondsInWeek, SatelliteSystem system, DateComponents reference, TimeScales timeScales) {
        int day = (int)FastMath.floor((double)(secondsInWeek / 86400.0));
        double secondsInDay = secondsInWeek - (double)day * 86400.0;
        int w = weekNumber;
        DateComponents dc = new DateComponents(this.getWeekReferenceDateComponents(system), weekNumber * 7 + day);
        int cycleW = GNSSDateType.getRollOverWeek(system);
        if (weekNumber < cycleW) {
            int cycleD = 7 * cycleW;
            while (dc.getJ2000Day() < reference.getJ2000Day() - cycleD / 2) {
                dc = new DateComponents(dc, cycleD);
                w += cycleW;
            }
        }
        this.weekNumber = w;
        this.secondsInWeek = secondsInWeek;
        this.system = system;
        this.date = new AbsoluteDate(dc, new TimeComponents(secondsInDay), this.getTimeScale(system, timeScales));
    }

    @DefaultDataContext
    public GNSSDate(AbsoluteDate date, SatelliteSystem system) {
        this(date, system, DataContext.getDefault().getTimeScales());
    }

    public GNSSDate(AbsoluteDate date, SatelliteSystem system, TimeScales timeScales) {
        this.system = system;
        AbsoluteDate epoch = this.getWeekReferenceAbsoluteDate(system, timeScales);
        this.weekNumber = (int)FastMath.floor((double)(date.durationFrom(epoch) / 604800.0));
        AbsoluteDate weekStart = new AbsoluteDate(epoch, 604800.0 * (double)this.weekNumber);
        this.secondsInWeek = date.durationFrom(weekStart);
        this.date = date;
    }

    public static void setRolloverReference(DateComponents reference) {
        rolloverReference.set(reference);
    }

    public static DateComponents getRolloverReference() {
        return rolloverReference.get();
    }

    public int getWeekNumber() {
        return this.weekNumber;
    }

    public double getMilliInWeek() {
        return this.getSecondsInWeek() * 1000.0;
    }

    public double getSecondsInWeek() {
        return this.secondsInWeek;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    private TimeScale getTimeScale(SatelliteSystem satellite, TimeScales timeScales) {
        switch (satellite) {
            case GPS: {
                return timeScales.getGPS();
            }
            case GALILEO: {
                return timeScales.getGST();
            }
            case QZSS: {
                return timeScales.getQZSS();
            }
            case BEIDOU: {
                return timeScales.getBDT();
            }
            case IRNSS: {
                return timeScales.getIRNSS();
            }
            case SBAS: {
                return timeScales.getGPS();
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_SYSTEM, new Object[]{satellite});
    }

    private AbsoluteDate getWeekReferenceAbsoluteDate(SatelliteSystem satellite, TimeScales timeScales) {
        switch (satellite) {
            case GPS: {
                return timeScales.getGpsEpoch();
            }
            case GALILEO: {
                return timeScales.getGalileoEpoch();
            }
            case QZSS: {
                return timeScales.getQzssEpoch();
            }
            case BEIDOU: {
                return timeScales.getBeidouEpoch();
            }
            case IRNSS: {
                return timeScales.getIrnssEpoch();
            }
            case SBAS: {
                return timeScales.getGpsEpoch();
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_SYSTEM, new Object[]{satellite});
    }

    private DateComponents getWeekReferenceDateComponents(SatelliteSystem satellite) {
        switch (satellite) {
            case GPS: {
                return DateComponents.GPS_EPOCH;
            }
            case GALILEO: {
                return DateComponents.GALILEO_EPOCH;
            }
            case QZSS: {
                return DateComponents.QZSS_EPOCH;
            }
            case BEIDOU: {
                return DateComponents.BEIDOU_EPOCH;
            }
            case IRNSS: {
                return DateComponents.IRNSS_EPOCH;
            }
            case SBAS: {
                return DateComponents.GPS_EPOCH;
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_SYSTEM, new Object[]{satellite});
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.weekNumber, this.secondsInWeek, this.system);
    }

    private static enum GNSSDateType {
        GPS(SatelliteSystem.GPS, 1024),
        GALILEO(SatelliteSystem.GALILEO, 4096),
        QZSS(SatelliteSystem.QZSS, 1024),
        BEIDOU(SatelliteSystem.BEIDOU, 8192),
        IRNSS(SatelliteSystem.IRNSS, 1024),
        SBAS(SatelliteSystem.SBAS, 1024);

        private static final Map<SatelliteSystem, Integer> CYCLE_MAP;
        private final int numberOfWeek;
        private final SatelliteSystem satelliteSystem;

        private GNSSDateType(SatelliteSystem system, int rollover) {
            this.satelliteSystem = system;
            this.numberOfWeek = rollover;
        }

        private int getRollOverCycle() {
            return this.numberOfWeek;
        }

        private SatelliteSystem getSatelliteSystem() {
            return this.satelliteSystem;
        }

        private static int getRollOverWeek(SatelliteSystem satellite) {
            return CYCLE_MAP.get((Object)satellite);
        }

        static {
            CYCLE_MAP = new HashMap<SatelliteSystem, Integer>();
            for (GNSSDateType type : GNSSDateType.values()) {
                int val = type.getRollOverCycle();
                SatelliteSystem satellite = type.getSatelliteSystem();
                CYCLE_MAP.put(satellite, val);
            }
        }
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20221228L;
        private final int weekNumber;
        private final double secondsInWeek;
        private final SatelliteSystem system;

        DataTransferObject(int weekNumber, double secondsInWeek, SatelliteSystem system) {
            this.weekNumber = weekNumber;
            this.secondsInWeek = secondsInWeek;
            this.system = system;
        }

        private Object readResolve() {
            return new GNSSDate(this.weekNumber, this.secondsInWeek, this.system);
        }
    }
}

