/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.TimeStampedPair;

public class FieldTimeStampedPair<F extends FieldTimeStamped<KK>, S extends FieldTimeStamped<KK>, KK extends CalculusFieldElement<KK>>
implements FieldTimeStamped<KK> {
    public static final double DEFAULT_DATE_EQUALITY_THRESHOLD = 1.0E-9;
    private final F first;
    private final S second;

    public FieldTimeStampedPair(F first, S second) {
        this(first, second, 1.0E-9);
    }

    public FieldTimeStampedPair(F first, S second, double dateEqualityThreshold) {
        TimeStampedPair.checkDatesConsistency(first.getDate().toAbsoluteDate(), second.getDate().toAbsoluteDate(), dateEqualityThreshold);
        this.first = first;
        this.second = second;
    }

    @Override
    public FieldAbsoluteDate<KK> getDate() {
        return this.first.getDate();
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }
}

