/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;

public interface FieldTimeInterpolator<T extends FieldTimeStamped<KK>, KK extends CalculusFieldElement<KK>> {
    default public T interpolate(AbsoluteDate interpolationDate, Stream<T> sample) {
        return this.interpolate(interpolationDate, (Collection)sample.collect(Collectors.toList()));
    }

    default public T interpolate(AbsoluteDate interpolationDate, Collection<T> sample) {
        Optional<T> optionalElement = sample.stream().findAny();
        if (optionalElement.isPresent()) {
            FieldTimeStamped element = (FieldTimeStamped)optionalElement.get();
            return this.interpolate(new FieldAbsoluteDate(element.getDate().getField(), interpolationDate), sample);
        }
        throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA, 0);
    }

    public T interpolate(FieldAbsoluteDate<KK> var1, Stream<T> var2);

    public T interpolate(FieldAbsoluteDate<KK> var1, Collection<T> var2);

    public List<FieldTimeInterpolator<? extends FieldTimeStamped<KK>, KK>> getSubInterpolators();

    public int getNbInterpolationPoints();

    public double getExtrapolationThreshold();
}

