/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.util.MathArrays;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldClockOffset;

public class FieldClockOffsetHermiteInterpolator<T extends CalculusFieldElement<T>>
extends AbstractFieldTimeInterpolator<FieldClockOffset<T>, T> {
    public FieldClockOffsetHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, 0.001);
    }

    public FieldClockOffsetHermiteInterpolator(int interpolationPoints, double extrapolationThreshold) {
        super(interpolationPoints, extrapolationThreshold);
    }

    @Override
    protected FieldClockOffset<T> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List neighborList = interpolationData.getNeighborList();
        for (FieldClockOffset value : neighborList) {
            Object deltaT = value.getDate().durationFrom(interpolationDate);
            CalculusFieldElement[] offset = (CalculusFieldElement[])MathArrays.buildArray(interpolationDate.getField(), (int)1);
            offset[0] = value.getOffset();
            if (value.getRate() == null || value.getRate().isNaN()) {
                interpolator.addSamplePoint(deltaT, (FieldElement[][])new CalculusFieldElement[][]{offset});
                continue;
            }
            CalculusFieldElement[] rate = (CalculusFieldElement[])MathArrays.buildArray(interpolationDate.getField(), (int)1);
            rate[0] = value.getRate();
            if (value.getAcceleration() == null || value.getAcceleration().isNaN()) {
                interpolator.addSamplePoint(deltaT, (FieldElement[][])new CalculusFieldElement[][]{offset, rate});
                continue;
            }
            CalculusFieldElement[] acceleration = (CalculusFieldElement[])MathArrays.buildArray(interpolationDate.getField(), (int)1);
            acceleration[0] = value.getAcceleration();
            interpolator.addSamplePoint(deltaT, (FieldElement[][])new CalculusFieldElement[][]{offset, rate, acceleration});
        }
        CalculusFieldElement[][] y = (CalculusFieldElement[][])interpolator.derivatives((FieldElement)((CalculusFieldElement)interpolationDate.getField().getZero()), 2);
        return new FieldClockOffset<CalculusFieldElement>(interpolationDate, y[0][0], y[1][0], y[2][0]);
    }
}

