/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2Field;
import org.hipparchus.complex.Complex;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.CcsdsSegmentedTimeCode;
import org.orekit.time.CcsdsUnsegmentedTimeCode;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.Month;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UTCScale;

public class FieldAbsoluteDate<T extends CalculusFieldElement<T>>
implements FieldTimeStamped<T>,
FieldTimeShiftable<FieldAbsoluteDate<T>, T>,
Comparable<FieldAbsoluteDate<T>> {
    private final long epoch;
    private final T offset;
    private final Field<T> field;

    public FieldAbsoluteDate(Field<T> field, AbsoluteDate date) {
        this.field = field;
        this.epoch = date.getEpoch();
        this.offset = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(date.getOffset());
    }

    @DefaultDataContext
    public FieldAbsoluteDate(Field<T> field) {
        FieldAbsoluteDate<T> j2000 = FieldAbsoluteDate.getJ2000Epoch(field);
        this.field = j2000.field;
        this.epoch = j2000.epoch;
        this.offset = j2000.offset;
    }

    public FieldAbsoluteDate(FieldAbsoluteDate<T> since, T elapsedDuration) {
        this.field = since.field;
        MathUtils.FieldSumAndResidual sumAndResidual = MathUtils.twoSum(since.offset, elapsedDuration);
        if (Double.isInfinite(((CalculusFieldElement)sumAndResidual.getSum()).getReal())) {
            this.offset = (CalculusFieldElement)sumAndResidual.getSum();
            this.epoch = ((CalculusFieldElement)sumAndResidual.getSum()).getReal() < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            long dl = (long)FastMath.floor((double)((CalculusFieldElement)sumAndResidual.getSum()).getReal());
            CalculusFieldElement regularOffset = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sumAndResidual.getSum()).subtract((double)dl)).add((FieldElement)((CalculusFieldElement)sumAndResidual.getResidual()));
            if (regularOffset.getReal() >= 0.0) {
                this.offset = regularOffset;
                this.epoch = since.epoch + dl;
            } else {
                this.offset = (CalculusFieldElement)regularOffset.add(1.0);
                this.epoch = since.epoch + dl - 1L;
            }
        }
    }

    public FieldAbsoluteDate(Field<T> field, String location, TimeScale timeScale) {
        this(field, DateTimeComponents.parseDateTime(location), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, DateTimeComponents location, TimeScale timeScale) {
        this(field, location.getDate(), location.getTime(), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, DateComponents date, TimeComponents time, TimeScale timeScale) {
        double seconds = time.getSecond();
        double tsOffset = timeScale.offsetToTAI(date, time);
        MathUtils.SumAndResidual sumAndResidual = MathUtils.twoSum((double)seconds, (double)tsOffset);
        long dl = (long)FastMath.floor((double)sumAndResidual.getSum());
        CalculusFieldElement regularOffset = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(sumAndResidual.getSum() - (double)dl + sumAndResidual.getResidual());
        if (regularOffset.getReal() >= 0.0) {
            this.offset = regularOffset;
            this.epoch = 60L * (((long)date.getJ2000Day() * 24L + (long)time.getHour()) * 60L + (long)time.getMinute() - (long)time.getMinutesFromUTC() - 720L) + dl;
        } else {
            this.offset = (CalculusFieldElement)regularOffset.add(1.0);
            this.epoch = 60L * (((long)date.getJ2000Day() * 24L + (long)time.getHour()) * 60L + (long)time.getMinute() - (long)time.getMinutesFromUTC() - 720L) + dl - 1L;
        }
        this.field = field;
    }

    public FieldAbsoluteDate(Field<T> field, int year, int month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, int year, Month month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, DateComponents date, TimeScale timeScale) throws IllegalArgumentException {
        this(field, date, TimeComponents.H00, timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, int year, int month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, int year, Month month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(field, new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, Date location, TimeScale timeScale) {
        this(field, new DateComponents(DateComponents.JAVA_EPOCH, (int)(location.getTime() / 86400000L)), new TimeComponents(0.001 * (double)(location.getTime() % 86400000L)), timeScale);
    }

    public FieldAbsoluteDate(Field<T> field, Instant instant, TimeScale timeScale) {
        this(field, new DateComponents(DateComponents.JAVA_EPOCH, (int)(instant.getEpochSecond() / 86400L)), FieldAbsoluteDate.instantToTimeComponents(instant), timeScale);
    }

    @DefaultDataContext
    public FieldAbsoluteDate(Field<T> field, Instant instant) {
        this(field, instant, TimeScalesFactory.getUTC());
    }

    public FieldAbsoluteDate(Field<T> field, Instant instant, UTCScale utcScale) {
        this(field, new DateComponents(DateComponents.JAVA_EPOCH, (int)(instant.getEpochSecond() / 86400L)), FieldAbsoluteDate.instantToTimeComponents(instant), utcScale);
    }

    public FieldAbsoluteDate(FieldAbsoluteDate<T> since, double elapsedDuration) {
        this(since.epoch, elapsedDuration, since.offset);
    }

    public FieldAbsoluteDate(FieldAbsoluteDate<T> since, long elapsedDuration, TimeUnit timeUnit) {
        this(since.epoch, elapsedDuration, timeUnit, since.offset);
    }

    public FieldAbsoluteDate(AbsoluteDate since, T elapsedDuration) {
        this(since.getEpoch(), since.getOffset(), elapsedDuration);
    }

    public FieldAbsoluteDate(AbsoluteDate since, long elapsedDuration, TimeUnit timeUnit, Field<T> field) {
        this.field = field;
        long elapsedDurationNanoseconds = TimeUnit.NANOSECONDS.convert(elapsedDuration, timeUnit);
        long deltaEpoch = elapsedDurationNanoseconds / TimeUnit.SECONDS.toNanos(1L);
        double deltaOffset = (double)(elapsedDurationNanoseconds - deltaEpoch * TimeUnit.SECONDS.toNanos(1L)) / (double)TimeUnit.SECONDS.toNanos(1L);
        CalculusFieldElement newOffset = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(since.getOffset())).add(deltaOffset);
        if (newOffset.getReal() >= 1.0) {
            this.epoch = since.getEpoch() + deltaEpoch + 1L;
            this.offset = (CalculusFieldElement)newOffset.subtract(1.0);
        } else if (newOffset.getReal() < 0.0) {
            this.epoch = since.getEpoch() + deltaEpoch - 1L;
            this.offset = (CalculusFieldElement)newOffset.add(1.0);
        } else {
            this.epoch = since.getEpoch() + deltaEpoch;
            this.offset = newOffset;
        }
    }

    public FieldAbsoluteDate(FieldAbsoluteDate<T> reference, double apparentOffset, TimeScale timeScale) {
        this(reference.field, new DateTimeComponents(reference.getComponents(timeScale), apparentOffset), timeScale);
    }

    private FieldAbsoluteDate(long epoch, double tA, T tB) {
        this.field = tB.getField();
        MathUtils.FieldSumAndResidual sumAndResidual = MathUtils.twoSum((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).add(tA)), tB);
        if (Double.isInfinite(((CalculusFieldElement)sumAndResidual.getSum()).getReal())) {
            this.offset = (CalculusFieldElement)sumAndResidual.getSum();
            this.epoch = ((CalculusFieldElement)sumAndResidual.getSum()).getReal() < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            long dl = (long)FastMath.floor((double)((CalculusFieldElement)sumAndResidual.getSum()).getReal());
            CalculusFieldElement regularOffset = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sumAndResidual.getSum()).subtract((double)dl)).add((FieldElement)((CalculusFieldElement)sumAndResidual.getResidual()));
            if (regularOffset.getReal() >= 0.0) {
                this.offset = regularOffset;
                this.epoch = epoch + dl;
            } else {
                this.offset = (CalculusFieldElement)regularOffset.add(1.0);
                this.epoch = epoch + dl - 1L;
            }
        }
    }

    private FieldAbsoluteDate(long epoch, long tA, TimeUnit tATimeUnit, T tB) {
        this.field = tB.getField();
        long elapsedDurationNanoseconds = TimeUnit.NANOSECONDS.convert(tA, tATimeUnit);
        long deltaEpoch = elapsedDurationNanoseconds / TimeUnit.SECONDS.toNanos(1L);
        double deltaOffset = (double)(elapsedDurationNanoseconds - deltaEpoch * TimeUnit.SECONDS.toNanos(1L)) / (double)TimeUnit.SECONDS.toNanos(1L);
        CalculusFieldElement newOffset = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).add(tB)).add(deltaOffset);
        if (newOffset.getReal() >= 1.0) {
            this.epoch = epoch + deltaEpoch + 1L;
            this.offset = (CalculusFieldElement)newOffset.subtract(1.0);
        } else if (newOffset.getReal() < 0.0) {
            this.epoch = epoch + deltaEpoch - 1L;
            this.offset = (CalculusFieldElement)newOffset.add(1.0);
        } else {
            this.epoch = epoch + deltaEpoch;
            this.offset = newOffset;
        }
    }

    public FieldAbsoluteDate<FieldUnivariateDerivative2<T>> toFUD2Field() {
        FieldUnivariateDerivative2Field fud2Field = FieldUnivariateDerivative2Field.getUnivariateDerivative2Field(this.field);
        AbsoluteDate date = this.toAbsoluteDate();
        T fieldShift = this.durationFrom(date);
        FieldUnivariateDerivative2 fud2Shift = new FieldUnivariateDerivative2(fieldShift, (CalculusFieldElement)this.field.getOne(), (CalculusFieldElement)this.field.getZero());
        return new FieldAbsoluteDate<T>(fud2Field, date).shiftedBy((CalculusFieldElement)fud2Shift);
    }

    private static TimeComponents instantToTimeComponents(Instant instant) {
        int secInDay = (int)(instant.getEpochSecond() % 86400L);
        return new TimeComponents(secInDay, 1.0E-9 * (double)instant.getNano());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSUnsegmentedTimeCode(Field<T> field, byte preambleField1, byte preambleField2, byte[] timeField, FieldAbsoluteDate<T> agencyDefinedEpoch) {
        return FieldAbsoluteDate.parseCCSDSUnsegmentedTimeCode(field, preambleField1, preambleField2, timeField, agencyDefinedEpoch, new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getCcsdsEpoch()));
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSUnsegmentedTimeCode(Field<T> field, byte preambleField1, byte preambleField2, byte[] timeField, FieldAbsoluteDate<T> agencyDefinedEpoch, FieldAbsoluteDate<T> ccsdsEpoch) {
        CcsdsUnsegmentedTimeCode<FieldAbsoluteDate<T>> timeCode = new CcsdsUnsegmentedTimeCode<FieldAbsoluteDate<T>>(preambleField1, preambleField2, timeField, agencyDefinedEpoch, ccsdsEpoch);
        return new FieldAbsoluteDate<T>(timeCode.getEpoch(), timeCode.getSeconds()).shiftedBy(timeCode.getSubSecond());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSDaySegmentedTimeCode(Field<T> field, byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch) {
        return FieldAbsoluteDate.parseCCSDSDaySegmentedTimeCode(field, preambleField, timeField, agencyDefinedEpoch, DataContext.getDefault().getTimeScales().getUTC());
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> parseCCSDSDaySegmentedTimeCode(Field<T> field, byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch, TimeScale utc) {
        CcsdsSegmentedTimeCode timeCode = new CcsdsSegmentedTimeCode(preambleField, timeField, agencyDefinedEpoch);
        return new FieldAbsoluteDate<T>(field, timeCode.getDate(), timeCode.getTime(), utc).shiftedBy(timeCode.getSubSecond());
    }

    @DefaultDataContext
    public FieldAbsoluteDate<T> parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField) {
        return this.parseCCSDSCalendarSegmentedTimeCode(preambleField, timeField, DataContext.getDefault().getTimeScales().getUTC());
    }

    public FieldAbsoluteDate<T> parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField, TimeScale utc) {
        CcsdsSegmentedTimeCode timeCode = new CcsdsSegmentedTimeCode(preambleField, timeField);
        return new FieldAbsoluteDate<T>(this.field, timeCode.getDate(), timeCode.getTime(), utc).shiftedBy(timeCode.getSubSecond());
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createJDDate(int jd, T secondsSinceNoon, TimeScale timeScale) {
        return new FieldAbsoluteDate<T>(secondsSinceNoon.getField(), new DateComponents(DateComponents.JULIAN_EPOCH, jd), TimeComponents.H12, timeScale).shiftedBy(secondsSinceNoon);
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createJDDate(int jd, T secondsSinceNoon, TimeScale timeScale, TimeScale pivotTimeScale) {
        FieldAbsoluteDate<T> dateInPivotTimeScale = FieldAbsoluteDate.createJDDate(jd, secondsSinceNoon, pivotTimeScale);
        CalculusFieldElement offsetFromTAI = (CalculusFieldElement)timeScale.offsetFromTAI(dateInPivotTimeScale).subtract(pivotTimeScale.offsetFromTAI(dateInPivotTimeScale));
        return dateInPivotTimeScale.shiftedBy((CalculusFieldElement)offsetFromTAI.multiply(-1.0));
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createMJDDate(int mjd, T secondsInDay, TimeScale timeScale) {
        return new FieldAbsoluteDate<T>(secondsInDay.getField(), new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), TimeComponents.H00, timeScale).shiftedBy(secondsInDay);
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createGPSDate(int weekNumber, T milliInWeek) {
        return FieldAbsoluteDate.createGPSDate(weekNumber, milliInWeek, DataContext.getDefault().getTimeScales().getGPS());
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createGPSDate(int weekNumber, T milliInWeek, TimeScale gps) {
        int day = (int)FastMath.floor((double)(milliInWeek.getReal() / 8.64E7));
        CalculusFieldElement secondsInDay = (CalculusFieldElement)((CalculusFieldElement)milliInWeek.divide(1000.0)).subtract((double)day * 86400.0);
        return new FieldAbsoluteDate<T>(milliInWeek.getField(), new DateComponents(DateComponents.GPS_EPOCH, weekNumber * 7 + day), TimeComponents.H00, gps).shiftedBy(secondsInDay);
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createJulianEpoch(T julianEpoch) {
        return FieldAbsoluteDate.createJulianEpoch(julianEpoch, DataContext.getDefault().getTimeScales());
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createJulianEpoch(T julianEpoch, TimeScales timeScales) {
        Field field = julianEpoch.getField();
        return new FieldAbsoluteDate<CalculusFieldElement>(new FieldAbsoluteDate<T>(field, timeScales.getJ2000Epoch()), (CalculusFieldElement)((CalculusFieldElement)julianEpoch.subtract(2000.0)).multiply(3.15576E7));
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createBesselianEpoch(T besselianEpoch) {
        return FieldAbsoluteDate.createBesselianEpoch(besselianEpoch, DataContext.getDefault().getTimeScales());
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> createBesselianEpoch(T besselianEpoch, TimeScales timeScales) {
        Field field = besselianEpoch.getField();
        return new FieldAbsoluteDate<CalculusFieldElement>(new FieldAbsoluteDate<T>(field, timeScales.getJ2000Epoch()), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)besselianEpoch.subtract(1900.0)).multiply(3.15569259746784E7)).add(-3.155732911872E9));
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getJulianEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getJulianEpoch());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getModifiedJulianEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getModifiedJulianEpoch());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getFiftiesEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getFiftiesEpoch());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getCCSDSEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getCcsdsEpoch());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getGalileoEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getGalileoEpoch());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getGPSEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getGpsEpoch());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getJ2000Epoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getJ2000Epoch());
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getJavaEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, DataContext.getDefault().getTimeScales().getJavaEpoch());
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getPastInfinity(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, AbsoluteDate.PAST_INFINITY);
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getFutureInfinity(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, AbsoluteDate.FUTURE_INFINITY);
    }

    public static <T extends CalculusFieldElement<T>> FieldAbsoluteDate<T> getArbitraryEpoch(Field<T> field) {
        return new FieldAbsoluteDate<T>(field, AbsoluteDate.ARBITRARY_EPOCH);
    }

    @Override
    public FieldAbsoluteDate<T> shiftedBy(T dt) {
        return new FieldAbsoluteDate<T>(this, dt);
    }

    @Override
    public T durationFrom(FieldAbsoluteDate<T> instant) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.offset.subtract(instant.offset)).add((double)(this.epoch - instant.epoch)));
    }

    public T durationFrom(FieldAbsoluteDate<T> instant, TimeUnit timeUnit) {
        long deltaEpoch = timeUnit.convert(this.epoch - instant.epoch, TimeUnit.SECONDS);
        long multiplier = timeUnit.convert(1L, TimeUnit.SECONDS);
        CalculusFieldElement deltaOffset = (CalculusFieldElement)((CalculusFieldElement)this.offset.getField().getZero()).add((double)((CalculusFieldElement)((CalculusFieldElement)this.offset.subtract(instant.offset)).multiply((double)multiplier)).round());
        return (T)((CalculusFieldElement)deltaOffset.add((double)deltaEpoch));
    }

    public T durationFrom(AbsoluteDate instant) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.offset.subtract(instant.getOffset())).add((double)(this.epoch - instant.getEpoch())));
    }

    public T durationFrom(AbsoluteDate instant, TimeUnit timeUnit) {
        long deltaEpoch = timeUnit.convert(this.epoch - instant.getEpoch(), TimeUnit.SECONDS);
        long multiplier = timeUnit.convert(1L, TimeUnit.SECONDS);
        CalculusFieldElement deltaOffset = (CalculusFieldElement)((CalculusFieldElement)this.offset.getField().getZero()).add((double)((CalculusFieldElement)((CalculusFieldElement)this.offset.subtract(instant.getOffset())).multiply((double)multiplier)).round());
        return (T)((CalculusFieldElement)deltaOffset.add((double)deltaEpoch));
    }

    public T offsetFrom(FieldAbsoluteDate<T> instant, TimeScale timeScale) {
        long elapsedDurationA = this.epoch - instant.epoch;
        CalculusFieldElement elapsedDurationB = (CalculusFieldElement)((CalculusFieldElement)this.offset.add(timeScale.offsetFromTAI(this))).subtract((FieldElement)((CalculusFieldElement)instant.offset.add(timeScale.offsetFromTAI(instant))));
        return (T)((CalculusFieldElement)elapsedDurationB.add((double)elapsedDurationA));
    }

    public T timeScalesOffset(TimeScale scale1, TimeScale scale2) {
        return (T)((CalculusFieldElement)scale1.offsetFromTAI(this).subtract(scale2.offsetFromTAI(this)));
    }

    public Date toDate(TimeScale timeScale) {
        double time = (double)this.epoch + (this.offset.getReal() + timeScale.offsetFromTAI(this).getReal());
        return new Date(FastMath.round((double)((time + 9.46728E8) * 1000.0)));
    }

    @DefaultDataContext
    public Instant toInstant() {
        return this.toInstant(TimeScalesFactory.getTimeScales());
    }

    public Instant toInstant(TimeScales timeScales) {
        UTCScale utc = timeScales.getUTC();
        String stringWithoutUtcOffset = this.toStringWithoutUtcOffset(utc, 9);
        LocalDateTime localDateTime = LocalDateTime.parse(stringWithoutUtcOffset, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        return localDateTime.toInstant(ZoneOffset.UTC);
    }

    public DateTimeComponents getComponents(TimeScale timeScale) {
        long time;
        if (Double.isInfinite(this.offset.getReal())) {
            if (this.offset.getReal() < 0.0) {
                return new DateTimeComponents(DateComponents.MIN_EPOCH, TimeComponents.H00);
            }
            return new DateTimeComponents(DateComponents.MAX_EPOCH, new TimeComponents(23, 59, 59.999));
        }
        double taiOffset = timeScale.offsetFromTAI(this).getReal();
        MathUtils.SumAndResidual sumAndResidual = MathUtils.twoSum((double)this.offset.getReal(), (double)taiOffset);
        long carry = (long)FastMath.floor((double)sumAndResidual.getSum());
        double offset2000B = sumAndResidual.getSum() - (double)carry + sumAndResidual.getResidual();
        long offset2000A = this.epoch + carry + 43200L;
        if (offset2000B < 0.0) {
            --offset2000A;
            offset2000B += 1.0;
        }
        if ((time = offset2000A % 86400L) < 0L) {
            time += 86400L;
        }
        int date = (int)((offset2000A - time) / 86400L);
        DateComponents dateComponents = new DateComponents(DateComponents.J2000_EPOCH, date);
        double leap = timeScale.insideLeap(this) ? timeScale.getLeap(this.toAbsoluteDate()) : 0.0;
        int minuteDuration = timeScale.minuteDuration(this);
        TimeComponents timeComponents = TimeComponents.fromSeconds((int)time, offset2000B, leap, minuteDuration);
        return new DateTimeComponents(dateComponents, timeComponents);
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(int minutesFromUTC) {
        return this.getComponents(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(int minutesFromUTC, TimeScale utc) {
        DateTimeComponents utcComponents = this.getComponents(utc);
        double seconds = utcComponents.getTime().getSecond();
        int minute = utcComponents.getTime().getMinute() + minutesFromUTC;
        int hourShift = minute < 0 ? (minute - 59) / 60 : (minute > 59 ? minute / 60 : 0);
        int hour = utcComponents.getTime().getHour() + hourShift;
        int dayShift = hour < 0 ? (hour - 23) / 24 : (hour > 23 ? hour / 24 : 0);
        return new DateTimeComponents(new DateComponents(utcComponents.getDate(), dayShift), new TimeComponents(hour -= 24 * dayShift, minute -= 60 * hourShift, seconds, minutesFromUTC));
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this;
    }

    public Field<T> getField() {
        return this.field;
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(TimeZone timeZone) {
        return this.getComponents(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(TimeZone timeZone, TimeScale utc) {
        FieldAbsoluteDate<T> javaEpoch = new FieldAbsoluteDate<T>(this.field, DateComponents.JAVA_EPOCH, utc);
        long milliseconds = FastMath.round((double)(this.offsetFrom(javaEpoch, utc).getReal() * 1000.0));
        return this.getComponents(timeZone.getOffset(milliseconds) / 60000, utc);
    }

    @Override
    public int compareTo(FieldAbsoluteDate<T> date) {
        return Double.compare(this.durationFrom(date).getReal(), 0.0);
    }

    public boolean equals(Object date) {
        if (date == this) {
            return true;
        }
        if (date instanceof FieldAbsoluteDate) {
            return this.durationFrom((FieldAbsoluteDate)date).getReal() == 0.0;
        }
        return false;
    }

    public boolean isEqualTo(FieldTimeStamped<T> other) {
        return this.equals(other.getDate());
    }

    public boolean isCloseTo(FieldTimeStamped<T> other, double tolerance) {
        return FastMath.abs((double)this.durationFrom(other.getDate()).getReal()) < tolerance;
    }

    public boolean isBefore(FieldTimeStamped<T> other) {
        return this.compareTo(other.getDate()) < 0;
    }

    public boolean isAfter(FieldTimeStamped<T> other) {
        return this.compareTo(other.getDate()) > 0;
    }

    public boolean isBeforeOrEqualTo(FieldTimeStamped<T> other) {
        return this.isEqualTo(other) || this.isBefore(other);
    }

    public boolean isAfterOrEqualTo(FieldTimeStamped<T> other) {
        return this.isEqualTo(other) || this.isAfter(other);
    }

    public boolean isBetween(FieldTimeStamped<T> boundary, FieldTimeStamped<T> otherBoundary) {
        FieldTimeStamped<T> end;
        FieldTimeStamped<T> beginning;
        if (boundary.getDate().isBefore(otherBoundary)) {
            beginning = boundary;
            end = otherBoundary;
        } else {
            beginning = otherBoundary;
            end = boundary;
        }
        return this.isAfter(beginning) && this.isBefore(end);
    }

    public boolean isBetweenOrEqualTo(FieldTimeStamped<T> boundary, FieldTimeStamped<T> otherBoundary) {
        return this.isEqualTo(boundary) || this.isEqualTo(otherBoundary) || this.isBetween(boundary, otherBoundary);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.durationFrom(AbsoluteDate.ARBITRARY_EPOCH).getReal());
        return (int)(l ^ l >>> 32);
    }

    @DefaultDataContext
    public String toString() {
        return this.toAbsoluteDate().toString();
    }

    public String toString(TimeScale timeScale) {
        return this.getComponents(timeScale).toStringWithoutUtcOffset();
    }

    @DefaultDataContext
    public String toString(int minutesFromUTC) {
        return this.toString(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(int minutesFromUTC, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(minutesFromUTC, utc).toString(minuteDuration);
    }

    @DefaultDataContext
    public String toString(TimeZone timeZone) {
        return this.toString(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(TimeZone timeZone, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(timeZone, utc).toString(minuteDuration);
    }

    public String toStringWithoutUtcOffset(TimeScale timeScale, int fractionDigits) {
        return this.getComponents(timeScale).toStringWithoutUtcOffset(timeScale.minuteDuration(this), fractionDigits);
    }

    @Override
    public FieldAbsoluteDate<T> shiftedBy(double dt) {
        return new FieldAbsoluteDate<T>(this, dt);
    }

    public FieldAbsoluteDate<T> shiftedBy(long dt, TimeUnit timeUnit) {
        return new FieldAbsoluteDate<T>(this, dt, timeUnit);
    }

    public AbsoluteDate toAbsoluteDate() {
        return new AbsoluteDate(this.epoch, this.offset.getReal());
    }

    public boolean hasZeroField() {
        return (this.offset instanceof Derivative || this.offset instanceof Complex) && ((CalculusFieldElement)this.offset.subtract(this.offset.getReal())).isZero();
    }

    @DefaultDataContext
    public T getMJD() {
        return this.getMJD(TimeScalesFactory.getUTC());
    }

    public T getMJD(TimeScale ts) {
        AbsoluteDate absoluteDate = this.toAbsoluteDate();
        CalculusFieldElement shift = (CalculusFieldElement)this.durationFrom(absoluteDate).divide(86400.0);
        return (T)((CalculusFieldElement)shift.add(absoluteDate.getMJD(ts)));
    }

    @DefaultDataContext
    public T getJD() {
        return this.getJD(TimeScalesFactory.getUTC());
    }

    public T getJD(TimeScale ts) {
        AbsoluteDate absoluteDate = this.toAbsoluteDate();
        CalculusFieldElement shift = (CalculusFieldElement)this.durationFrom(absoluteDate).divide(86400.0);
        return (T)((CalculusFieldElement)shift.add(absoluteDate.getJD(ts)));
    }
}

