/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.hipparchus.util.FastMath;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeComponents;

public class DateTimeComponents
implements Serializable,
Comparable<DateTimeComponents> {
    public static final DateTimeComponents JULIAN_EPOCH = new DateTimeComponents(DateComponents.JULIAN_EPOCH, TimeComponents.H12);
    private static final long serialVersionUID = 5061129505488924484L;
    private final DateComponents date;
    private final TimeComponents time;

    public DateTimeComponents(DateComponents date, TimeComponents time) {
        this.date = date;
        this.time = time;
    }

    public DateTimeComponents(int year, int month, int day, int hour, int minute, double second) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = new TimeComponents(hour, minute, second);
    }

    public DateTimeComponents(int year, Month month, int day, int hour, int minute, double second) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = new TimeComponents(hour, minute, second);
    }

    public DateTimeComponents(int year, int month, int day) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = TimeComponents.H00;
    }

    public DateTimeComponents(int year, Month month, int day) throws IllegalArgumentException {
        this.date = new DateComponents(year, month, day);
        this.time = TimeComponents.H00;
    }

    public DateTimeComponents(DateTimeComponents reference, double offset) {
        int day = reference.getDate().getJ2000Day();
        double seconds = reference.getTime().getSecondsInLocalDay();
        int dayShift = (int)FastMath.floor((double)((seconds += offset) / 86400.0));
        TimeComponents tmpTime = new TimeComponents(seconds -= 86400.0 * (double)dayShift);
        this.date = new DateComponents(day += dayShift);
        this.time = new TimeComponents(tmpTime.getHour(), tmpTime.getMinute(), tmpTime.getSecond(), reference.getTime().getMinutesFromUTC());
    }

    public DateTimeComponents(DateTimeComponents reference, long offset, TimeUnit timeUnit) {
        int day = reference.getDate().getJ2000Day();
        double seconds = reference.getTime().getSecondsInLocalDay();
        long offsetInNanos = TimeUnit.NANOSECONDS.convert(offset, timeUnit);
        long daysInNanoseconds = TimeUnit.NANOSECONDS.convert(86400L, TimeUnit.SECONDS);
        int nanoDayShift = (int)FastMath.floorDiv((long)offsetInNanos, (long)daysInNanoseconds);
        int dayShift = (int)FastMath.floor((double)((seconds += (double)(offsetInNanos -= daysInNanoseconds * (long)nanoDayShift) / (double)TimeUnit.SECONDS.toNanos(1L)) / 86400.0));
        TimeComponents tmpTime = new TimeComponents(seconds -= 86400.0 * (double)dayShift);
        this.date = new DateComponents(day += dayShift + nanoDayShift);
        this.time = new TimeComponents(tmpTime.getHour(), tmpTime.getMinute(), tmpTime.getSecond(), reference.getTime().getMinutesFromUTC());
    }

    public static DateTimeComponents parseDateTime(String string) {
        int tIndex = string.indexOf(84);
        if (tIndex > 0) {
            return new DateTimeComponents(DateComponents.parseDate(string.substring(0, tIndex)), TimeComponents.parseTime(string.substring(tIndex + 1)));
        }
        return new DateTimeComponents(DateComponents.parseDate(string), TimeComponents.H00);
    }

    public double offsetFrom(DateTimeComponents dateTime) {
        int dateOffset = this.date.getJ2000Day() - dateTime.date.getJ2000Day();
        double timeOffset = this.time.getSecondsInUTCDay() - dateTime.time.getSecondsInUTCDay();
        return 86400.0 * (double)dateOffset + timeOffset;
    }

    public long offsetFrom(DateTimeComponents dateTime, TimeUnit timeUnit) {
        int dateOffset = this.date.getJ2000Day() - dateTime.date.getJ2000Day();
        double timeOffset = this.time.getSecondsInUTCDay() - dateTime.time.getSecondsInUTCDay();
        long multiplier = timeUnit.convert(1L, TimeUnit.SECONDS);
        return timeUnit.convert(Math.round(86400.0 * (double)dateOffset), TimeUnit.SECONDS) + FastMath.round((double)(timeOffset * (double)multiplier));
    }

    public DateComponents getDate() {
        return this.date;
    }

    public TimeComponents getTime() {
        return this.time;
    }

    @Override
    public int compareTo(DateTimeComponents other) {
        int dateComparison = this.date.compareTo(other.date);
        if (dateComparison < 0) {
            return -1;
        }
        if (dateComparison > 0) {
            return 1;
        }
        return this.time.compareTo(other.time);
    }

    public boolean equals(Object other) {
        try {
            DateTimeComponents otherDateTime = (DateTimeComponents)other;
            return otherDateTime != null && this.date.equals(otherDateTime.date) && this.time.equals(otherDateTime.time);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.date.hashCode() << 16 ^ this.time.hashCode();
    }

    public String toString() {
        return this.date.toString() + 'T' + this.time.toString();
    }

    public String toStringWithoutUtcOffset() {
        return this.date.toString() + 'T' + this.time.toStringWithoutUtcOffset();
    }

    public String toString(int minuteDuration) {
        return this.toString(minuteDuration, 3);
    }

    public String toString(int minuteDuration, int fractionDigits) {
        return this.toStringWithoutUtcOffset(minuteDuration, fractionDigits) + this.time.formatUtcOffset();
    }

    public String toStringWithoutUtcOffset(int minuteDuration, int fractionDigits) {
        DecimalFormat secondsFormat = new DecimalFormat("00", new DecimalFormatSymbols(Locale.US));
        secondsFormat.setMaximumFractionDigits(fractionDigits);
        secondsFormat.setMinimumFractionDigits(fractionDigits);
        DateTimeComponents rounded = this.roundIfNeeded(minuteDuration, fractionDigits);
        return rounded.getDate().toString() + 'T' + rounded.getTime().toStringWithoutUtcOffset(secondsFormat);
    }

    public DateTimeComponents roundIfNeeded(int minuteDuration, int fractionDigits) {
        double wrap;
        double second = this.time.getSecond();
        if (second >= (wrap = (double)minuteDuration - 0.5 * FastMath.pow((double)10.0, (int)(-fractionDigits)))) {
            int minute = this.time.getMinute();
            int hour = this.time.getHour();
            int j2000 = this.date.getJ2000Day();
            second = 0.0;
            if (++minute > 59) {
                minute = 0;
                if (++hour > 23) {
                    hour = 0;
                    ++j2000;
                }
            }
            return new DateTimeComponents(new DateComponents(j2000), new TimeComponents(hour, minute, second));
        }
        return this;
    }

    public String toStringRfc3339() {
        String timeZoneString;
        String timeString;
        DateComponents d = this.getDate();
        TimeComponents t = this.getTime();
        String dateString = String.format("%04d-%02d-%02dT", d.getYear(), d.getMonth(), d.getDay());
        if (t.getSecondsInLocalDay() != 0.0) {
            DecimalFormat format = new DecimalFormat("00.##############", new DecimalFormatSymbols(Locale.US));
            timeString = String.format("%02d:%02d:", t.getHour(), t.getMinute()) + format.format(t.getSecond());
        } else {
            timeString = "00:00:00";
        }
        int minutesFromUTC = t.getMinutesFromUTC();
        if (minutesFromUTC == 0) {
            timeZoneString = "Z";
        } else {
            String sign = minutesFromUTC < 0 ? "-" : "+";
            int utcOffset = FastMath.abs((int)minutesFromUTC);
            int hourOffset = utcOffset / 60;
            int minuteOffset = utcOffset % 60;
            timeZoneString = sign + String.format("%02d:%02d", hourOffset, minuteOffset);
        }
        return dateString + timeString + timeZoneString;
    }
}

