/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.Month;

public class DateComponents
implements Serializable,
Comparable<DateComponents> {
    public static final DateComponents JULIAN_EPOCH;
    public static final DateComponents MODIFIED_JULIAN_EPOCH;
    public static final DateComponents FIFTIES_EPOCH;
    public static final DateComponents CCSDS_EPOCH;
    public static final DateComponents GALILEO_EPOCH;
    public static final DateComponents GPS_EPOCH;
    public static final DateComponents QZSS_EPOCH;
    public static final DateComponents IRNSS_EPOCH;
    public static final DateComponents BEIDOU_EPOCH;
    public static final DateComponents GLONASS_EPOCH;
    public static final DateComponents J2000_EPOCH;
    public static final DateComponents JAVA_EPOCH;
    public static final DateComponents MAX_EPOCH;
    public static final DateComponents MIN_EPOCH;
    public static final double JD_TO_MJD = 2400000.5;
    private static final long serialVersionUID = -2462694707837970938L;
    private static final YearFactory PROLEPTIC_JULIAN_FACTORY;
    private static final YearFactory JULIAN_FACTORY;
    private static final YearFactory GREGORIAN_FACTORY;
    private static final MonthDayFactory LEAP_YEAR_FACTORY;
    private static final MonthDayFactory COMMON_YEAR_FACTORY;
    private static final DecimalFormatSymbols US_SYMBOLS;
    private static final int MJD_TO_J2000 = 51544;
    private static final Pattern CALENDAR_FORMAT;
    private static final Pattern ORDINAL_FORMAT;
    private static final Pattern WEEK_FORMAT;
    private final int year;
    private final int month;
    private final int day;

    public DateComponents(int year, int month, int day) throws IllegalArgumentException {
        if (month < 1 || month > 12) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_EXISTENT_MONTH, month);
        }
        this.year = year;
        this.month = month;
        this.day = day;
        DateComponents check = new DateComponents(this.getJ2000Day());
        if (year != check.year || month != check.month || day != check.day) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_EXISTENT_YEAR_MONTH_DAY, year, month, day);
        }
    }

    public DateComponents(int year, Month month, int day) throws IllegalArgumentException {
        this(year, month.getNumber(), day);
    }

    public DateComponents(int year, int dayNumber) throws IllegalArgumentException {
        this(J2000_EPOCH, new DateComponents(year - 1, 12, 31).getJ2000Day() + dayNumber);
        if (dayNumber != this.getDayOfYear()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_EXISTENT_DAY_NUMBER_IN_YEAR, dayNumber, year);
        }
    }

    public DateComponents(int offset) {
        YearFactory yFactory = GREGORIAN_FACTORY;
        if (offset < -152384) {
            yFactory = offset > -730122 ? JULIAN_FACTORY : PROLEPTIC_JULIAN_FACTORY;
        }
        this.year = yFactory.getYear(offset);
        int dayInYear = offset - yFactory.getLastJ2000DayOfYear(this.year - 1);
        MonthDayFactory mdFactory = yFactory.isLeap(this.year) ? LEAP_YEAR_FACTORY : COMMON_YEAR_FACTORY;
        this.month = mdFactory.getMonth(dayInYear);
        this.day = mdFactory.getDay(dayInYear, this.month);
    }

    public DateComponents(DateComponents epoch, int offset) {
        this(epoch.getJ2000Day() + offset);
    }

    public static DateComponents createFromWeekComponents(int wYear, int week, int dayOfWeek) throws IllegalArgumentException {
        DateComponents firstWeekMonday = new DateComponents(DateComponents.getFirstWeekMonday(wYear));
        DateComponents d = new DateComponents(firstWeekMonday, 7 * week + dayOfWeek - 8);
        if (week != d.getCalendarWeek() || dayOfWeek != d.getDayOfWeek()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_EXISTENT_WEEK_DATE, wYear, week, dayOfWeek);
        }
        return d;
    }

    public static DateComponents parseDate(String string) {
        Matcher calendarMatcher = CALENDAR_FORMAT.matcher(string);
        if (calendarMatcher.matches()) {
            return new DateComponents(Integer.parseInt(calendarMatcher.group(1)), Integer.parseInt(calendarMatcher.group(2)), Integer.parseInt(calendarMatcher.group(3)));
        }
        Matcher ordinalMatcher = ORDINAL_FORMAT.matcher(string);
        if (ordinalMatcher.matches()) {
            return new DateComponents(Integer.parseInt(ordinalMatcher.group(1)), Integer.parseInt(ordinalMatcher.group(2)));
        }
        Matcher weekMatcher = WEEK_FORMAT.matcher(string);
        if (weekMatcher.matches()) {
            return DateComponents.createFromWeekComponents(Integer.parseInt(weekMatcher.group(1)), Integer.parseInt(weekMatcher.group(2)), Integer.parseInt(weekMatcher.group(3)));
        }
        throw new OrekitIllegalArgumentException(OrekitMessages.NON_EXISTENT_DATE, string);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public Month getMonthEnum() {
        return Month.getMonth(this.month);
    }

    public int getDay() {
        return this.day;
    }

    public int getJ2000Day() {
        YearFactory yFactory = GREGORIAN_FACTORY;
        if (this.year < 1583) {
            if (this.year < 1) {
                yFactory = PROLEPTIC_JULIAN_FACTORY;
            } else if (this.year < 1582 || this.month < 10 || this.month < 11 && this.day < 5) {
                yFactory = JULIAN_FACTORY;
            }
        }
        MonthDayFactory mdFactory = yFactory.isLeap(this.year) ? LEAP_YEAR_FACTORY : COMMON_YEAR_FACTORY;
        return yFactory.getLastJ2000DayOfYear(this.year - 1) + mdFactory.getDayInYear(this.month, this.day);
    }

    public int getMJD() {
        return 51544 + this.getJ2000Day();
    }

    public int getCalendarWeek() {
        int weekYearLength;
        int firstWeekMonday = DateComponents.getFirstWeekMonday(this.year);
        int daysSincefirstMonday = this.getJ2000Day() - firstWeekMonday;
        if (daysSincefirstMonday < 0) {
            daysSincefirstMonday += firstWeekMonday - DateComponents.getFirstWeekMonday(this.year - 1);
        } else if (daysSincefirstMonday > 363 && daysSincefirstMonday >= (weekYearLength = DateComponents.getFirstWeekMonday(this.year + 1) - firstWeekMonday)) {
            daysSincefirstMonday -= weekYearLength;
        }
        return 1 + daysSincefirstMonday / 7;
    }

    private static int getFirstWeekMonday(int year) {
        int offsetToMonday;
        int yearFirst;
        return yearFirst + offsetToMonday + ((offsetToMonday = 4 - ((yearFirst = new DateComponents(year, 1, 1).getJ2000Day()) + 2) % 7) > 3 ? -7 : 0);
    }

    public int getDayOfWeek() {
        int dow = (this.getJ2000Day() + 6) % 7;
        return dow < 1 ? dow + 7 : dow;
    }

    public int getDayOfYear() {
        return this.getJ2000Day() - new DateComponents(this.year - 1, 12, 31).getJ2000Day();
    }

    public String toString() {
        return String.format(Locale.US, "%04d-%02d-%02d", this.year, this.month, this.day);
    }

    @Override
    public int compareTo(DateComponents other) {
        int otherJ2000Day;
        int j2000Day = this.getJ2000Day();
        if (j2000Day < (otherJ2000Day = other.getJ2000Day())) {
            return -1;
        }
        if (j2000Day > otherJ2000Day) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        try {
            DateComponents otherDate = (DateComponents)other;
            return otherDate != null && this.year == otherDate.year && this.month == otherDate.month && this.day == otherDate.day;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.year << 16 ^ this.month << 8 ^ this.day;
    }

    static {
        PROLEPTIC_JULIAN_FACTORY = new ProlepticJulianFactory();
        JULIAN_FACTORY = new JulianFactory();
        GREGORIAN_FACTORY = new GregorianFactory();
        LEAP_YEAR_FACTORY = new LeapYearFactory();
        COMMON_YEAR_FACTORY = new CommonYearFactory();
        US_SYMBOLS = new DecimalFormatSymbols(Locale.US);
        CALENDAR_FORMAT = Pattern.compile("^(-?\\d\\d\\d\\d)-?(\\d\\d)-?(\\d\\d)$");
        ORDINAL_FORMAT = Pattern.compile("^(-?\\d\\d\\d\\d)-?(\\d\\d\\d)$");
        WEEK_FORMAT = Pattern.compile("^(-?\\d\\d\\d\\d)-?W(\\d\\d)-?(\\d)$");
        JULIAN_EPOCH = new DateComponents(-4712, 1, 1);
        MODIFIED_JULIAN_EPOCH = new DateComponents(1858, 11, 17);
        FIFTIES_EPOCH = new DateComponents(1950, 1, 1);
        CCSDS_EPOCH = new DateComponents(1958, 1, 1);
        GALILEO_EPOCH = new DateComponents(1999, 8, 22);
        GPS_EPOCH = new DateComponents(1980, 1, 6);
        QZSS_EPOCH = new DateComponents(1980, 1, 6);
        IRNSS_EPOCH = new DateComponents(1999, 8, 22);
        BEIDOU_EPOCH = new DateComponents(2006, 1, 1);
        GLONASS_EPOCH = new DateComponents(1996, 1, 1);
        J2000_EPOCH = new DateComponents(2000, 1, 1);
        JAVA_EPOCH = new DateComponents(1970, 1, 1);
        MAX_EPOCH = new DateComponents(Integer.MAX_VALUE);
        MIN_EPOCH = new DateComponents(Integer.MIN_VALUE);
    }

    private static class CommonYearFactory
    implements MonthDayFactory {
        private static final int[] PREVIOUS_MONTH_END_DAY = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

        private CommonYearFactory() {
        }

        @Override
        public int getMonth(int dayInYear) {
            return dayInYear < 32 ? 1 : (10 * dayInYear + 323) / 306;
        }

        @Override
        public int getDay(int dayInYear, int month) {
            return dayInYear - PREVIOUS_MONTH_END_DAY[month];
        }

        @Override
        public int getDayInYear(int month, int day) {
            return day + PREVIOUS_MONTH_END_DAY[month];
        }
    }

    private static class LeapYearFactory
    implements MonthDayFactory {
        private static final int[] PREVIOUS_MONTH_END_DAY = new int[]{0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

        private LeapYearFactory() {
        }

        @Override
        public int getMonth(int dayInYear) {
            return dayInYear < 32 ? 1 : (10 * dayInYear + 313) / 306;
        }

        @Override
        public int getDay(int dayInYear, int month) {
            return dayInYear - PREVIOUS_MONTH_END_DAY[month];
        }

        @Override
        public int getDayInYear(int month, int day) {
            return day + PREVIOUS_MONTH_END_DAY[month];
        }
    }

    private static interface MonthDayFactory {
        public int getMonth(int var1);

        public int getDay(int var1, int var2);

        public int getDayInYear(int var1, int var2);
    }

    private static class GregorianFactory
    implements YearFactory {
        private GregorianFactory() {
        }

        @Override
        public int getYear(int j2000Day) {
            int year = (int)((400L * (long)j2000Day + 292194288L) / 146097L);
            if (j2000Day <= this.getLastJ2000DayOfYear(year - 1)) {
                --year;
            }
            return year;
        }

        @Override
        public int getLastJ2000DayOfYear(int year) {
            return 365 * year + year / 4 - year / 100 + year / 400 - 730120;
        }

        @Override
        public boolean isLeap(int year) {
            return year % 4 == 0 && (year % 400 == 0 || year % 100 != 0);
        }
    }

    private static class JulianFactory
    implements YearFactory {
        private JulianFactory() {
        }

        @Override
        public int getYear(int j2000Day) {
            return (int)((4L * (long)j2000Day + 2921948L) / 1461L);
        }

        @Override
        public int getLastJ2000DayOfYear(int year) {
            return 365 * year + year / 4 - 730122;
        }

        @Override
        public boolean isLeap(int year) {
            return year % 4 == 0;
        }
    }

    private static class ProlepticJulianFactory
    implements YearFactory {
        private ProlepticJulianFactory() {
        }

        @Override
        public int getYear(int j2000Day) {
            return (int)(-((-4L * (long)j2000Day - 2920488L) / 1461L));
        }

        @Override
        public int getLastJ2000DayOfYear(int year) {
            return 365 * year + (year + 1) / 4 - 730123;
        }

        @Override
        public boolean isLeap(int year) {
            return year % 4 == 0;
        }
    }

    private static interface YearFactory {
        public int getYear(int var1);

        public int getLastJ2000DayOfYear(int var1);

        public boolean isLeap(int var1);
    }
}

