/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;

public class ConstantOffsetTimeScale
implements TimeScale {
    private static final long serialVersionUID = 20240321L;
    private final String name;
    private final double offset;

    protected ConstantOffsetTimeScale(String name, double offset) {
        this.name = name;
        this.offset = offset;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return this.offset;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(this.offset));
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        return -this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

