/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockModel;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

public class ClockTimeScale
implements TimeScale {
    private static final long serialVersionUID = 20240321L;
    private final String name;
    private final TimeScale reference;
    private final transient ClockModel clockModel;

    public ClockTimeScale(String name, TimeScale reference, ClockModel clockModel) {
        this.name = name;
        this.reference = reference;
        this.clockModel = clockModel;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return this.reference.offsetFromTAI(date) + this.clockModel.getOffset(date).getOffset();
    }

    @Override
    public <T extends CalculusFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((CalculusFieldElement)this.reference.offsetFromTAI(date).add(this.clockModel.getOffset(date).getOffset()));
    }

    @Override
    public String getName() {
        return this.name;
    }
}

