/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.List;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.time.ClockOffset;

public class ClockOffsetHermiteInterpolator
extends AbstractTimeInterpolator<ClockOffset> {
    public ClockOffsetHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, 0.001);
    }

    public ClockOffsetHermiteInterpolator(int interpolationPoints, double extrapolationThreshold) {
        super(interpolationPoints, extrapolationThreshold);
    }

    @Override
    protected ClockOffset interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        HermiteInterpolator interpolator = new HermiteInterpolator();
        AbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List neighborList = interpolationData.getNeighborList();
        for (ClockOffset value : neighborList) {
            double deltaT = value.getDate().durationFrom(interpolationDate);
            double[] offset = new double[]{value.getOffset()};
            if (Double.isNaN(value.getRate())) {
                interpolator.addSamplePoint(deltaT, (double[][])new double[][]{offset});
                continue;
            }
            double[] rate = new double[]{value.getRate()};
            if (Double.isNaN(value.getAcceleration())) {
                interpolator.addSamplePoint(deltaT, (double[][])new double[][]{offset, rate});
                continue;
            }
            double[] acceleration = new double[]{value.getAcceleration()};
            interpolator.addSamplePoint(deltaT, (double[][])new double[][]{offset, rate, acceleration});
        }
        double[][] y = interpolator.derivatives(0.0, 2);
        return new ClockOffset(interpolationDate, y[0][0], y[1][0], y[2][0]);
    }
}

