/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbstractCcsdsTimeCode;

class CcsdsUnsegmentedTimeCode<T>
extends AbstractCcsdsTimeCode {
    private final T epoch;
    private final long seconds;
    private final double subSecond;

    CcsdsUnsegmentedTimeCode(byte preambleField1, byte preambleField2, byte[] timeField, T agencyDefinedEpoch, T ccsdsEpoch) {
        switch (preambleField1 & 0x70) {
            case 16: {
                this.epoch = ccsdsEpoch;
                break;
            }
            case 32: {
                if (agencyDefinedEpoch == null) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
                }
                this.epoch = agencyDefinedEpoch;
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, this.formatByte(preambleField1));
            }
        }
        int coarseTimeLength = 1 + ((preambleField1 & 0xC) >>> 2);
        int fineTimeLength = preambleField1 & 3;
        if ((preambleField1 & 0x80) != 0) {
            coarseTimeLength += (preambleField2 & 0x60) >>> 5;
            fineTimeLength += (preambleField2 & 0x1C) >>> 2;
        }
        if (timeField.length != coarseTimeLength + fineTimeLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, coarseTimeLength + fineTimeLength);
        }
        long s = 0L;
        for (int i = 0; i < coarseTimeLength; ++i) {
            s = s * 256L + (long)this.toUnsigned(timeField[i]);
        }
        this.seconds = s;
        double sub = 0.0;
        for (int i = timeField.length - 1; i >= coarseTimeLength; --i) {
            sub = (sub + (double)this.toUnsigned(timeField[i])) / 256.0;
        }
        this.subSecond = sub;
    }

    public T getEpoch() {
        return this.epoch;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public double getSubSecond() {
        return this.subSecond;
    }
}

