/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbstractCcsdsTimeCode;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;

class CcsdsSegmentedTimeCode
extends AbstractCcsdsTimeCode {
    private final DateComponents date;
    private final TimeComponents time;
    private final double subSecond;

    CcsdsSegmentedTimeCode(byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch) {
        DateComponents epoch;
        if ((preambleField & 0xF0) != 64) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, this.formatByte(preambleField));
        }
        if ((preambleField & 8) == 0) {
            epoch = DateComponents.CCSDS_EPOCH;
        } else {
            if (agencyDefinedEpoch == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_MISSING_AGENCY_EPOCH, new Object[0]);
            }
            epoch = agencyDefinedEpoch;
        }
        int daySegmentLength = (preambleField & 4) == 0 ? 2 : 3;
        int subMillisecondLength = (preambleField & 3) << 1;
        if (subMillisecondLength == 6) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, this.formatByte(preambleField));
        }
        if (timeField.length != daySegmentLength + 4 + subMillisecondLength) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, daySegmentLength + 4 + subMillisecondLength);
        }
        int i = 0;
        int day = 0;
        while (i < daySegmentLength) {
            day = day * 256 + this.toUnsigned(timeField[i++]);
        }
        long milliInDay = 0L;
        while (i < daySegmentLength + 4) {
            milliInDay = milliInDay * 256L + (long)this.toUnsigned(timeField[i++]);
        }
        int milli = (int)(milliInDay % 1000L);
        int seconds = (int)((milliInDay - (long)milli) / 1000L);
        double subMilli = 0.0;
        double divisor = 1.0;
        while (i < timeField.length) {
            subMilli = subMilli * 256.0 + (double)this.toUnsigned(timeField[i++]);
            divisor *= 1000.0;
        }
        this.date = new DateComponents(epoch, day);
        this.time = new TimeComponents(seconds);
        this.subSecond = (double)milli * 0.001 + subMilli / divisor;
    }

    CcsdsSegmentedTimeCode(byte preambleField, byte[] timeField) {
        if ((preambleField & 0xF0) != 80) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, this.formatByte(preambleField));
        }
        int length = 7 + (preambleField & 7);
        if (length == 14) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_PREAMBLE_FIELD, this.formatByte(preambleField));
        }
        if (timeField.length != length) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_DATE_INVALID_LENGTH_TIME_FIELD, timeField.length, length);
        }
        this.date = (preambleField & 8) == 0 ? new DateComponents(this.toUnsigned(timeField[0]) * 256 + this.toUnsigned(timeField[1]), this.toUnsigned(timeField[2]), this.toUnsigned(timeField[3])) : new DateComponents(this.toUnsigned(timeField[0]) * 256 + this.toUnsigned(timeField[1]), this.toUnsigned(timeField[2]) * 256 + this.toUnsigned(timeField[3]));
        this.time = new TimeComponents(this.toUnsigned(timeField[4]), this.toUnsigned(timeField[5]), this.toUnsigned(timeField[6]));
        double sub = 0.0;
        double divisor = 1.0;
        for (int i = 7; i < length; ++i) {
            sub = sub * 100.0 + (double)this.toUnsigned(timeField[i]);
            divisor *= 100.0;
        }
        this.subSecond = sub / divisor;
    }

    public DateComponents getDate() {
        return this.date;
    }

    public TimeComponents getTime() {
        return this.time;
    }

    public double getSubSecond() {
        return this.subSecond;
    }
}

