/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockModel;
import org.orekit.time.ClockOffset;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldClockOffset;
import org.orekit.utils.TimeSpanMap;

public class AggregatedClockModel
implements ClockModel {
    private final TimeSpanMap<ClockModel> models;

    public AggregatedClockModel(TimeSpanMap<ClockModel> models) {
        this.models = models;
    }

    public TimeSpanMap<ClockModel> getModels() {
        return this.models;
    }

    @Override
    public AbsoluteDate getValidityStart() {
        return this.models.getFirstNonNullSpan().getStart();
    }

    @Override
    public AbsoluteDate getValidityEnd() {
        return this.models.getLastNonNullSpan().getEnd();
    }

    @Override
    public ClockOffset getOffset(AbsoluteDate date) {
        return this.getModel(date).getOffset(date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldClockOffset<T> getOffset(FieldAbsoluteDate<T> date) {
        return this.getModel(date.toAbsoluteDate()).getOffset(date);
    }

    private ClockModel getModel(AbsoluteDate date) {
        ClockModel clockModel = this.models.get(date);
        if (clockModel == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_DATA_GENERATED, date);
        }
        return clockModel;
    }
}

