/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;
import org.orekit.frames.EOPHistory;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.GMSTScale;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;

public abstract class AbstractTimeScales
implements TimeScales {
    private final ConcurrentMap<Pair<IERSConventions, Boolean>, GMSTScale> gmstMap;
    private final ConcurrentMap<Pair<IERSConventions, Boolean>, UT1Scale> ut1Map;

    public AbstractTimeScales() {
        int n = IERSConventions.values().length;
        this.gmstMap = new ConcurrentHashMap<Pair<IERSConventions, Boolean>, GMSTScale>(n * 2);
        this.ut1Map = new ConcurrentHashMap<Pair<IERSConventions, Boolean>, UT1Scale>(n * 2);
    }

    protected UT1Scale getUT1(EOPHistory history) {
        return new UT1Scale(history, this.getUTC());
    }

    protected abstract EOPHistory getEopHistory(IERSConventions var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UT1Scale getUT1(IERSConventions conventions, boolean simpleEOP) {
        Pair key = new Pair((Object)conventions, (Object)simpleEOP);
        AbstractTimeScales abstractTimeScales = this;
        synchronized (abstractTimeScales) {
            return this.ut1Map.computeIfAbsent((Pair<IERSConventions, Boolean>)key, k -> this.getUT1(this.getEopHistory(conventions, simpleEOP)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GMSTScale getGMST(IERSConventions conventions, boolean simpleEOP) {
        Pair key = new Pair((Object)conventions, (Object)simpleEOP);
        AbstractTimeScales abstractTimeScales = this;
        synchronized (abstractTimeScales) {
            return this.gmstMap.computeIfAbsent((Pair<IERSConventions, Boolean>)key, k -> new GMSTScale(this.getUT1(conventions, simpleEOP)));
        }
    }

    @Override
    public AbsoluteDate getJulianEpoch() {
        return new AbsoluteDate(DateComponents.JULIAN_EPOCH, TimeComponents.H12, (TimeScale)this.getTT());
    }

    @Override
    public AbsoluteDate getModifiedJulianEpoch() {
        return new AbsoluteDate(DateComponents.MODIFIED_JULIAN_EPOCH, TimeComponents.H00, (TimeScale)this.getTT());
    }

    @Override
    public AbsoluteDate getFiftiesEpoch() {
        return new AbsoluteDate(DateComponents.FIFTIES_EPOCH, TimeComponents.H00, (TimeScale)this.getTT());
    }

    @Override
    public AbsoluteDate getCcsdsEpoch() {
        return new AbsoluteDate(DateComponents.CCSDS_EPOCH, TimeComponents.H00, (TimeScale)this.getTAI());
    }

    @Override
    public AbsoluteDate getGalileoEpoch() {
        return new AbsoluteDate(DateComponents.GALILEO_EPOCH, TimeComponents.H00, (TimeScale)this.getGST());
    }

    @Override
    public AbsoluteDate getGpsEpoch() {
        return new AbsoluteDate(DateComponents.GPS_EPOCH, TimeComponents.H00, (TimeScale)this.getGPS());
    }

    @Override
    public AbsoluteDate getQzssEpoch() {
        return new AbsoluteDate(DateComponents.QZSS_EPOCH, TimeComponents.H00, (TimeScale)this.getQZSS());
    }

    @Override
    public AbsoluteDate getIrnssEpoch() {
        return new AbsoluteDate(DateComponents.IRNSS_EPOCH, TimeComponents.H00, (TimeScale)this.getIRNSS());
    }

    @Override
    public AbsoluteDate getBeidouEpoch() {
        return new AbsoluteDate(DateComponents.BEIDOU_EPOCH, TimeComponents.H00, (TimeScale)this.getBDT());
    }

    @Override
    public AbsoluteDate getGlonassEpoch() {
        return new AbsoluteDate(DateComponents.GLONASS_EPOCH, new TimeComponents(29.0), (TimeScale)this.getTAI()).shiftedBy(-10800.0);
    }

    @Override
    public AbsoluteDate getJ2000Epoch() {
        return new AbsoluteDate(DateComponents.J2000_EPOCH, TimeComponents.H12, (TimeScale)this.getTT());
    }

    @Override
    public AbsoluteDate getJavaEpoch() {
        return new AbsoluteDate(DateComponents.JAVA_EPOCH, (TimeScale)this.getTAI()).shiftedBy(8.000082);
    }

    @Override
    public AbsoluteDate getPastInfinity() {
        return this.getJavaEpoch().shiftedBy(Double.NEGATIVE_INFINITY);
    }

    @Override
    public AbsoluteDate getFutureInfinity() {
        return this.getJavaEpoch().shiftedBy(Double.POSITIVE_INFINITY);
    }

    @Override
    public AbsoluteDate createJulianEpoch(double julianEpoch) {
        return new AbsoluteDate(this.getJ2000Epoch(), 3.15576E7 * (julianEpoch - 2000.0));
    }

    @Override
    public AbsoluteDate createBesselianEpoch(double besselianEpoch) {
        return new AbsoluteDate(this.getJ2000Epoch(), MathArrays.linearCombination((double)3.15569259746784E7, (double)(besselianEpoch - 1900.0), (double)86400.0, (double)-36525.0, (double)86400.0, (double)0.31352));
    }
}

