/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolator;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ImmutableTimeStampedCache;

public abstract class AbstractTimeInterpolator<T extends TimeStamped>
implements TimeInterpolator<T> {
    public static final double DEFAULT_EXTRAPOLATION_THRESHOLD_SEC = 0.001;
    public static final int DEFAULT_INTERPOLATION_POINTS = 2;
    private final double extrapolationThreshold;
    private final int interpolationPoints;

    public AbstractTimeInterpolator(int interpolationPoints, double extrapolationThreshold) {
        this.interpolationPoints = interpolationPoints;
        this.extrapolationThreshold = extrapolationThreshold;
    }

    public static void checkInterpolatorCompatibilityWithSampleSize(TimeInterpolator<? extends TimeStamped> interpolator, int sampleSize) {
        List<TimeInterpolator<TimeStamped>> subInterpolators = interpolator.getSubInterpolators();
        for (TimeInterpolator<TimeStamped> subInterpolator : subInterpolators) {
            if (sampleSize >= subInterpolator.getNbInterpolationPoints()) continue;
            throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA, sampleSize);
        }
    }

    @Override
    public T interpolate(AbsoluteDate interpolationDate, Stream<T> sample) {
        return this.interpolate(interpolationDate, sample.collect(Collectors.toList()));
    }

    @Override
    public T interpolate(AbsoluteDate interpolationDate, Collection<T> sample) {
        InterpolationData interpolationData = new InterpolationData(interpolationDate, sample);
        return this.interpolate(interpolationData);
    }

    public static <T extends TimeStamped> AbsoluteDate getCentralDate(AbsoluteDate date, ImmutableTimeStampedCache<T> cachedSamples, double threshold) {
        AbsoluteDate minDate = cachedSamples.getEarliest().getDate();
        AbsoluteDate maxDate = cachedSamples.getLatest().getDate();
        return AbstractTimeInterpolator.getCentralDate(date, minDate, maxDate, threshold);
    }

    public static <T extends TimeStamped> AbsoluteDate getCentralDate(AbsoluteDate date, AbsoluteDate minDate, AbsoluteDate maxDate, double threshold) {
        AbsoluteDate central = date.compareTo(minDate) < 0 && FastMath.abs((double)date.durationFrom(minDate)) <= threshold ? minDate : (date.compareTo(maxDate) > 0 && FastMath.abs((double)date.durationFrom(maxDate)) <= threshold ? maxDate : date);
        return central;
    }

    @Override
    public List<TimeInterpolator<? extends TimeStamped>> getSubInterpolators() {
        return Collections.singletonList(this);
    }

    @Override
    public int getNbInterpolationPoints() {
        List<TimeInterpolator<TimeStamped>> subInterpolators = this.getSubInterpolators();
        if (subInterpolators.size() == 1) {
            return this.interpolationPoints;
        }
        Optional<Integer> optionalMaxNbInterpolationPoints = subInterpolators.stream().map(TimeInterpolator::getNbInterpolationPoints).max(Integer::compareTo);
        if (optionalMaxNbInterpolationPoints.isPresent()) {
            return optionalMaxNbInterpolationPoints.get();
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public double getExtrapolationThreshold() {
        return this.extrapolationThreshold;
    }

    protected void addOptionalSubInterpolatorIfDefined(TimeInterpolator<? extends TimeStamped> subInterpolator, List<TimeInterpolator<? extends TimeStamped>> subInterpolators) {
        if (subInterpolator != null) {
            subInterpolators.addAll(subInterpolator.getSubInterpolators());
        }
    }

    protected abstract T interpolate(InterpolationData var1);

    protected double getTimeParameter(AbsoluteDate interpolatingTime, AbsoluteDate previousDate, AbsoluteDate nextDate) {
        return interpolatingTime.durationFrom(previousDate) / nextDate.getDate().durationFrom(previousDate);
    }

    public class InterpolationData {
        private final AbsoluteDate interpolationDate;
        private final List<T> neighborList;

        protected InterpolationData(AbsoluteDate interpolationDate, Collection<T> sample) {
            if (sample.isEmpty()) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA, 0);
            }
            if (sample.size() == AbstractTimeInterpolator.this.interpolationPoints) {
                this.neighborList = Collections.unmodifiableList(new ArrayList(sample));
            } else {
                ImmutableTimeStampedCache cachedSamples = new ImmutableTimeStampedCache(AbstractTimeInterpolator.this.interpolationPoints, sample);
                AbsoluteDate central = AbstractTimeInterpolator.getCentralDate(interpolationDate, cachedSamples, AbstractTimeInterpolator.this.extrapolationThreshold);
                Stream neighborsStream = cachedSamples.getNeighbors(central);
                this.neighborList = Collections.unmodifiableList(neighborsStream.collect(Collectors.toList()));
            }
            this.interpolationDate = interpolationDate;
        }

        @Deprecated
        protected AbsoluteDate getCentralDate(AbsoluteDate date) {
            return AbstractTimeInterpolator.getCentralDate(date, ((TimeStamped)this.neighborList.get(0)).getDate(), ((TimeStamped)this.neighborList.get(this.neighborList.size() - 1)).getDate(), AbstractTimeInterpolator.this.extrapolationThreshold);
        }

        public AbsoluteDate getInterpolationDate() {
            return this.interpolationDate;
        }

        @Deprecated
        public ImmutableTimeStampedCache<T> getCachedSamples() {
            return new ImmutableTimeStampedCache(AbstractTimeInterpolator.this.interpolationPoints, this.neighborList);
        }

        public List<T> getNeighborList() {
            return this.neighborList;
        }
    }
}

