/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolator;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.ImmutableFieldTimeStampedCache;

public abstract class AbstractFieldTimeInterpolator<T extends FieldTimeStamped<KK>, KK extends CalculusFieldElement<KK>>
implements FieldTimeInterpolator<T, KK> {
    public static final double DEFAULT_EXTRAPOLATION_THRESHOLD_SEC = 0.001;
    public static final int DEFAULT_INTERPOLATION_POINTS = 2;
    private final double extrapolationThreshold;
    private final int interpolationPoints;

    public AbstractFieldTimeInterpolator(int interpolationPoints, double extrapolationThreshold) {
        this.interpolationPoints = interpolationPoints;
        this.extrapolationThreshold = extrapolationThreshold;
    }

    public static <T extends CalculusFieldElement<T>> void checkInterpolatorCompatibilityWithSampleSize(FieldTimeInterpolator<? extends FieldTimeStamped<T>, T> interpolator, int sampleSize) {
        List<FieldTimeInterpolator<FieldTimeStamped<T>, T>> subInterpolators = interpolator.getSubInterpolators();
        for (FieldTimeInterpolator<FieldTimeStamped<T>, T> subInterpolator : subInterpolators) {
            if (sampleSize >= subInterpolator.getNbInterpolationPoints()) continue;
            throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA, sampleSize);
        }
    }

    @Override
    public T interpolate(FieldAbsoluteDate<KK> interpolationDate, Stream<T> sample) {
        return this.interpolate(interpolationDate, (Collection)sample.collect(Collectors.toList()));
    }

    @Override
    public T interpolate(FieldAbsoluteDate<KK> interpolationDate, Collection<T> sample) {
        InterpolationData interpolationData = new InterpolationData(interpolationDate, sample);
        return this.interpolate(interpolationData);
    }

    public static <T extends FieldTimeStamped<KK>, KK extends CalculusFieldElement<KK>> FieldAbsoluteDate<KK> getCentralDate(FieldAbsoluteDate<KK> date, ImmutableFieldTimeStampedCache<T, KK> cachedSamples, double threshold) {
        return AbstractFieldTimeInterpolator.getCentralDate(date, cachedSamples.getEarliest().getDate(), cachedSamples.getLatest().getDate(), threshold);
    }

    public static <KK extends CalculusFieldElement<KK>> FieldAbsoluteDate<KK> getCentralDate(FieldAbsoluteDate<KK> date, FieldAbsoluteDate<KK> minDate, FieldAbsoluteDate<KK> maxDate, double threshold) {
        FieldAbsoluteDate<KK> central = date.compareTo(minDate) < 0 && FastMath.abs(date.durationFrom(minDate)).getReal() <= threshold ? minDate : (date.compareTo(maxDate) > 0 && FastMath.abs(date.durationFrom(maxDate)).getReal() <= threshold ? maxDate : date);
        return central;
    }

    @Override
    public List<FieldTimeInterpolator<? extends FieldTimeStamped<KK>, KK>> getSubInterpolators() {
        return Collections.singletonList(this);
    }

    @Override
    public int getNbInterpolationPoints() {
        List<FieldTimeInterpolator<FieldTimeStamped<KK>, KK>> subInterpolators = this.getSubInterpolators();
        if (subInterpolators.size() == 1) {
            return this.interpolationPoints;
        }
        Optional<Integer> optionalMaxNbInterpolationPoints = subInterpolators.stream().map(FieldTimeInterpolator::getNbInterpolationPoints).max(Integer::compareTo);
        if (optionalMaxNbInterpolationPoints.isPresent()) {
            return optionalMaxNbInterpolationPoints.get();
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public double getExtrapolationThreshold() {
        return this.extrapolationThreshold;
    }

    protected <S extends CalculusFieldElement<S>> void addOptionalSubInterpolatorIfDefined(FieldTimeInterpolator<? extends FieldTimeStamped<S>, S> subInterpolator, List<FieldTimeInterpolator<? extends FieldTimeStamped<S>, S>> subInterpolators) {
        if (subInterpolator != null) {
            subInterpolators.addAll(subInterpolator.getSubInterpolators());
        }
    }

    protected abstract T interpolate(InterpolationData var1);

    protected KK getTimeParameter(FieldAbsoluteDate<KK> interpolatingTime, FieldAbsoluteDate<KK> previousDate, FieldAbsoluteDate<KK> nextDate) {
        return (KK)((CalculusFieldElement)interpolatingTime.durationFrom(previousDate).divide(nextDate.getDate().durationFrom(previousDate)));
    }

    public class InterpolationData {
        private final FieldAbsoluteDate<KK> interpolationDate;
        private final List<T> neighborList;
        private final Field<KK> field;
        private final KK zero;
        private final KK one;

        protected InterpolationData(FieldAbsoluteDate<KK> interpolationDate, Collection<T> sample) {
            if (sample.isEmpty()) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA, 0);
            }
            if (sample.size() == AbstractFieldTimeInterpolator.this.interpolationPoints) {
                this.neighborList = Collections.unmodifiableList(new ArrayList(sample));
            } else {
                ImmutableFieldTimeStampedCache cachedSamples = new ImmutableFieldTimeStampedCache(AbstractFieldTimeInterpolator.this.interpolationPoints, sample);
                FieldAbsoluteDate central = AbstractFieldTimeInterpolator.getCentralDate(interpolationDate, cachedSamples, AbstractFieldTimeInterpolator.this.extrapolationThreshold);
                Stream neighborsStream = cachedSamples.getNeighbors(central);
                this.neighborList = Collections.unmodifiableList(neighborsStream.collect(Collectors.toList()));
            }
            this.field = interpolationDate.getField();
            this.zero = (CalculusFieldElement)this.field.getZero();
            this.one = (CalculusFieldElement)this.field.getOne();
            this.interpolationDate = interpolationDate;
        }

        @Deprecated
        protected FieldAbsoluteDate<KK> getCentralDate(FieldAbsoluteDate<KK> date) {
            return AbstractFieldTimeInterpolator.getCentralDate(date, ((FieldTimeStamped)this.neighborList.get(0)).getDate(), ((FieldTimeStamped)this.neighborList.get(this.neighborList.size() - 1)).getDate(), AbstractFieldTimeInterpolator.this.extrapolationThreshold);
        }

        public FieldAbsoluteDate<KK> getInterpolationDate() {
            return this.interpolationDate;
        }

        @Deprecated
        public ImmutableFieldTimeStampedCache<T, KK> getCachedSamples() {
            return new ImmutableFieldTimeStampedCache(AbstractFieldTimeInterpolator.this.interpolationPoints, this.getNeighborList());
        }

        public List<T> getNeighborList() {
            return this.neighborList;
        }

        public Field<KK> getField() {
            return this.field;
        }

        public KK getZero() {
            return this.zero;
        }

        public KK getOne() {
            return this.one;
        }
    }
}

