/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.time.CcsdsSegmentedTimeCode;
import org.orekit.time.CcsdsUnsegmentedTimeCode;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.Month;
import org.orekit.time.TAIScale;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.time.UTCScale;

public class AbsoluteDate
implements TimeStamped,
TimeShiftable<AbsoluteDate>,
Comparable<AbsoluteDate>,
Serializable {
    @DefaultDataContext
    public static final AbsoluteDate JULIAN_EPOCH = DataContext.getDefault().getTimeScales().getJulianEpoch();
    @DefaultDataContext
    public static final AbsoluteDate MODIFIED_JULIAN_EPOCH = DataContext.getDefault().getTimeScales().getModifiedJulianEpoch();
    @DefaultDataContext
    public static final AbsoluteDate FIFTIES_EPOCH = DataContext.getDefault().getTimeScales().getFiftiesEpoch();
    @DefaultDataContext
    public static final AbsoluteDate CCSDS_EPOCH = DataContext.getDefault().getTimeScales().getCcsdsEpoch();
    @DefaultDataContext
    public static final AbsoluteDate GALILEO_EPOCH = DataContext.getDefault().getTimeScales().getGalileoEpoch();
    @DefaultDataContext
    public static final AbsoluteDate GPS_EPOCH = DataContext.getDefault().getTimeScales().getGpsEpoch();
    @DefaultDataContext
    public static final AbsoluteDate QZSS_EPOCH = DataContext.getDefault().getTimeScales().getQzssEpoch();
    @DefaultDataContext
    public static final AbsoluteDate IRNSS_EPOCH = DataContext.getDefault().getTimeScales().getIrnssEpoch();
    @DefaultDataContext
    public static final AbsoluteDate BEIDOU_EPOCH = DataContext.getDefault().getTimeScales().getBeidouEpoch();
    @DefaultDataContext
    public static final AbsoluteDate GLONASS_EPOCH = DataContext.getDefault().getTimeScales().getGlonassEpoch();
    @DefaultDataContext
    public static final AbsoluteDate J2000_EPOCH = DataContext.getDefault().getTimeScales().getJ2000Epoch();
    @DefaultDataContext
    public static final AbsoluteDate JAVA_EPOCH = DataContext.getDefault().getTimeScales().getJavaEpoch();
    public static final AbsoluteDate ARBITRARY_EPOCH = new AbsoluteDate(0L, 0.0);
    public static final AbsoluteDate PAST_INFINITY = ARBITRARY_EPOCH.shiftedBy(Double.NEGATIVE_INFINITY);
    public static final AbsoluteDate FUTURE_INFINITY = ARBITRARY_EPOCH.shiftedBy(Double.POSITIVE_INFINITY);
    private static final long serialVersionUID = 617061803741806846L;
    private final long epoch;
    private final double offset;

    @DefaultDataContext
    public AbsoluteDate() {
        this.epoch = AbsoluteDate.J2000_EPOCH.epoch;
        this.offset = AbsoluteDate.J2000_EPOCH.offset;
    }

    public AbsoluteDate(String location, TimeScale timeScale) {
        this(DateTimeComponents.parseDateTime(location), timeScale);
    }

    public AbsoluteDate(DateTimeComponents location, TimeScale timeScale) {
        this(location.getDate(), location.getTime(), timeScale);
    }

    public AbsoluteDate(DateComponents date, TimeComponents time, TimeScale timeScale) {
        double seconds = time.getSecond();
        double tsOffset = timeScale.offsetToTAI(date, time);
        MathUtils.SumAndResidual sumAndResidual = MathUtils.twoSum((double)seconds, (double)tsOffset);
        long dl = (long)FastMath.floor((double)sumAndResidual.getSum());
        double regularOffset = sumAndResidual.getSum() - (double)dl + sumAndResidual.getResidual();
        if (regularOffset >= 0.0) {
            this.offset = regularOffset;
            this.epoch = 60L * (((long)date.getJ2000Day() * 24L + (long)time.getHour()) * 60L + (long)time.getMinute() - (long)time.getMinutesFromUTC() - 720L) + dl;
        } else {
            this.offset = 1.0 + regularOffset;
            this.epoch = 60L * (((long)date.getJ2000Day() * 24L + (long)time.getHour()) * 60L + (long)time.getMinute() - (long)time.getMinutesFromUTC() - 720L) + dl - 1L;
        }
    }

    public AbsoluteDate(int year, int month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public AbsoluteDate(int year, Month month, int day, int hour, int minute, double second, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), new TimeComponents(hour, minute, second), timeScale);
    }

    public AbsoluteDate(DateComponents date, TimeScale timeScale) throws IllegalArgumentException {
        this(date, TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(int year, int month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(int year, Month month, int day, TimeScale timeScale) throws IllegalArgumentException {
        this(new DateComponents(year, month, day), TimeComponents.H00, timeScale);
    }

    public AbsoluteDate(Date location, TimeScale timeScale) {
        this(new DateComponents(DateComponents.JAVA_EPOCH, (int)(location.getTime() / 86400000L)), AbsoluteDate.millisToTimeComponents((int)(location.getTime() % 86400000L)), timeScale);
    }

    @Deprecated
    public AbsoluteDate(Instant instant, TimeScale timeScale) {
        this(new DateComponents(DateComponents.JAVA_EPOCH, (int)(instant.getEpochSecond() / 86400L)), AbsoluteDate.instantToTimeComponents(instant), timeScale);
    }

    @DefaultDataContext
    public AbsoluteDate(Instant instant) {
        this(instant, TimeScalesFactory.getUTC());
    }

    public AbsoluteDate(Instant instant, UTCScale utcScale) {
        this(new DateComponents(DateComponents.JAVA_EPOCH, (int)(instant.getEpochSecond() / 86400L)), AbsoluteDate.instantToTimeComponents(instant), (TimeScale)utcScale);
    }

    public AbsoluteDate(AbsoluteDate since, double elapsedDuration) {
        MathUtils.SumAndResidual sumAndResidual = MathUtils.twoSum((double)since.offset, (double)elapsedDuration);
        if (Double.isInfinite(sumAndResidual.getSum())) {
            this.offset = sumAndResidual.getSum();
            this.epoch = sumAndResidual.getSum() < 0.0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        } else {
            long dl = (long)FastMath.floor((double)sumAndResidual.getSum());
            double regularOffset = sumAndResidual.getSum() - (double)dl + sumAndResidual.getResidual();
            if (regularOffset >= 0.0) {
                this.offset = regularOffset;
                this.epoch = since.epoch + dl;
            } else {
                this.offset = 1.0 + regularOffset;
                this.epoch = since.epoch + dl - 1L;
            }
        }
    }

    public AbsoluteDate(AbsoluteDate since, long elapsedDuration, TimeUnit timeUnit) {
        long elapsedDurationNanoseconds = TimeUnit.NANOSECONDS.convert(elapsedDuration, timeUnit);
        long deltaEpoch = elapsedDurationNanoseconds / TimeUnit.SECONDS.toNanos(1L);
        double deltaOffset = (double)(elapsedDurationNanoseconds - deltaEpoch * TimeUnit.SECONDS.toNanos(1L)) / (double)TimeUnit.SECONDS.toNanos(1L);
        double newOffset = since.offset + deltaOffset;
        if (newOffset >= 1.0) {
            this.epoch = since.epoch + deltaEpoch + 1L;
            this.offset = newOffset - 1.0;
        } else if (newOffset < 0.0) {
            this.epoch = since.epoch + deltaEpoch - 1L;
            this.offset = 1.0 + newOffset;
        } else {
            this.epoch = since.epoch + deltaEpoch;
            this.offset = newOffset;
        }
    }

    public AbsoluteDate(AbsoluteDate reference, double apparentOffset, TimeScale timeScale) {
        this(new DateTimeComponents(reference.getComponents(timeScale), apparentOffset), timeScale);
    }

    AbsoluteDate(long epoch, double offset) {
        this.epoch = epoch;
        this.offset = offset;
    }

    private static TimeComponents millisToTimeComponents(int millisInDay) {
        return new TimeComponents(millisInDay / 1000, 0.001 * (double)(millisInDay % 1000));
    }

    private static TimeComponents instantToTimeComponents(Instant instant) {
        int secInDay = (int)(instant.getEpochSecond() % 86400L);
        return new TimeComponents(secInDay, 1.0E-9 * (double)instant.getNano());
    }

    long getEpoch() {
        return this.epoch;
    }

    double getOffset() {
        return this.offset;
    }

    @DefaultDataContext
    public static AbsoluteDate parseCCSDSUnsegmentedTimeCode(byte preambleField1, byte preambleField2, byte[] timeField, AbsoluteDate agencyDefinedEpoch) {
        return AbsoluteDate.parseCCSDSUnsegmentedTimeCode(preambleField1, preambleField2, timeField, agencyDefinedEpoch, DataContext.getDefault().getTimeScales().getCcsdsEpoch());
    }

    public static AbsoluteDate parseCCSDSUnsegmentedTimeCode(byte preambleField1, byte preambleField2, byte[] timeField, AbsoluteDate agencyDefinedEpoch, AbsoluteDate ccsdsEpoch) {
        CcsdsUnsegmentedTimeCode<AbsoluteDate> timeCode = new CcsdsUnsegmentedTimeCode<AbsoluteDate>(preambleField1, preambleField2, timeField, agencyDefinedEpoch, ccsdsEpoch);
        return new AbsoluteDate(timeCode.getEpoch(), (double)timeCode.getSeconds()).shiftedBy(timeCode.getSubSecond());
    }

    @DefaultDataContext
    public static AbsoluteDate parseCCSDSDaySegmentedTimeCode(byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch) {
        return AbsoluteDate.parseCCSDSDaySegmentedTimeCode(preambleField, timeField, agencyDefinedEpoch, DataContext.getDefault().getTimeScales().getUTC());
    }

    public static AbsoluteDate parseCCSDSDaySegmentedTimeCode(byte preambleField, byte[] timeField, DateComponents agencyDefinedEpoch, TimeScale utc) {
        CcsdsSegmentedTimeCode timeCode = new CcsdsSegmentedTimeCode(preambleField, timeField, agencyDefinedEpoch);
        return new AbsoluteDate(timeCode.getDate(), timeCode.getTime(), utc).shiftedBy(timeCode.getSubSecond());
    }

    @DefaultDataContext
    public static AbsoluteDate parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField) {
        return AbsoluteDate.parseCCSDSCalendarSegmentedTimeCode(preambleField, timeField, DataContext.getDefault().getTimeScales().getUTC());
    }

    public static AbsoluteDate parseCCSDSCalendarSegmentedTimeCode(byte preambleField, byte[] timeField, TimeScale utc) {
        CcsdsSegmentedTimeCode timeCode = new CcsdsSegmentedTimeCode(preambleField, timeField);
        return new AbsoluteDate(timeCode.getDate(), timeCode.getTime(), utc).shiftedBy(timeCode.getSubSecond());
    }

    public static AbsoluteDate createJDDate(int jd, double secondsSinceNoon, TimeScale timeScale) {
        return new AbsoluteDate(new DateComponents(DateComponents.JULIAN_EPOCH, jd), TimeComponents.H12, timeScale).shiftedBy(secondsSinceNoon);
    }

    public static AbsoluteDate createJDDate(int jd, double secondsSinceNoon, TimeScale timeScale, TimeScale pivotTimeScale) {
        AbsoluteDate dateInPivotTimeScale = AbsoluteDate.createJDDate(jd, secondsSinceNoon, pivotTimeScale);
        double offsetFromTAI = timeScale.offsetFromTAI(dateInPivotTimeScale) - pivotTimeScale.offsetFromTAI(dateInPivotTimeScale);
        return dateInPivotTimeScale.shiftedBy(-offsetFromTAI);
    }

    public static AbsoluteDate createMJDDate(int mjd, double secondsInDay, TimeScale timeScale) throws OrekitIllegalArgumentException {
        TimeComponents tc;
        DateComponents dc = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd);
        if (secondsInDay >= 86400.0) {
            int secondsA = 86399;
            double secondsB = secondsInDay - 86399.0;
            TimeComponents safeTC = new TimeComponents(86399, 0.0);
            AbsoluteDate safeDate = new AbsoluteDate(dc, safeTC, timeScale);
            if ((double)timeScale.minuteDuration(safeDate) > 59.0 + secondsB) {
                return safeDate.shiftedBy(secondsB);
            }
            tc = new TimeComponents(86399, secondsB);
        } else {
            tc = new TimeComponents(secondsInDay);
        }
        return new AbsoluteDate(dc, tc, timeScale);
    }

    @DefaultDataContext
    public static AbsoluteDate createJulianEpoch(double julianEpoch) {
        return DataContext.getDefault().getTimeScales().createJulianEpoch(julianEpoch);
    }

    @DefaultDataContext
    public static AbsoluteDate createBesselianEpoch(double besselianEpoch) {
        return DataContext.getDefault().getTimeScales().createBesselianEpoch(besselianEpoch);
    }

    @Override
    public AbsoluteDate shiftedBy(double dt) {
        return new AbsoluteDate(this, dt);
    }

    public AbsoluteDate shiftedBy(long dt, TimeUnit timeUnit) {
        return new AbsoluteDate(this, dt, timeUnit);
    }

    public double durationFrom(AbsoluteDate instant) {
        return (double)(this.epoch - instant.epoch) + (this.offset - instant.offset);
    }

    public long durationFrom(AbsoluteDate instant, TimeUnit timeUnit) {
        long deltaEpoch = timeUnit.convert(this.epoch - instant.epoch, TimeUnit.SECONDS);
        long multiplier = timeUnit.convert(1L, TimeUnit.SECONDS);
        long deltaOffset = FastMath.round((double)((this.offset - instant.offset) * (double)multiplier));
        return deltaEpoch + deltaOffset;
    }

    public double offsetFrom(AbsoluteDate instant, TimeScale timeScale) {
        long elapsedDurationA = this.epoch - instant.epoch;
        double elapsedDurationB = this.offset + timeScale.offsetFromTAI(this) - (instant.offset + timeScale.offsetFromTAI(instant));
        return (double)elapsedDurationA + elapsedDurationB;
    }

    public double timeScalesOffset(TimeScale scale1, TimeScale scale2) {
        return scale1.offsetFromTAI(this) - scale2.offsetFromTAI(this);
    }

    public Date toDate(TimeScale timeScale) {
        double time = (double)this.epoch + (this.offset + timeScale.offsetFromTAI(this));
        return new Date(FastMath.round((double)((time + 9.46728E8) * 1000.0)));
    }

    @DefaultDataContext
    public Instant toInstant() {
        return this.toInstant(TimeScalesFactory.getTimeScales());
    }

    public Instant toInstant(TimeScales timeScales) {
        UTCScale utc = timeScales.getUTC();
        String stringWithoutUtcOffset = this.toStringWithoutUtcOffset(utc, 9);
        LocalDateTime localDateTime = LocalDateTime.parse(stringWithoutUtcOffset, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        return localDateTime.toInstant(ZoneOffset.UTC);
    }

    public DateTimeComponents getComponents(TimeScale timeScale) {
        long time;
        if (Double.isInfinite(this.offset)) {
            if (this.offset < 0.0) {
                return new DateTimeComponents(DateComponents.MIN_EPOCH, TimeComponents.H00);
            }
            return new DateTimeComponents(DateComponents.MAX_EPOCH, new TimeComponents(23, 59, 59.999));
        }
        double taiOffset = timeScale.offsetFromTAI(this);
        MathUtils.SumAndResidual sumAndResidual = MathUtils.twoSum((double)this.offset, (double)taiOffset);
        long carry = (long)FastMath.floor((double)sumAndResidual.getSum());
        double offset2000B = sumAndResidual.getSum() - (double)carry + sumAndResidual.getResidual();
        long offset2000A = this.epoch + carry + 43200L;
        if (offset2000B < 0.0) {
            --offset2000A;
            offset2000B += 1.0;
        }
        if ((time = offset2000A % 86400L) < 0L) {
            time += 86400L;
        }
        int date = (int)((offset2000A - time) / 86400L);
        DateComponents dateComponents = new DateComponents(DateComponents.J2000_EPOCH, date);
        double leap = timeScale.insideLeap(this) ? timeScale.getLeap(this) : 0.0;
        int minuteDuration = timeScale.minuteDuration(this);
        TimeComponents timeComponents = TimeComponents.fromSeconds((int)time, offset2000B, leap, minuteDuration);
        return new DateTimeComponents(dateComponents, timeComponents);
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(int minutesFromUTC) {
        return this.getComponents(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(int minutesFromUTC, TimeScale utc) {
        DateTimeComponents utcComponents = this.getComponents(utc);
        double seconds = utcComponents.getTime().getSecond();
        int minute = utcComponents.getTime().getMinute() + minutesFromUTC;
        int hourShift = minute < 0 ? (minute - 59) / 60 : (minute > 59 ? minute / 60 : 0);
        int hour = utcComponents.getTime().getHour() + hourShift;
        int dayShift = hour < 0 ? (hour - 23) / 24 : (hour > 23 ? hour / 24 : 0);
        return new DateTimeComponents(new DateComponents(utcComponents.getDate(), dayShift), new TimeComponents(hour -= 24 * dayShift, minute -= 60 * hourShift, seconds, minutesFromUTC));
    }

    @DefaultDataContext
    public DateTimeComponents getComponents(TimeZone timeZone) {
        return this.getComponents(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public DateTimeComponents getComponents(TimeZone timeZone, TimeScale utc) {
        AbsoluteDate javaEpoch = new AbsoluteDate(DateComponents.JAVA_EPOCH, utc);
        long milliseconds = FastMath.round((double)(1000.0 * this.offsetFrom(javaEpoch, utc)));
        return this.getComponents(timeZone.getOffset(milliseconds) / 60000, utc);
    }

    @Override
    public int compareTo(AbsoluteDate date) {
        double duration = this.durationFrom(date);
        if (!Double.isNaN(duration)) {
            return Double.compare(duration, 0.0);
        }
        return Double.compare(this.offset, date.offset);
    }

    @Override
    public AbsoluteDate getDate() {
        return this;
    }

    public boolean equals(Object date) {
        if (date == this) {
            return true;
        }
        if (date instanceof AbsoluteDate) {
            if (this.offset == Double.NEGATIVE_INFINITY && ((AbsoluteDate)date).offset == Double.NEGATIVE_INFINITY || this.offset == Double.POSITIVE_INFINITY && ((AbsoluteDate)date).offset == Double.POSITIVE_INFINITY) {
                return true;
            }
            return this.durationFrom((AbsoluteDate)date) == 0.0;
        }
        return false;
    }

    public boolean isEqualTo(TimeStamped other) {
        return this.equals(other.getDate());
    }

    public boolean isCloseTo(TimeStamped other, double tolerance) {
        return FastMath.abs((double)this.durationFrom(other.getDate())) < tolerance;
    }

    public boolean isBefore(TimeStamped other) {
        return this.compareTo(other.getDate()) < 0;
    }

    public boolean isAfter(TimeStamped other) {
        return this.compareTo(other.getDate()) > 0;
    }

    public boolean isBeforeOrEqualTo(TimeStamped other) {
        return this.isEqualTo(other) || this.isBefore(other);
    }

    public boolean isAfterOrEqualTo(TimeStamped other) {
        return this.isEqualTo(other) || this.isAfter(other);
    }

    public boolean isBetween(TimeStamped boundary, TimeStamped otherBoundary) {
        TimeStamped end;
        TimeStamped beginning;
        if (boundary.getDate().isBefore(otherBoundary)) {
            beginning = boundary;
            end = otherBoundary;
        } else {
            beginning = otherBoundary;
            end = boundary;
        }
        return this.isAfter(beginning) && this.isBefore(end);
    }

    public boolean isBetweenOrEqualTo(TimeStamped boundary, TimeStamped otherBoundary) {
        return this.isEqualTo(boundary) || this.isEqualTo(otherBoundary) || this.isBetween(boundary, otherBoundary);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.durationFrom(ARBITRARY_EPOCH));
        return (int)(l ^ l >>> 32);
    }

    @DefaultDataContext
    public String toString() {
        try {
            return this.toString(DataContext.getDefault().getTimeScales().getUTC()) + "Z";
        }
        catch (RuntimeException e1) {
            try {
                return this.toString(new TAIScale()) + " TAI";
            }
            catch (RuntimeException e2) {
                try {
                    return "(" + this.epoch + " + " + this.offset + ") seconds past epoch";
                }
                catch (RuntimeException e3) {
                    e2.addSuppressed(e3);
                    e1.addSuppressed(e2);
                    throw e1;
                }
            }
        }
    }

    public String toString(TimeScale timeScale) {
        return this.getComponents(timeScale).toStringWithoutUtcOffset();
    }

    @DefaultDataContext
    public String toString(int minutesFromUTC) {
        return this.toString(minutesFromUTC, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(int minutesFromUTC, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(minutesFromUTC, utc).toString(minuteDuration);
    }

    @DefaultDataContext
    public String toString(TimeZone timeZone) {
        return this.toString(timeZone, (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(TimeZone timeZone, TimeScale utc) {
        int minuteDuration = utc.minuteDuration(this);
        return this.getComponents(timeZone, utc).toString(minuteDuration);
    }

    public String toStringRfc3339(TimeScale utc) {
        return this.getComponents(utc).toStringRfc3339();
    }

    public String toStringWithoutUtcOffset(TimeScale timeScale, int fractionDigits) {
        return this.getComponents(timeScale).toStringWithoutUtcOffset(timeScale.minuteDuration(this), fractionDigits);
    }

    @DefaultDataContext
    public double getMJD() {
        return this.getJD() - 2400000.5;
    }

    public double getMJD(TimeScale ts) {
        return this.getJD(ts) - 2400000.5;
    }

    @DefaultDataContext
    public double getJD() {
        return this.getJD(TimeScalesFactory.getUTC());
    }

    public double getJD(TimeScale ts) {
        return this.getComponents(ts).offsetFrom(DateTimeComponents.JULIAN_EPOCH) / 86400.0;
    }
}

