/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.metrics;

import org.hipparchus.util.MathUtils;

public class ProbabilityOfCollision {
    private final double value;
    private final double lowerLimit;
    private final double upperLimit;
    private final String probabilityOfCollisionMethodName;
    private final boolean isMaxProbability;

    public ProbabilityOfCollision(double value, String probabilityOfCollisionMethodName) {
        this(value, 0.0, 0.0, probabilityOfCollisionMethodName, false);
    }

    public ProbabilityOfCollision(double value, String probabilityOfCollisionMethodName, boolean isMaxProbability) {
        this(value, 0.0, 0.0, probabilityOfCollisionMethodName, isMaxProbability);
    }

    public ProbabilityOfCollision(double value, double lowerLimit, double upperLimit, String probabilityOfCollisionMethodName, boolean isMaxProbability) {
        MathUtils.checkRangeInclusive((double)value, (double)0.0, (double)1.0);
        MathUtils.checkRangeInclusive((double)lowerLimit, (double)0.0, (double)1.0);
        MathUtils.checkRangeInclusive((double)upperLimit, (double)0.0, (double)1.0);
        this.value = value;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.probabilityOfCollisionMethodName = probabilityOfCollisionMethodName;
        this.isMaxProbability = isMaxProbability;
    }

    public double getValue() {
        return this.value;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public String getProbabilityOfCollisionMethodName() {
        return this.probabilityOfCollisionMethodName;
    }

    public boolean isMaxProbability() {
        return this.isMaxProbability;
    }
}

