/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.metrics;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.MathUtils;

public class FieldProbabilityOfCollision<T extends CalculusFieldElement<T>> {
    private final T value;
    private final T lowerLimit;
    private final T upperLimit;
    private final String probabilityOfCollisionMethodName;
    private final boolean isMaxProbability;

    public FieldProbabilityOfCollision(T value, String probabilityOfCollisionMethodName) {
        this(value, probabilityOfCollisionMethodName, false);
    }

    public FieldProbabilityOfCollision(T value, String probabilityOfCollisionMethodName, boolean isMaxProbability) {
        this((CalculusFieldElement)value, (CalculusFieldElement)value.getField().getZero(), (CalculusFieldElement)value.getField().getZero(), probabilityOfCollisionMethodName, isMaxProbability);
    }

    public FieldProbabilityOfCollision(T value, T lowerLimit, T upperLimit, String probabilityOfCollisionMethodName, boolean isMaxProbability) {
        MathUtils.checkRangeInclusive((double)value.getReal(), (double)0.0, (double)1.0);
        MathUtils.checkRangeInclusive((double)lowerLimit.getReal(), (double)0.0, (double)1.0);
        MathUtils.checkRangeInclusive((double)upperLimit.getReal(), (double)0.0, (double)1.0);
        this.value = value;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.probabilityOfCollisionMethodName = probabilityOfCollisionMethodName;
        this.isMaxProbability = isMaxProbability;
    }

    public T getValue() {
        return this.value;
    }

    public T getLowerLimit() {
        return this.lowerLimit;
    }

    public T getUpperLimit() {
        return this.upperLimit;
    }

    public String getProbabilityOfCollisionMethodName() {
        return this.probabilityOfCollisionMethodName;
    }

    public boolean isMaxProbability() {
        return this.isMaxProbability;
    }
}

