/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.EigenDecompositionSymmetric;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.KinematicTransform;
import org.orekit.frames.LOF;
import org.orekit.frames.LOFType;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.encounter.EncounterLOF;
import org.orekit.frames.encounter.EncounterLOFType;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.StateCovariance;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ShortTermEncounter2DDefinition {
    private static final double DEFAULT_ZERO_THRESHOLD = 1.0E-15;
    private static final double DEFAULT_SYMMETRY_EPSILON = 1.0E-8;
    private final AbsoluteDate tca;
    private final Orbit referenceAtTCA;
    private final StateCovariance referenceCovariance;
    private final Orbit otherAtTCA;
    private final StateCovariance otherCovariance;
    private final double combinedRadius;
    private final EncounterLOF encounterFrame;

    public ShortTermEncounter2DDefinition(Orbit referenceAtTCA, StateCovariance referenceCovariance, double referenceRadius, Orbit otherAtTCA, StateCovariance otherCovariance, double otherRadius) {
        this(referenceAtTCA, referenceCovariance, otherAtTCA, otherCovariance, referenceRadius + otherRadius);
    }

    public ShortTermEncounter2DDefinition(Orbit referenceAtTCA, StateCovariance referenceCovariance, Orbit otherAtTCA, StateCovariance otherCovariance, double combinedRadius) {
        this(referenceAtTCA, referenceCovariance, otherAtTCA, otherCovariance, combinedRadius, EncounterLOFType.DEFAULT, 1.0E-6);
    }

    public ShortTermEncounter2DDefinition(Orbit referenceAtTCA, StateCovariance referenceCovariance, double referenceRadius, Orbit otherAtTCA, StateCovariance otherCovariance, double otherRadius, EncounterLOFType encounterFrameType, double tcaTolerance) {
        this(referenceAtTCA, referenceCovariance, otherAtTCA, otherCovariance, referenceRadius + otherRadius, encounterFrameType, tcaTolerance);
    }

    public ShortTermEncounter2DDefinition(Orbit referenceAtTCA, StateCovariance referenceCovariance, Orbit otherAtTCA, StateCovariance otherCovariance, double combinedRadius, EncounterLOFType encounterFrameType, double tcaTolerance) {
        if (!referenceAtTCA.getDate().isCloseTo(otherAtTCA.getDate(), tcaTolerance)) {
            throw new OrekitException((Localizable)OrekitMessages.DIFFERENT_TIME_OF_CLOSEST_APPROACH, new Object[0]);
        }
        this.tca = referenceAtTCA.getDate();
        this.referenceAtTCA = referenceAtTCA;
        this.referenceCovariance = referenceCovariance;
        this.otherAtTCA = otherAtTCA;
        this.otherCovariance = otherCovariance;
        this.combinedRadius = combinedRadius;
        this.encounterFrame = encounterFrameType.getFrame(otherAtTCA.getPVCoordinates());
    }

    public static double computeSquaredMahalanobisDistance(double xm, double ym, double sigmaX, double sigmaY) {
        Vector2D position = new Vector2D(xm, ym);
        Array2DRowRealMatrix covariance = new Array2DRowRealMatrix((double[][])new double[][]{{sigmaX * sigmaX, 0.0}, {0.0, sigmaY * sigmaY}});
        return ShortTermEncounter2DDefinition.computeSquaredMahalanobisDistance(position, (RealMatrix)covariance);
    }

    public static double computeSquaredMahalanobisDistance(Vector2D otherPosition, RealMatrix covarianceMatrix) {
        RealMatrix covarianceMatrixInverse = new LUDecomposition(covarianceMatrix).getSolver().getInverse();
        Array2DRowRealMatrix otherPositionOnCollisionPlaneMatrix = new Array2DRowRealMatrix(otherPosition.toArray());
        return otherPositionOnCollisionPlaneMatrix.transposeMultiply(covarianceMatrixInverse.multiply((RealMatrix)otherPositionOnCollisionPlaneMatrix)).getEntry(0, 0);
    }

    public PVCoordinates computeOtherRelativeToReferencePVInReferenceInertial() {
        Frame referenceInertial = this.referenceAtTCA.getFrame();
        TimeStampedPVCoordinates referencePV = this.referenceAtTCA.getPVCoordinates();
        KinematicTransform kinematicTransform = this.otherAtTCA.getFrame().getKinematicTransformTo(referenceInertial, this.otherAtTCA.getDate());
        TimeStampedPVCoordinates otherPVInReferenceInertial = kinematicTransform.transformOnlyPV(this.otherAtTCA.getPVCoordinates());
        Vector3D relativePosition = otherPVInReferenceInertial.getPosition().subtract((Vector)referencePV.getPosition());
        Vector3D relativeVelocity = otherPVInReferenceInertial.getVelocity().subtract((Vector)referencePV.getVelocity());
        return new PVCoordinates(relativePosition, relativeVelocity);
    }

    public RealMatrix computeReferenceInertialToCollisionPlaneProjectionMatrix() {
        StaticTransform referenceInertialToEncounterFrameTransform = StaticTransform.compose(this.tca, this.computeReferenceInertialToReferenceTNWTransform(), this.computeReferenceTNWToEncounterFrameTransform());
        Array2DRowRealMatrix referenceInertialToEncounterFrameRotationMatrix = new Array2DRowRealMatrix(referenceInertialToEncounterFrameTransform.getRotation().getMatrix());
        RealMatrix encounterFrameToCollisionPlaneProjectionMatrix = this.encounterFrame.computeProjectionMatrix();
        return encounterFrameToCollisionPlaneProjectionMatrix.multiply((RealMatrix)referenceInertialToEncounterFrameRotationMatrix);
    }

    public RealMatrix computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix() {
        RealMatrix covariance = this.computeProjectedCombinedPositionalCovarianceMatrix();
        EigenDecompositionSymmetric ed = new EigenDecompositionSymmetric(covariance, 1.0E-8, false);
        return ed.getD();
    }

    public RealMatrix computeProjectedCombinedPositionalCovarianceMatrix() {
        RealMatrix combinedPositionalCovarianceMatrixInEncounterFrame = this.computeCombinedCovarianceInEncounterFrame().getMatrix().getSubMatrix(0, 2, 0, 2);
        return this.encounterFrame.projectOntoCollisionPlane(combinedPositionalCovarianceMatrixInEncounterFrame);
    }

    public StateCovariance computeCombinedCovarianceInEncounterFrame() {
        return this.computeCombinedCovarianceInReferenceTNW().changeCovarianceFrame(this.referenceAtTCA, this.encounterFrame);
    }

    public Vector2D computeOtherPositionInCollisionPlane() {
        Vector3D otherInReferenceInertial = this.otherAtTCA.getPosition(this.referenceAtTCA.getFrame());
        Vector3D otherPositionInReferenceTNW = this.computeReferenceInertialToReferenceTNWTransform().transformPosition(otherInReferenceInertial);
        Vector3D otherPositionInEncounterFrame = this.computeReferenceTNWToEncounterFrameTransform().transformPosition(otherPositionInReferenceTNW);
        return this.encounterFrame.projectOntoCollisionPlane(otherPositionInEncounterFrame);
    }

    public Vector2D computeOtherPositionInRotatedCollisionPlane() {
        return this.computeOtherPositionInRotatedCollisionPlane(1.0E-15);
    }

    public Vector2D computeOtherPositionInRotatedCollisionPlane(double zeroThreshold) {
        Array2DRowRealMatrix otherPositionInCollisionPlaneMatrix = new Array2DRowRealMatrix(this.computeOtherPositionInCollisionPlane().toArray());
        RealMatrix otherPositionRotatedInCollisionPlane = this.computeEncounterPlaneRotationMatrix(zeroThreshold).multiply((RealMatrix)otherPositionInCollisionPlaneMatrix);
        return new Vector2D(otherPositionRotatedInCollisionPlane.getColumn(0));
    }

    public double computeCoppolaEncounterDuration() {
        double DEFAULT_ALPHA_C = 5.864;
        RealMatrix combinedPositionalCovarianceMatrix = this.computeCombinedCovarianceInEncounterFrame().getMatrix().getSubMatrix(0, 2, 0, 2);
        RealMatrix projectionMatrix = this.encounterFrame.computeProjectionMatrix();
        Array2DRowRealMatrix axisNormalToCollisionPlane = new Array2DRowRealMatrix(this.encounterFrame.getAxisNormalToCollisionPlane().toArray());
        RealMatrix offPlaneCrossTermMatrix = projectionMatrix.multiply(combinedPositionalCovarianceMatrix.multiply((RealMatrix)axisNormalToCollisionPlane));
        RealMatrix probabilityDensity = this.encounterFrame.projectOntoCollisionPlane(combinedPositionalCovarianceMatrix);
        RealMatrix probabilityDensityInverse = new LUDecomposition(probabilityDensity).getSolver().getInverse();
        RealMatrix b = offPlaneCrossTermMatrix.transposeMultiply(probabilityDensityInverse).transpose();
        double recurrentTerm = b.multiplyTransposed(b).getEntry(0, 0);
        double sigmaSqNormalToPlan = axisNormalToCollisionPlane.transposeMultiply(combinedPositionalCovarianceMatrix.multiply((RealMatrix)axisNormalToCollisionPlane)).getEntry(0, 0);
        double sigmaV = FastMath.sqrt((double)(sigmaSqNormalToPlan - b.multiplyTransposed(offPlaneCrossTermMatrix).getEntry(0, 0)));
        double relativeVelocity = this.computeOtherRelativeToReferencePVInReferenceInertial().getVelocity().getNorm();
        return (2.0 * FastMath.sqrt((double)2.0) * 5.864 * sigmaV + this.combinedRadius * (FastMath.sqrt((double)(1.0 + recurrentTerm)) + FastMath.sqrt((double)recurrentTerm))) / relativeVelocity;
    }

    public double computeMissDistance() {
        Vector3D referencePositionAtTCA = this.referenceAtTCA.getPosition();
        Vector3D otherPositionAtTCA = this.otherAtTCA.getPosition(this.referenceAtTCA.getFrame());
        Vector3D relativePosition = otherPositionAtTCA.subtract((Vector)referencePositionAtTCA);
        return relativePosition.getNorm();
    }

    public double computeMahalanobisDistance() {
        return this.computeMahalanobisDistance(1.0E-15);
    }

    public double computeMahalanobisDistance(double zeroThreshold) {
        return FastMath.sqrt((double)this.computeSquaredMahalanobisDistance(zeroThreshold));
    }

    public double computeSquaredMahalanobisDistance() {
        return this.computeSquaredMahalanobisDistance(1.0E-15);
    }

    public double computeSquaredMahalanobisDistance(double zeroThreshold) {
        Array2DRowRealMatrix otherPositionAfterRotationInCollisionPlane = new Array2DRowRealMatrix(this.computeOtherPositionInRotatedCollisionPlane(zeroThreshold).toArray());
        RealMatrix inverseCovarianceMatrix = new LUDecomposition(this.computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix()).getSolver().getInverse();
        return otherPositionAfterRotationInCollisionPlane.transpose().multiply(inverseCovarianceMatrix.multiply((RealMatrix)otherPositionAfterRotationInCollisionPlane)).getEntry(0, 0);
    }

    public StateCovariance computeCombinedCovarianceInReferenceTNW() {
        RealMatrix referenceCovarianceMatrixInTNW = this.referenceCovariance.changeCovarianceFrame(this.referenceAtTCA, LOFType.TNW_INERTIAL).getMatrix();
        RealMatrix otherCovarianceMatrixInReferenceInertial = this.otherCovariance.changeCovarianceFrame(this.otherAtTCA, this.referenceAtTCA.getFrame()).getMatrix();
        StateCovariance otherCovarianceInReferenceInertial = new StateCovariance(otherCovarianceMatrixInReferenceInertial, this.tca, this.referenceAtTCA.getFrame(), OrbitType.CARTESIAN, PositionAngleType.MEAN);
        RealMatrix otherCovarianceMatrixInReferenceTNW = otherCovarianceInReferenceInertial.changeCovarianceFrame(this.referenceAtTCA, LOFType.TNW_INERTIAL).getMatrix();
        return new StateCovariance(referenceCovarianceMatrixInTNW.add(otherCovarianceMatrixInReferenceTNW), this.tca, LOFType.TNW_INERTIAL);
    }

    private Transform computeReferenceInertialToReferenceTNWTransform() {
        return LOFType.TNW.transformFromInertial(this.tca, this.referenceAtTCA.getPVCoordinates());
    }

    private Transform computeReferenceTNWToEncounterFrameTransform() {
        return LOF.transformFromLOFInToLOFOut((LOF)LOFType.TNW_INERTIAL, (LOF)this.encounterFrame, this.tca, this.referenceAtTCA.getPVCoordinates());
    }

    private RealMatrix computeEncounterPlaneRotationMatrix(double zeroThreshold) {
        double theta;
        RealMatrix combinedCovarianceMatrixInEncounterFrame = this.computeCombinedCovarianceInEncounterFrame().getMatrix();
        RealMatrix combinedPositionalCovarianceMatrixProjectedOntoBPlane = this.encounterFrame.projectOntoCollisionPlane(combinedCovarianceMatrixInEncounterFrame.getSubMatrix(0, 2, 0, 2));
        double sigmaXSquared = combinedPositionalCovarianceMatrixProjectedOntoBPlane.getEntry(0, 0);
        double sigmaYSquared = combinedPositionalCovarianceMatrixProjectedOntoBPlane.getEntry(1, 1);
        double crossTerm = combinedPositionalCovarianceMatrixProjectedOntoBPlane.getEntry(0, 1);
        double correlation = crossTerm / FastMath.sqrt((double)(sigmaXSquared * sigmaYSquared));
        if (FastMath.abs((double)crossTerm) > zeroThreshold) {
            double recurrentTerm = (sigmaYSquared - sigmaXSquared) / (2.0 * crossTerm);
            theta = FastMath.atan((double)(recurrentTerm - FastMath.signum((double)correlation) * FastMath.sqrt((double)(1.0 + FastMath.pow((double)recurrentTerm, (int)2)))));
        } else {
            theta = sigmaXSquared - sigmaYSquared > 0.0 ? 1.5707963267948966 : 0.0;
        }
        double[][] collisionPlaneRotationMatrixData = new double[][]{{FastMath.cos((double)theta), FastMath.sin((double)theta)}, {-FastMath.sin((double)theta), FastMath.cos((double)theta)}};
        return new Array2DRowRealMatrix((double[][])collisionPlaneRotationMatrixData);
    }

    public AbsoluteDate getTca() {
        return this.tca;
    }

    public Orbit getReferenceAtTCA() {
        return this.referenceAtTCA;
    }

    public Orbit getOtherAtTCA() {
        return this.otherAtTCA;
    }

    public StateCovariance getReferenceCovariance() {
        return this.referenceCovariance;
    }

    public StateCovariance getOtherCovariance() {
        return this.otherCovariance;
    }

    public double getCombinedRadius() {
        return this.combinedRadius;
    }

    public EncounterLOF getEncounterFrame() {
        return this.encounterFrame;
    }
}

