/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.integration.FieldUnivariateIntegrator;
import org.hipparchus.analysis.integration.TrapezoidIntegrator;
import org.hipparchus.analysis.integration.UnivariateIntegrator;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.AbstractShortTermEncounter1DNumerical2DPOCMethod;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DPOCMethodType;
import org.orekit.ssa.metrics.FieldProbabilityOfCollision;
import org.orekit.ssa.metrics.ProbabilityOfCollision;

public class Patera2005
extends AbstractShortTermEncounter1DNumerical2DPOCMethod {
    private static final double DEFAULT_EQUALITY_THRESHOLD = 0.1;

    public Patera2005() {
        this((UnivariateIntegrator)new TrapezoidIntegrator(5, 64), 50000);
    }

    public Patera2005(UnivariateIntegrator integrator, int maxNbOfEval) {
        super("PATERA_2005", integrator, maxNbOfEval);
    }

    @Override
    public ProbabilityOfCollision compute(double xm, double ym, double sigmaX, double sigmaY, double radius, UnivariateIntegrator integrator, int customMaxNbOfEval) {
        double value;
        double missDistance = FastMath.sqrt((double)(xm * xm + ym * ym));
        if (missDistance > radius + 0.1) {
            CommonPateraFunction function = new CommonPateraFunction(xm, ym, sigmaX, sigmaY, radius);
            value = -integrator.integrate(customMaxNbOfEval, (UnivariateFunction)function, 0.0, Math.PI * 2) / (Math.PI * 2);
        } else if (missDistance < radius - 0.1) {
            CommonPateraFunction function = new CommonPateraFunction(xm, ym, sigmaX, sigmaY, radius);
            value = 1.0 - integrator.integrate(customMaxNbOfEval, (UnivariateFunction)function, 0.0, Math.PI * 2) / (Math.PI * 2);
        } else {
            PateraFunctionSpecialCase function = new PateraFunctionSpecialCase(xm, ym, sigmaX, sigmaY, radius);
            value = integrator.integrate(customMaxNbOfEval, (UnivariateFunction)function, 0.0, Math.PI * 2) / (Math.PI * 2);
        }
        return new ProbabilityOfCollision(value, 0.0, 0.0, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(T xm, T ym, T sigmaX, T sigmaY, T radius, FieldUnivariateIntegrator<T> customIntegrator, int customMaxNbOfEval) {
        CalculusFieldElement value;
        double radiusReal;
        Field field = xm.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        CalculusFieldElement twoPiField = (CalculusFieldElement)one.newInstance(Math.PI * 2);
        double missDistance = ((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xm.square()).add((FieldElement)((CalculusFieldElement)ym.square()))).sqrt()).getReal();
        if (missDistance > (radiusReal = radius.getReal()) + 0.1) {
            CommonFieldPateraFunction function = new CommonFieldPateraFunction(xm, ym, sigmaX, sigmaY, radius, null);
            value = (CalculusFieldElement)((CalculusFieldElement)customIntegrator.integrate(customMaxNbOfEval, function, zero, twoPiField).divide((FieldElement)twoPiField)).negate();
        } else if (missDistance < radiusReal - 0.1) {
            CommonFieldPateraFunction function = new CommonFieldPateraFunction(xm, ym, sigmaX, sigmaY, radius, null);
            value = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)customIntegrator.integrate(customMaxNbOfEval, function, zero, twoPiField).divide((FieldElement)twoPiField)));
        } else {
            FieldPateraFunctionSpecialCase function = new FieldPateraFunctionSpecialCase(xm, ym, sigmaX, sigmaY, radius, null);
            value = (CalculusFieldElement)customIntegrator.integrate(customMaxNbOfEval, function, zero, twoPiField).divide((FieldElement)twoPiField);
        }
        return new FieldProbabilityOfCollision<CalculusFieldElement>(value, zero, zero, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public ShortTermEncounter2DPOCMethodType getType() {
        return ShortTermEncounter2DPOCMethodType.PATERA_2005;
    }

    private static abstract class AbstractFieldPateraFunction<T extends CalculusFieldElement<T>>
    implements CalculusFieldUnivariateFunction<T> {
        private final T xm;
        private final T ym;
        private final T scaleFactor;
        private final T sigma;
        private final T radius;

        AbstractFieldPateraFunction(T xm, T ym, T sigmaX, T sigmaY, T radius) {
            this.xm = xm;
            this.ym = ym;
            this.scaleFactor = (CalculusFieldElement)sigmaY.divide(sigmaX);
            this.sigma = sigmaY;
            this.radius = radius;
        }

        public T value(T theta) {
            return this.value(this.xm, this.ym, this.scaleFactor, this.sigma, this.radius, theta);
        }

        public abstract T value(T var1, T var2, T var3, T var4, T var5, T var6);

        public T getXPrime(T cosTheta) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)this.scaleFactor.multiply(this.xm)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.scaleFactor.multiply(this.radius)).multiply(cosTheta))));
        }

        public T getYPrime(T sinTheta) {
            return (T)((CalculusFieldElement)this.ym.add((FieldElement)((CalculusFieldElement)this.radius.multiply(sinTheta))));
        }

        public T getRSquared(T xPrime, T yPrime) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)xPrime.multiply(xPrime)).add((FieldElement)((CalculusFieldElement)yPrime.multiply(yPrime))));
        }
    }

    private static class FieldPateraFunctionSpecialCase<T extends CalculusFieldElement<T>>
    extends AbstractFieldPateraFunction<T> {
        private FieldPateraFunctionSpecialCase(T xm, T ym, T sigmaX, T sigmaY, T radius) {
            super(xm, ym, sigmaX, sigmaY, radius);
        }

        @Override
        public T value(T xm, T ym, T scaleFactor, T sigma, T radius, T theta) {
            FieldSinCos sinCosTheta = theta.sinCos();
            CalculusFieldElement sinTheta = (CalculusFieldElement)sinCosTheta.sin();
            CalculusFieldElement cosTheta = (CalculusFieldElement)sinCosTheta.cos();
            CalculusFieldElement xPrime = (CalculusFieldElement)((CalculusFieldElement)scaleFactor.multiply(xm)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)scaleFactor.multiply(radius)).multiply((FieldElement)cosTheta)));
            CalculusFieldElement yPrime = (CalculusFieldElement)ym.add((FieldElement)((CalculusFieldElement)radius.multiply((FieldElement)sinTheta)));
            CalculusFieldElement rSquared = (CalculusFieldElement)((CalculusFieldElement)xPrime.square()).add((FieldElement)((CalculusFieldElement)yPrime.square()));
            CalculusFieldElement sigmaSquared = (CalculusFieldElement)sigma.multiply(sigma);
            CalculusFieldElement oneOverTwoSigmaSq = (CalculusFieldElement)((CalculusFieldElement)sigmaSquared.multiply(2.0)).reciprocal();
            CalculusFieldElement rSqOverTwoSigmaSq = (CalculusFieldElement)rSquared.multiply((FieldElement)oneOverTwoSigmaSq);
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radius.multiply(scaleFactor)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xm.multiply((FieldElement)cosTheta)).add((FieldElement)((CalculusFieldElement)ym.multiply((FieldElement)sinTheta)))).add(radius)))).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)oneOverTwoSigmaSq.negate()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rSqOverTwoSigmaSq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rSqOverTwoSigmaSq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rSqOverTwoSigmaSq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rSqOverTwoSigmaSq.multiply(-0.001388888888888889)).add(0.041666666666666664)))).subtract(0.16666666666666666)))).add(0.5)))).subtract(1.0))))));
        }

        /* synthetic */ FieldPateraFunctionSpecialCase(CalculusFieldElement x0, CalculusFieldElement x1, CalculusFieldElement x2, CalculusFieldElement x3, CalculusFieldElement x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    private static class CommonFieldPateraFunction<T extends CalculusFieldElement<T>>
    extends AbstractFieldPateraFunction<T> {
        private CommonFieldPateraFunction(T xm, T ym, T sigmaX, T sigmaY, T radius) {
            super(xm, ym, sigmaX, sigmaY, radius);
        }

        @Override
        public T value(T xm, T ym, T scaleFactor, T sigma, T radius, T theta) {
            FieldSinCos sinCosTheta = theta.sinCos();
            CalculusFieldElement sinTheta = (CalculusFieldElement)sinCosTheta.sin();
            CalculusFieldElement cosTheta = (CalculusFieldElement)sinCosTheta.cos();
            CalculusFieldElement xPrime = this.getXPrime(cosTheta);
            CalculusFieldElement yPrime = this.getYPrime(sinTheta);
            CalculusFieldElement rSquared = this.getRSquared(xPrime, yPrime);
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rSquared.divide((FieldElement)((CalculusFieldElement)sigma.square()))).multiply(-0.5)).exp()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radius.multiply(scaleFactor)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)xm.multiply((FieldElement)cosTheta)).add((FieldElement)((CalculusFieldElement)ym.multiply((FieldElement)sinTheta)))))).add((FieldElement)((CalculusFieldElement)scaleFactor.multiply((FieldElement)((CalculusFieldElement)radius.square()))))))).divide((FieldElement)rSquared));
        }

        /* synthetic */ CommonFieldPateraFunction(CalculusFieldElement x0, CalculusFieldElement x1, CalculusFieldElement x2, CalculusFieldElement x3, CalculusFieldElement x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    private static abstract class AbstractPateraFunction
    implements UnivariateFunction {
        private final double xm;
        private final double ym;
        private final double scaleFactor;
        private final double sigma;
        private final double radius;

        AbstractPateraFunction(double xm, double ym, double sigmaX, double sigmaY, double radius) {
            this.xm = xm;
            this.ym = ym;
            this.scaleFactor = sigmaY / sigmaX;
            this.sigma = sigmaY;
            this.radius = radius;
        }

        public double value(double theta) {
            return this.value(this.xm, this.ym, this.scaleFactor, this.sigma, this.radius, theta);
        }

        public abstract double value(double var1, double var3, double var5, double var7, double var9, double var11);

        public double getXPrime(double cosTheta) {
            return this.scaleFactor * (this.xm + this.radius * cosTheta);
        }

        public double getYPrime(double sinTheta) {
            return this.ym + this.radius * sinTheta;
        }

        public double getRSquared(double xPrime, double yPrime) {
            return xPrime * xPrime + yPrime * yPrime;
        }
    }

    private static class PateraFunctionSpecialCase
    extends AbstractPateraFunction {
        private PateraFunctionSpecialCase(double xm, double ym, double sigmaX, double sigmaY, double radius) {
            super(xm, ym, sigmaX, sigmaY, radius);
        }

        @Override
        public double value(double xm, double ym, double scaleFactor, double sigma, double radius, double theta) {
            SinCos sinCosTheta = FastMath.sinCos((double)theta);
            double sinTheta = sinCosTheta.sin();
            double cosTheta = sinCosTheta.cos();
            double xPrime = this.getXPrime(cosTheta);
            double yPrime = this.getYPrime(sinTheta);
            double rSquared = this.getRSquared(xPrime, yPrime);
            double sigmaSquared = sigma * sigma;
            double oneOverTwoSigmaSq = 1.0 / (2.0 * sigmaSquared);
            double rSqOverTwoSigmaSq = oneOverTwoSigmaSq * rSquared;
            return radius * scaleFactor * (MathArrays.linearCombination((double)xm, (double)cosTheta, (double)ym, (double)sinTheta) + radius) * oneOverTwoSigmaSq * (1.0 - rSqOverTwoSigmaSq * (0.5 - rSqOverTwoSigmaSq * (0.16666666666666666 - rSqOverTwoSigmaSq * (0.041666666666666664 - rSqOverTwoSigmaSq / 720.0))));
        }
    }

    private static class CommonPateraFunction
    extends AbstractPateraFunction {
        private CommonPateraFunction(double xm, double ym, double sigmaX, double sigmaY, double radius) {
            super(xm, ym, sigmaX, sigmaY, radius);
        }

        @Override
        public double value(double xm, double ym, double scaleFactor, double sigma, double radius, double theta) {
            SinCos sinCosTheta = FastMath.sinCos((double)theta);
            double sinTheta = sinCosTheta.sin();
            double cosTheta = sinCosTheta.cos();
            double xPrime = this.getXPrime(cosTheta);
            double yPrime = this.getYPrime(sinTheta);
            double rSquared = this.getRSquared(xPrime, yPrime);
            return FastMath.exp((double)(-0.5 * rSquared / sigma / sigma)) * (radius * scaleFactor * MathArrays.linearCombination((double)xm, (double)cosTheta, (double)ym, (double)sinTheta) + scaleFactor * radius * radius) / rSquared;
        }
    }
}

