/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.stat.StatUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.AbstractShortTermEncounter2DPOCMethod;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DPOCMethodType;
import org.orekit.ssa.metrics.FieldProbabilityOfCollision;
import org.orekit.ssa.metrics.ProbabilityOfCollision;

public class Laas2015
extends AbstractShortTermEncounter2DPOCMethod {
    public static final double DEFAULT_SCALING_THRESHOLD = 1.0E10;
    private final double absoluteAccuracy;
    private final int maxNumberOfTerms;

    public Laas2015() {
        this(1.0E-30, 37000);
    }

    public Laas2015(double absoluteAccuracy, int maxNumberOfTerms) {
        super(ShortTermEncounter2DPOCMethodType.LAAS_2015.name());
        this.absoluteAccuracy = absoluteAccuracy;
        this.maxNumberOfTerms = maxNumberOfTerms;
    }

    @Override
    public final ProbabilityOfCollision compute(double xm, double ym, double sigmaX, double sigmaY, double radius) {
        double u0;
        double xmSquared = xm * xm;
        double ymSquared = ym * ym;
        double sigmaXSq = sigmaX * sigmaX;
        double sigmaYSq = sigmaY * sigmaY;
        double radiusSquared = radius * radius;
        double p = 1.0 / (2.0 * (sigmaX * sigmaX));
        double phiY = 1.0 - sigmaX / sigmaY * sigmaX / sigmaY;
        double omegaX = xm / (2.0 * sigmaXSq) * (xm / (2.0 * sigmaXSq));
        double omegaY = ym / (2.0 * sigmaYSq) * (ym / (2.0 * sigmaYSq));
        double bigOmega = phiY * 0.5 + (omegaX + omegaY) / p;
        double alpha0 = 0.5 * FastMath.exp((double)(-(xmSquared / sigmaXSq + ymSquared / sigmaYSq) * 0.5)) / sigmaX / sigmaY;
        double l0 = alpha0 * (1.0 - FastMath.exp((double)(-p * radiusSquared))) / p;
        double u0Temp = alpha0 * (FastMath.exp((double)(p * bigOmega * radiusSquared)) - FastMath.exp((double)(-p * radiusSquared))) / (p * (1.0 + bigOmega));
        double d = u0 = u0Temp > 1.0 ? 1.0 : u0Temp;
        if (u0 - l0 <= this.absoluteAccuracy) {
            return new ProbabilityOfCollision(StatUtils.mean((double[])new double[]{u0, l0}), u0, l0, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
        }
        int n1 = (int)(2.0 * FastMath.ceil((double)(Math.E * p * radiusSquared * (1.0 + bigOmega))));
        double n2_inter = alpha0 * FastMath.exp((double)(p * radiusSquared * bigOmega)) / (this.absoluteAccuracy * p * FastMath.sqrt((double)(Math.PI * 2 * (double)n1)) * (1.0 + bigOmega));
        int n2 = (int)FastMath.ceil((double)FastMath.log((double)2.0, (double)n2_inter));
        int nMax = FastMath.max((int)n1, (int)n2) - 1;
        nMax = FastMath.min((int)nMax, (int)this.maxNumberOfTerms);
        double pSquared = p * p;
        double pCubed = pSquared * p;
        double pTimesRadiusSquared = p * radiusSquared;
        double radiusFourth = radiusSquared * radiusSquared;
        double radiusSixth = radiusFourth * radiusSquared;
        double phiYSquared = phiY * phiY;
        double pPhiY = p * phiY;
        double omegaSum = omegaX + omegaY;
        double pSqTimesHalfPhiYSqPlusOne = pSquared * MathArrays.linearCombination((double)0.5, (double)phiYSquared, (double)1.0, (double)1.0);
        double recurrentTerm0 = MathArrays.linearCombination((double)0.5, (double)phiY, (double)1.0, (double)1.0);
        double recurrentTerm1 = MathArrays.linearCombination((double)p, (double)recurrentTerm0, (double)1.0, (double)omegaSum);
        double recurrentTerm2 = MathArrays.linearCombination((double)1.0, (double)pSqTimesHalfPhiYSqPlusOne, (double)2.0, (double)(pPhiY * omegaY));
        double recurrentTerm3 = recurrentTerm1 * recurrentTerm1;
        double auxiliaryTerm0 = radiusSixth * pCubed * phiYSquared * omegaX;
        double auxiliaryTerm1 = radiusFourth * pSquared * phiY;
        double auxiliaryTerm2 = 2.0 * omegaX * recurrentTerm0;
        double auxiliaryTerm3 = phiY * MathArrays.linearCombination((double)2.0, (double)omegaX, (double)1.5, (double)p) + omegaSum;
        double auxiliaryTerm4 = pPhiY * recurrentTerm0 * 2.0;
        double auxiliaryTerm5 = p * (2.0 * phiY + 1.0);
        double kPlus2 = 2.0;
        double kPlus3 = 3.0;
        double kPlus4 = 4.0;
        double kPlus5 = 5.0;
        double halfY = 2.5;
        double c0 = alpha0 * radiusSquared;
        double c1 = c0 * radiusSquared * 0.5 * recurrentTerm1;
        double c2 = c0 * (radiusFourth / 12.0) * (recurrentTerm3 + recurrentTerm2);
        double c3 = c0 * (radiusSixth / 144.0) * (recurrentTerm1 * (recurrentTerm3 + 3.0 * recurrentTerm2) + 2.0 * (pCubed * (1.0 + phiYSquared * phiY * 0.5) + 3.0 * pSquared * phiYSquared * omegaY));
        double[] initialCoefficients = new double[]{c0, c1, c2, c3};
        double sum = 0.0;
        double rescalingCounter = 0.0;
        for (int i = 0; i < FastMath.min((int)nMax, (int)4); ++i) {
            if (!((sum += initialCoefficients[i]) > 1.0E10)) continue;
            rescalingCounter += FastMath.log10((double)1.0E10);
            c0 /= 1.0E10;
            c1 /= 1.0E10;
            c2 /= 1.0E10;
            c3 /= 1.0E10;
            sum /= 1.0E10;
        }
        for (int k = 0; k < nMax - 4; ++k) {
            if (sum > 1.0E10) {
                rescalingCounter += FastMath.log10((double)1.0E10);
                c0 /= 1.0E10;
                c1 /= 1.0E10;
                c2 /= 1.0E10;
                c3 /= 1.0E10;
                sum /= 1.0E10;
            }
            double denominator = kPlus4 * kPlus3;
            double temp = c3 * MathArrays.linearCombination((double)1.0, (double)recurrentTerm1, (double)kPlus3, (double)auxiliaryTerm5);
            temp -= c2 * pTimesRadiusSquared * MathArrays.linearCombination((double)halfY, (double)auxiliaryTerm4, (double)1.0, (double)auxiliaryTerm3) / kPlus4;
            temp += c1 * auxiliaryTerm1 * MathArrays.linearCombination((double)halfY, (double)pPhiY, (double)1.0, (double)auxiliaryTerm2) / denominator;
            temp -= c0 * auxiliaryTerm0 / (denominator * kPlus2);
            c0 = c1;
            c1 = c2;
            c2 = c3;
            c3 = temp *= radiusSquared / (kPlus4 * kPlus5);
            kPlus2 = kPlus3;
            kPlus3 = kPlus4;
            kPlus4 = kPlus5;
            kPlus5 += 1.0;
            halfY += 1.0;
            sum += c3;
        }
        double value = sum * FastMath.exp((double)MathArrays.linearCombination((double)FastMath.log((double)10.0), (double)rescalingCounter, (double)(-p), (double)radiusSquared));
        return new ProbabilityOfCollision(value, l0, u0, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public final <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(T xm, T ym, T sigmaX, T sigmaY, T radius) {
        CalculusFieldElement u0;
        Field field = xm.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        CalculusFieldElement xmSquared = (CalculusFieldElement)xm.square();
        CalculusFieldElement ymSquared = (CalculusFieldElement)ym.square();
        CalculusFieldElement sigmaXSquared = (CalculusFieldElement)sigmaX.square();
        CalculusFieldElement sigmaYSquared = (CalculusFieldElement)sigmaY.square();
        CalculusFieldElement twoSigmaXY = (CalculusFieldElement)((CalculusFieldElement)sigmaX.multiply(sigmaY)).multiply(2);
        CalculusFieldElement radiusSquared = (CalculusFieldElement)radius.square();
        CalculusFieldElement radiusFourth = (CalculusFieldElement)radiusSquared.square();
        CalculusFieldElement radiusSixth = (CalculusFieldElement)radiusFourth.multiply((FieldElement)radiusSquared);
        CalculusFieldElement p = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sigmaX.square()).reciprocal()).multiply(0.5);
        CalculusFieldElement pTimesRadiusSquared = (CalculusFieldElement)p.multiply((FieldElement)radiusSquared);
        CalculusFieldElement phiY = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sigmaXSquared.divide((FieldElement)sigmaYSquared)).negate()).add(1.0);
        CalculusFieldElement omegaX = (CalculusFieldElement)((CalculusFieldElement)xm.divide((FieldElement)((CalculusFieldElement)sigmaXSquared.multiply(2.0)))).pow(2.0);
        CalculusFieldElement omegaY = (CalculusFieldElement)((CalculusFieldElement)ym.divide((FieldElement)((CalculusFieldElement)sigmaYSquared.multiply(2.0)))).pow(2.0);
        CalculusFieldElement omegaSum = (CalculusFieldElement)omegaX.add((FieldElement)omegaY);
        CalculusFieldElement bigOmega = (CalculusFieldElement)((CalculusFieldElement)phiY.multiply(0.5)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)omegaX.add((FieldElement)omegaY)).divide((FieldElement)p)));
        CalculusFieldElement minusP = (CalculusFieldElement)p.negate();
        CalculusFieldElement pSquared = (CalculusFieldElement)p.square();
        CalculusFieldElement pCubed = (CalculusFieldElement)p.multiply((FieldElement)pSquared);
        CalculusFieldElement pPhiY = (CalculusFieldElement)p.multiply((FieldElement)phiY);
        CalculusFieldElement phiYSquared = (CalculusFieldElement)phiY.square();
        CalculusFieldElement pRadiusSquaredBigOmega = (CalculusFieldElement)((CalculusFieldElement)p.multiply((FieldElement)radiusSquared)).multiply((FieldElement)bigOmega);
        CalculusFieldElement bigOmegaPlusOne = (CalculusFieldElement)bigOmega.add(1.0);
        CalculusFieldElement pSqTimesHalfPhiYSqPlusOne = (CalculusFieldElement)pSquared.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)phiYSquared.multiply(0.5)).add(1.0)));
        CalculusFieldElement alpha0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xmSquared.divide((FieldElement)sigmaXSquared)).add((FieldElement)((CalculusFieldElement)ymSquared.divide((FieldElement)sigmaYSquared)))).multiply(-0.5)).exp()).divide((FieldElement)twoSigmaXY);
        CalculusFieldElement l0 = (CalculusFieldElement)((CalculusFieldElement)alpha0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radiusSquared.multiply((FieldElement)minusP)).exp()).negate()).add(1.0)))).divide((FieldElement)p);
        CalculusFieldElement u0Temp = (CalculusFieldElement)((CalculusFieldElement)alpha0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)pRadiusSquaredBigOmega.exp()).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)radiusSquared.multiply((FieldElement)minusP)).exp()))))).divide((FieldElement)((CalculusFieldElement)p.multiply((FieldElement)bigOmegaPlusOne)));
        CalculusFieldElement calculusFieldElement = u0 = u0Temp.getReal() > 1.0 ? one : u0Temp;
        if (u0.getReal() - l0.getReal() <= this.absoluteAccuracy) {
            return new FieldProbabilityOfCollision<CalculusFieldElement>((CalculusFieldElement)((CalculusFieldElement)u0.add((FieldElement)l0)).multiply(0.5), u0, l0, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
        }
        int n1 = (int)(2.0 * FastMath.ceil((double)(Math.E * ((CalculusFieldElement)((CalculusFieldElement)p.multiply((FieldElement)radiusSquared)).multiply((FieldElement)bigOmegaPlusOne)).getReal())));
        double n2_inter = alpha0.getReal() * FastMath.exp((double)pRadiusSquaredBigOmega.getReal()) / (this.absoluteAccuracy * p.getReal() * FastMath.sqrt((double)(Math.PI * 2 * (double)n1)) * (1.0 + bigOmega.getReal()));
        int n2 = (int)FastMath.ceil((double)FastMath.log((double)2.0, (double)n2_inter));
        int nMax = FastMath.max((int)n1, (int)n2) - 1;
        nMax = FastMath.min((int)nMax, (int)this.maxNumberOfTerms);
        CalculusFieldElement recurrentTerm0 = (CalculusFieldElement)((CalculusFieldElement)phiY.multiply(0.5)).add(1.0);
        CalculusFieldElement recurrentTerm1 = (CalculusFieldElement)((CalculusFieldElement)p.multiply((FieldElement)recurrentTerm0)).add((FieldElement)omegaSum);
        CalculusFieldElement recurrentTerm2 = (CalculusFieldElement)pSqTimesHalfPhiYSqPlusOne.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)pPhiY.multiply((FieldElement)omegaY)).multiply(2.0)));
        CalculusFieldElement recurrentTerm3 = (CalculusFieldElement)recurrentTerm1.multiply((FieldElement)recurrentTerm1);
        CalculusFieldElement auxiliaryTerm0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radiusSixth.multiply((FieldElement)pCubed)).multiply((FieldElement)phiYSquared)).multiply((FieldElement)omegaX);
        CalculusFieldElement auxiliaryTerm1 = (CalculusFieldElement)((CalculusFieldElement)radiusFourth.multiply((FieldElement)pSquared)).multiply((FieldElement)phiY);
        CalculusFieldElement auxiliaryTerm2 = (CalculusFieldElement)((CalculusFieldElement)omegaX.multiply((FieldElement)recurrentTerm0)).multiply(2.0);
        CalculusFieldElement auxiliaryTerm3 = (CalculusFieldElement)((CalculusFieldElement)phiY.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)omegaX.multiply(2.0)).add((FieldElement)((CalculusFieldElement)p.multiply(1.5)))))).add((FieldElement)omegaSum);
        CalculusFieldElement auxiliaryTerm4 = (CalculusFieldElement)((CalculusFieldElement)pPhiY.multiply((FieldElement)recurrentTerm0)).multiply(2.0);
        CalculusFieldElement auxiliaryTerm5 = (CalculusFieldElement)p.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)phiY.multiply(2.0)).add(1.0)));
        CalculusFieldElement kPlus2 = (CalculusFieldElement)one.newInstance(2.0);
        CalculusFieldElement kPlus3 = (CalculusFieldElement)one.newInstance(3.0);
        CalculusFieldElement kPlus4 = (CalculusFieldElement)one.newInstance(4.0);
        CalculusFieldElement kPlus5 = (CalculusFieldElement)one.newInstance(5.0);
        CalculusFieldElement halfY = (CalculusFieldElement)one.newInstance(2.5);
        CalculusFieldElement c0 = (CalculusFieldElement)alpha0.multiply((FieldElement)radiusSquared);
        CalculusFieldElement c1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c0.multiply((FieldElement)radiusSquared)).multiply(0.5)).multiply((FieldElement)recurrentTerm1);
        CalculusFieldElement c2 = (CalculusFieldElement)((CalculusFieldElement)c0.multiply((FieldElement)((CalculusFieldElement)radiusFourth.divide(12.0)))).multiply((FieldElement)((CalculusFieldElement)recurrentTerm3.add((FieldElement)recurrentTerm2)));
        CalculusFieldElement c3 = (CalculusFieldElement)((CalculusFieldElement)c0.multiply((FieldElement)((CalculusFieldElement)radiusSixth.divide(144.0)))).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)recurrentTerm1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)recurrentTerm2.multiply(3.0)).add((FieldElement)recurrentTerm3)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)pCubed.multiply(2.0)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)phiYSquared.multiply((FieldElement)phiY)).multiply(0.5)).add(1.0)))))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)pSquared.multiply((FieldElement)phiYSquared)).multiply((FieldElement)omegaY)).multiply(6.0)))));
        FieldVector initialCoefficients = MatrixUtils.createFieldVector((Field)field, (int)4);
        initialCoefficients.setEntry(0, (FieldElement)c0);
        initialCoefficients.setEntry(1, (FieldElement)c1);
        initialCoefficients.setEntry(2, (FieldElement)c2);
        initialCoefficients.setEntry(3, (FieldElement)c3);
        CalculusFieldElement sum = zero;
        CalculusFieldElement rescalingCounter = zero;
        for (int i = 0; i < FastMath.min((int)nMax, (int)4); ++i) {
            if (!((sum = (CalculusFieldElement)sum.add((FieldElement)((CalculusFieldElement)initialCoefficients.getEntry(i)))).getReal() > 1.0E10)) continue;
            rescalingCounter = (CalculusFieldElement)rescalingCounter.add(FastMath.log10((double)1.0E10));
            c0 = (CalculusFieldElement)c0.divide(1.0E10);
            c1 = (CalculusFieldElement)c1.divide(1.0E10);
            c2 = (CalculusFieldElement)c2.divide(1.0E10);
            c3 = (CalculusFieldElement)c3.divide(1.0E10);
            sum = (CalculusFieldElement)sum.divide(1.0E10);
        }
        for (int k = 0; k < nMax - 4; ++k) {
            if (sum.getReal() > 1.0E10) {
                rescalingCounter = (CalculusFieldElement)rescalingCounter.add(FastMath.log10((double)1.0E10));
                c0 = (CalculusFieldElement)c0.divide(1.0E10);
                c1 = (CalculusFieldElement)c1.divide(1.0E10);
                c2 = (CalculusFieldElement)c2.divide(1.0E10);
                c3 = (CalculusFieldElement)c3.divide(1.0E10);
                sum = (CalculusFieldElement)sum.divide(1.0E10);
            }
            CalculusFieldElement denominator = (CalculusFieldElement)kPlus4.multiply((FieldElement)kPlus3);
            CalculusFieldElement temp = (CalculusFieldElement)c3.multiply((FieldElement)((CalculusFieldElement)recurrentTerm1.add((FieldElement)((CalculusFieldElement)auxiliaryTerm5.multiply((FieldElement)kPlus3)))));
            temp = (CalculusFieldElement)temp.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c2.multiply((FieldElement)pTimesRadiusSquared)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryTerm4.multiply((FieldElement)halfY)).add((FieldElement)auxiliaryTerm3)))).divide((FieldElement)kPlus4)));
            temp = (CalculusFieldElement)temp.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1.multiply((FieldElement)auxiliaryTerm1)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)pPhiY.multiply((FieldElement)halfY)).add((FieldElement)auxiliaryTerm2)))).divide((FieldElement)denominator)));
            temp = (CalculusFieldElement)temp.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c0.multiply((FieldElement)auxiliaryTerm0)).divide((FieldElement)((CalculusFieldElement)denominator.multiply((FieldElement)kPlus2)))));
            temp = (CalculusFieldElement)temp.multiply((FieldElement)((CalculusFieldElement)radiusSquared.divide((FieldElement)((CalculusFieldElement)kPlus4.multiply((FieldElement)kPlus5)))));
            c0 = c1;
            c1 = c2;
            c2 = c3;
            c3 = temp;
            kPlus2 = kPlus3;
            kPlus3 = kPlus4;
            kPlus4 = kPlus5;
            kPlus5 = (CalculusFieldElement)kPlus5.add(1.0);
            halfY = (CalculusFieldElement)halfY.add(1.0);
            sum = (CalculusFieldElement)sum.add((FieldElement)c3);
        }
        CalculusFieldElement value = (CalculusFieldElement)sum.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rescalingCounter.multiply(FastMath.log((double)10.0))).subtract((FieldElement)pTimesRadiusSquared)).exp()));
        return new FieldProbabilityOfCollision<CalculusFieldElement>(value, l0, u0, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public ShortTermEncounter2DPOCMethodType getType() {
        return ShortTermEncounter2DPOCMethodType.LAAS_2015;
    }
}

