/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.BlockFieldMatrix;
import org.hipparchus.linear.FieldLUDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOF;
import org.orekit.frames.LOFType;
import org.orekit.frames.encounter.EncounterLOF;
import org.orekit.frames.encounter.EncounterLOFType;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.FieldStateCovariance;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DDefinition;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldShortTermEncounter2DDefinition<T extends CalculusFieldElement<T>> {
    private static final double DEFAULT_ZERO_THRESHOLD = 1.0E-15;
    private final Field<T> instanceField;
    private final FieldAbsoluteDate<T> tca;
    private final FieldOrbit<T> referenceAtTCA;
    private final FieldStateCovariance<T> referenceCovariance;
    private final FieldOrbit<T> otherAtTCA;
    private final FieldStateCovariance<T> otherCovariance;
    private final T combinedRadius;
    private final EncounterLOF encounterFrame;

    public FieldShortTermEncounter2DDefinition(FieldOrbit<T> referenceAtTCA, FieldStateCovariance<T> referenceCovariance, T referenceRadius, FieldOrbit<T> otherAtTCA, FieldStateCovariance<T> otherCovariance, T otherRadius) {
        this(referenceAtTCA, referenceCovariance, otherAtTCA, otherCovariance, (CalculusFieldElement)referenceRadius.add(otherRadius));
    }

    public FieldShortTermEncounter2DDefinition(FieldOrbit<T> referenceAtTCA, FieldStateCovariance<T> referenceCovariance, FieldOrbit<T> otherAtTCA, FieldStateCovariance<T> otherCovariance, T combinedRadius) {
        this(referenceAtTCA, referenceCovariance, otherAtTCA, otherCovariance, combinedRadius, EncounterLOFType.DEFAULT, 1.0E-6);
    }

    public FieldShortTermEncounter2DDefinition(FieldOrbit<T> referenceAtTCA, FieldStateCovariance<T> referenceCovariance, T referenceRadius, FieldOrbit<T> otherAtTCA, FieldStateCovariance<T> otherCovariance, T otherRadius, EncounterLOFType encounterFrameType, double tcaTolerance) {
        this(referenceAtTCA, referenceCovariance, otherAtTCA, otherCovariance, (CalculusFieldElement)referenceRadius.add(otherRadius), encounterFrameType, tcaTolerance);
    }

    public FieldShortTermEncounter2DDefinition(FieldOrbit<T> referenceAtTCA, FieldStateCovariance<T> referenceCovariance, FieldOrbit<T> otherAtTCA, FieldStateCovariance<T> otherCovariance, T combinedRadius, EncounterLOFType encounterFrameType, double tcaTolerance) {
        if (!referenceAtTCA.getDate().isCloseTo(otherAtTCA.getDate(), tcaTolerance)) {
            throw new OrekitException((Localizable)OrekitMessages.DIFFERENT_TIME_OF_CLOSEST_APPROACH, new Object[0]);
        }
        this.tca = referenceAtTCA.getDate();
        this.instanceField = this.tca.getField();
        this.referenceAtTCA = referenceAtTCA;
        this.referenceCovariance = referenceCovariance;
        this.otherAtTCA = otherAtTCA;
        this.otherCovariance = otherCovariance;
        this.combinedRadius = combinedRadius;
        this.encounterFrame = encounterFrameType.getFrame(otherAtTCA.getPVCoordinates());
    }

    public static <T extends CalculusFieldElement<T>> T computeSquaredMahalanobisDistance(T xm, T ym, T sigmaX, T sigmaY) {
        CalculusFieldElement[][] positionData = (CalculusFieldElement[][])MathArrays.buildArray((Field)xm.getField(), (int)2, (int)1);
        positionData[0][0] = xm;
        positionData[1][0] = ym;
        FieldVector2D position = new FieldVector2D(xm, ym);
        CalculusFieldElement[][] covarianceMatrixData = (CalculusFieldElement[][])MathArrays.buildArray((Field)sigmaX.getField(), (int)2, (int)2);
        covarianceMatrixData[0][0] = (CalculusFieldElement)sigmaX.multiply(sigmaX);
        covarianceMatrixData[1][1] = (CalculusFieldElement)sigmaY.multiply(sigmaY);
        BlockFieldMatrix covariance = new BlockFieldMatrix((FieldElement[][])covarianceMatrixData);
        return FieldShortTermEncounter2DDefinition.computeSquaredMahalanobisDistance(position, covariance);
    }

    public static <T extends CalculusFieldElement<T>> T computeSquaredMahalanobisDistance(FieldVector2D<T> otherPosition, FieldMatrix<T> covarianceMatrix) {
        FieldMatrix covarianceMatrixInverse = new FieldLUDecomposition(covarianceMatrix).getSolver().getInverse();
        Array2DRowFieldMatrix otherPositionOnCollisionPlaneMatrix = new Array2DRowFieldMatrix((FieldElement[])otherPosition.toArray());
        return (T)((CalculusFieldElement)otherPositionOnCollisionPlaneMatrix.transposeMultiply(covarianceMatrixInverse.multiply((FieldMatrix)otherPositionOnCollisionPlaneMatrix)).getEntry(0, 0));
    }

    public FieldPVCoordinates<T> computeOtherRelativeToReferencePVInReferenceInertial() {
        Frame referenceInertial = this.referenceAtTCA.getFrame();
        TimeStampedFieldPVCoordinates<T> referencePV = this.referenceAtTCA.getPVCoordinates();
        FieldKinematicTransform<T> kinematicTransform = this.otherAtTCA.getFrame().getKinematicTransformTo(referenceInertial, this.referenceAtTCA.getDate());
        TimeStampedFieldPVCoordinates<T> otherPVInReferenceInertial = kinematicTransform.transformOnlyPV(this.otherAtTCA.getPVCoordinates());
        FieldVector3D relativePosition = otherPVInReferenceInertial.getPosition().subtract(referencePV.getPosition());
        FieldVector3D relativeVelocity = otherPVInReferenceInertial.getVelocity().subtract(referencePV.getVelocity());
        return new FieldPVCoordinates(relativePosition, relativeVelocity);
    }

    public FieldMatrix<T> computeReferenceInertialToCollisionPlaneProjectionMatrix() {
        FieldStaticTransform<T> referenceInertialToEncounterFrameTransform = FieldStaticTransform.compose(this.tca, this.computeReferenceInertialToReferenceTNWTransform(), this.computeReferenceTNWToEncounterFrameTransform());
        Array2DRowFieldMatrix referenceInertialToEncounterFrameRotationMatrix = new Array2DRowFieldMatrix((FieldElement[][])referenceInertialToEncounterFrameTransform.getRotation().getMatrix());
        FieldMatrix<T> encounterFrameToCollisionPlaneProjectionMatrix = this.encounterFrame.computeProjectionMatrix(this.tca.getField());
        return encounterFrameToCollisionPlaneProjectionMatrix.multiply((FieldMatrix)referenceInertialToEncounterFrameRotationMatrix);
    }

    public FieldMatrix<T> computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix() {
        FieldMatrix<T> covarianceMatrixToDiagonalize = this.computeProjectedCombinedPositionalCovarianceMatrix();
        CalculusFieldElement sigmaXSquared = (CalculusFieldElement)covarianceMatrixToDiagonalize.getEntry(0, 0);
        CalculusFieldElement sigmaYSquared = (CalculusFieldElement)covarianceMatrixToDiagonalize.getEntry(1, 1);
        CalculusFieldElement crossTerm = (CalculusFieldElement)covarianceMatrixToDiagonalize.getEntry(0, 1);
        CalculusFieldElement recurrentTerm = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sigmaXSquared.subtract((FieldElement)sigmaYSquared)).multiply(0.5)).pow(2)).add((FieldElement)((CalculusFieldElement)crossTerm.square()))).sqrt();
        CalculusFieldElement eigenValueX = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sigmaXSquared.add((FieldElement)sigmaYSquared)).multiply(0.5)).subtract((FieldElement)recurrentTerm);
        CalculusFieldElement eigenValueY = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sigmaXSquared.add((FieldElement)sigmaYSquared)).multiply(0.5)).add((FieldElement)recurrentTerm);
        BlockFieldMatrix projectedAndDiagonalizedCombinedPositionalCovarianceMatrix = new BlockFieldMatrix(this.instanceField, 2, 2);
        projectedAndDiagonalizedCombinedPositionalCovarianceMatrix.setEntry(0, 0, (FieldElement)eigenValueX);
        projectedAndDiagonalizedCombinedPositionalCovarianceMatrix.setEntry(0, 1, (FieldElement)((CalculusFieldElement)this.instanceField.getZero()));
        projectedAndDiagonalizedCombinedPositionalCovarianceMatrix.setEntry(1, 0, (FieldElement)((CalculusFieldElement)this.instanceField.getZero()));
        projectedAndDiagonalizedCombinedPositionalCovarianceMatrix.setEntry(1, 1, (FieldElement)eigenValueY);
        return projectedAndDiagonalizedCombinedPositionalCovarianceMatrix;
    }

    public FieldMatrix<T> computeProjectedCombinedPositionalCovarianceMatrix() {
        FieldMatrix combinedPositionalCovarianceMatrixInEncounterFrame = this.computeCombinedCovarianceInEncounterFrame().getMatrix().getSubMatrix(0, 2, 0, 2);
        return this.encounterFrame.projectOntoCollisionPlane(combinedPositionalCovarianceMatrixInEncounterFrame);
    }

    public FieldStateCovariance<T> computeCombinedCovarianceInEncounterFrame() {
        return this.computeCombinedCovarianceInReferenceTNW().changeCovarianceFrame(this.referenceAtTCA, this.encounterFrame);
    }

    public FieldVector2D<T> computeOtherPositionInCollisionPlane() {
        FieldVector3D<T> otherInReferenceInertial = this.otherAtTCA.getPosition(this.referenceAtTCA.getFrame());
        FieldVector3D<T> otherPositionInReferenceTNW = this.computeReferenceInertialToReferenceTNWTransform().transformPosition(otherInReferenceInertial);
        FieldVector3D<T> otherPositionInEncounterFrame = this.computeReferenceTNWToEncounterFrameTransform().transformPosition(otherPositionInReferenceTNW);
        return this.encounterFrame.projectOntoCollisionPlane(otherPositionInEncounterFrame);
    }

    public FieldVector2D<T> computeOtherPositionInRotatedCollisionPlane() {
        return this.computeOtherPositionInRotatedCollisionPlane(1.0E-15);
    }

    public FieldVector2D<T> computeOtherPositionInRotatedCollisionPlane(double zeroThreshold) {
        Array2DRowFieldMatrix otherPositionInCollisionPlaneMatrix = new Array2DRowFieldMatrix((FieldElement[])this.computeOtherPositionInCollisionPlane().toArray());
        FieldMatrix otherPositionRotatedInCollisionPlane = this.computeEncounterPlaneRotationMatrix(zeroThreshold).multiply((FieldMatrix)otherPositionInCollisionPlaneMatrix);
        return new FieldVector2D((CalculusFieldElement[])otherPositionRotatedInCollisionPlane.getColumn(0));
    }

    public T computeCoppolaEncounterDuration() {
        CalculusFieldElement DEFAULT_ALPHA_C = (CalculusFieldElement)((CalculusFieldElement)this.instanceField.getZero()).newInstance(5.864);
        FieldMatrix combinedPositionalCovarianceMatrix = this.computeCombinedCovarianceInEncounterFrame().getMatrix().getSubMatrix(0, 2, 0, 2);
        FieldMatrix<T> projectionMatrix = this.encounterFrame.computeProjectionMatrix(this.instanceField);
        Array2DRowFieldMatrix axisNormalToCollisionPlane = new Array2DRowFieldMatrix((FieldElement[])this.encounterFrame.getAxisNormalToCollisionPlane(this.instanceField).toArray());
        FieldMatrix offPlaneCrossTermMatrix = projectionMatrix.multiply(combinedPositionalCovarianceMatrix.multiply((FieldMatrix)axisNormalToCollisionPlane));
        FieldMatrix probabilityDensity = this.encounterFrame.projectOntoCollisionPlane(combinedPositionalCovarianceMatrix);
        FieldMatrix probabilityDensityInverse = new FieldLUDecomposition(probabilityDensity).getSolver().getInverse();
        FieldMatrix b = offPlaneCrossTermMatrix.transposeMultiply(probabilityDensityInverse).transpose();
        CalculusFieldElement recurrentTerm = (CalculusFieldElement)b.multiplyTransposed(b).getEntry(0, 0);
        CalculusFieldElement sigmaSqNormalToPlan = (CalculusFieldElement)axisNormalToCollisionPlane.transposeMultiply(combinedPositionalCovarianceMatrix.multiply((FieldMatrix)axisNormalToCollisionPlane)).getEntry(0, 0);
        CalculusFieldElement sigmaV = (CalculusFieldElement)((CalculusFieldElement)sigmaSqNormalToPlan.subtract((FieldElement)((CalculusFieldElement)b.multiplyTransposed(offPlaneCrossTermMatrix).getEntry(0, 0)))).sqrt();
        CalculusFieldElement relativeVelocity = this.computeOtherRelativeToReferencePVInReferenceInertial().getVelocity().getNorm();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)DEFAULT_ALPHA_C.multiply((FieldElement)sigmaV)).multiply(2.0 * FastMath.sqrt((double)2.0))).add((FieldElement)((CalculusFieldElement)this.combinedRadius.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)recurrentTerm.add(1.0)).sqrt()).add((FieldElement)((CalculusFieldElement)recurrentTerm.sqrt()))))))).divide((FieldElement)relativeVelocity));
    }

    public T computeMissDistance() {
        FieldVector3D<T> referencePositionAtTCA = this.referenceAtTCA.getPosition();
        FieldVector3D<T> otherPositionAtTCA = this.otherAtTCA.getPosition(this.referenceAtTCA.getFrame());
        FieldVector3D relativePosition = otherPositionAtTCA.subtract(referencePositionAtTCA);
        return (T)relativePosition.getNorm();
    }

    public T computeMahalanobisDistance() {
        return this.computeMahalanobisDistance(1.0E-15);
    }

    public T computeMahalanobisDistance(double zeroThreshold) {
        return (T)((CalculusFieldElement)this.computeSquaredMahalanobisDistance(zeroThreshold).sqrt());
    }

    public T computeSquaredMahalanobisDistance() {
        return this.computeSquaredMahalanobisDistance(1.0E-15);
    }

    public T computeSquaredMahalanobisDistance(double zeroThreshold) {
        Array2DRowFieldMatrix otherPositionAfterRotationInCollisionPlane = new Array2DRowFieldMatrix((FieldElement[])this.computeOtherPositionInRotatedCollisionPlane(zeroThreshold).toArray());
        FieldMatrix inverseCovarianceMatrix = new FieldLUDecomposition(this.computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix()).getSolver().getInverse();
        return (T)((CalculusFieldElement)otherPositionAfterRotationInCollisionPlane.transpose().multiply(inverseCovarianceMatrix.multiply((FieldMatrix)otherPositionAfterRotationInCollisionPlane)).getEntry(0, 0));
    }

    public ShortTermEncounter2DDefinition toEncounter() {
        return new ShortTermEncounter2DDefinition(this.referenceAtTCA.toOrbit(), this.referenceCovariance.toStateCovariance(), this.otherAtTCA.toOrbit(), this.otherCovariance.toStateCovariance(), this.combinedRadius.getReal());
    }

    public FieldStateCovariance<T> computeCombinedCovarianceInReferenceTNW() {
        FieldMatrix<T> referenceCovarianceMatrixInTNW = this.referenceCovariance.changeCovarianceFrame(this.referenceAtTCA, LOFType.TNW_INERTIAL).getMatrix();
        FieldMatrix<T> otherCovarianceMatrixInReferenceInertial = this.otherCovariance.changeCovarianceFrame(this.otherAtTCA, this.referenceAtTCA.getFrame()).getMatrix();
        FieldStateCovariance<T> otherCovarianceInReferenceInertial = new FieldStateCovariance<T>(otherCovarianceMatrixInReferenceInertial, this.tca, this.referenceAtTCA.getFrame(), OrbitType.CARTESIAN, PositionAngleType.MEAN);
        FieldMatrix<T> otherCovarianceMatrixInReferenceTNW = otherCovarianceInReferenceInertial.changeCovarianceFrame(this.referenceAtTCA, LOFType.TNW_INERTIAL).getMatrix();
        return new FieldStateCovariance<T>(referenceCovarianceMatrixInTNW.add(otherCovarianceMatrixInReferenceTNW), this.tca, LOFType.TNW_INERTIAL);
    }

    private FieldTransform<T> computeReferenceInertialToReferenceTNWTransform() {
        return LOFType.TNW.transformFromInertial(this.tca, this.referenceAtTCA.getPVCoordinates());
    }

    private FieldTransform<T> computeReferenceTNWToEncounterFrameTransform() {
        return LOF.transformFromLOFInToLOFOut((LOF)LOFType.TNW_INERTIAL, (LOF)this.encounterFrame, this.tca, this.referenceAtTCA.getPVCoordinates());
    }

    private FieldMatrix<T> computeEncounterPlaneRotationMatrix(double zeroThreshold) {
        CalculusFieldElement theta;
        FieldMatrix<T> combinedCovarianceMatrixInEncounterFrame = this.computeCombinedCovarianceInEncounterFrame().getMatrix();
        FieldMatrix combinedPositionalCovarianceMatrixProjectedOntoBPlane = this.encounterFrame.projectOntoCollisionPlane(combinedCovarianceMatrixInEncounterFrame.getSubMatrix(0, 2, 0, 2));
        CalculusFieldElement sigmaXSquared = (CalculusFieldElement)combinedPositionalCovarianceMatrixProjectedOntoBPlane.getEntry(0, 0);
        CalculusFieldElement sigmaYSquared = (CalculusFieldElement)combinedPositionalCovarianceMatrixProjectedOntoBPlane.getEntry(1, 1);
        CalculusFieldElement crossTerm = (CalculusFieldElement)combinedPositionalCovarianceMatrixProjectedOntoBPlane.getEntry(0, 1);
        CalculusFieldElement correlation = (CalculusFieldElement)crossTerm.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sigmaXSquared.multiply((FieldElement)sigmaYSquared)).sqrt()));
        if (FastMath.abs((CalculusFieldElement)crossTerm).getReal() > zeroThreshold) {
            CalculusFieldElement recurrentTerm = (CalculusFieldElement)((CalculusFieldElement)sigmaYSquared.subtract((FieldElement)sigmaXSquared)).divide((FieldElement)((CalculusFieldElement)crossTerm.multiply(2)));
            theta = (CalculusFieldElement)((CalculusFieldElement)recurrentTerm.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)correlation.sign()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)recurrentTerm.pow(2)).add(1.0)).sqrt()))))).atan();
        } else {
            theta = ((CalculusFieldElement)sigmaXSquared.subtract((FieldElement)sigmaYSquared)).getReal() > 0.0 ? (CalculusFieldElement)((CalculusFieldElement)this.tca.getField().getZero()).newInstance(1.5707963267948966) : (CalculusFieldElement)this.tca.getField().getZero();
        }
        CalculusFieldElement cosTheta = (CalculusFieldElement)theta.cos();
        CalculusFieldElement sinTheta = (CalculusFieldElement)theta.sin();
        Array2DRowFieldMatrix rotationMatrix = new Array2DRowFieldMatrix(this.tca.getField(), 2, 2);
        rotationMatrix.setEntry(0, 0, (FieldElement)cosTheta);
        rotationMatrix.setEntry(0, 1, (FieldElement)sinTheta);
        rotationMatrix.setEntry(1, 0, (FieldElement)((CalculusFieldElement)sinTheta.negate()));
        rotationMatrix.setEntry(1, 1, (FieldElement)cosTheta);
        return rotationMatrix;
    }

    public FieldAbsoluteDate<T> getTca() {
        return this.tca;
    }

    public FieldOrbit<T> getReferenceAtTCA() {
        return this.referenceAtTCA;
    }

    public FieldOrbit<T> getOtherAtTCA() {
        return this.otherAtTCA;
    }

    public FieldStateCovariance<T> getReferenceCovariance() {
        return this.referenceCovariance;
    }

    public FieldStateCovariance<T> getOtherCovariance() {
        return this.otherCovariance;
    }

    public T getCombinedRadius() {
        return this.combinedRadius;
    }

    public EncounterLOF getEncounterFrame() {
        return this.encounterFrame;
    }
}

