/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.AbstractShortTermEncounter2DPOCMethod;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DPOCMethodType;
import org.orekit.ssa.metrics.FieldProbabilityOfCollision;
import org.orekit.ssa.metrics.ProbabilityOfCollision;

public class Chan1997
extends AbstractShortTermEncounter2DPOCMethod {
    public Chan1997() {
        super(ShortTermEncounter2DPOCMethodType.CHAN_1997.name());
    }

    @Override
    public ProbabilityOfCollision compute(double xm, double ym, double sigmaX, double sigmaY, double radius) {
        double u = radius * radius / (sigmaX * sigmaY);
        double v = xm * xm / (sigmaX * sigmaX) + ym * ym / (sigmaY * sigmaY);
        int M = u <= 0.01 || v <= 1.0 ? 3 : (u > 0.01 && u <= 1.0 || v > 1.0 && v <= 9.0 ? 10 : (u > 1.0 && u <= 25.0 || v > 9.0 && v <= 25.0 ? 20 : 60));
        double t = 1.0;
        double s = 1.0;
        double sum = 1.0;
        double value = FastMath.exp((double)(-v * 0.5)) * t - FastMath.exp((double)(-(u + v) * 0.5)) * t * sum;
        for (int i = 1; i < M; ++i) {
            t = v * 0.5 / (double)i * t;
            s = u * 0.5 / (double)i * s;
            value = MathArrays.linearCombination((double)1.0, (double)value, (double)FastMath.exp((double)(-v * 0.5)), (double)t) - FastMath.exp((double)(-(u + v) * 0.5)) * t * (sum += s);
        }
        return new ProbabilityOfCollision(value, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(T xm, T ym, T sigmaX, T sigmaY, T radius) {
        CalculusFieldElement u = (CalculusFieldElement)((CalculusFieldElement)radius.pow(2)).divide((FieldElement)((CalculusFieldElement)sigmaX.multiply(sigmaY)));
        CalculusFieldElement v = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xm.divide(sigmaX)).pow(2)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ym.divide(sigmaY)).pow(2)));
        int M = u.getReal() <= 0.01 || v.getReal() <= 1.0 ? 3 : (u.getReal() > 0.01 && u.getReal() <= 1.0 || v.getReal() > 1.0 && v.getReal() <= 9.0 ? 10 : (u.getReal() > 1.0 && u.getReal() <= 25.0 || v.getReal() > 9.0 && v.getReal() <= 25.0 ? 20 : 60));
        Field field = radius.getField();
        CalculusFieldElement t = (CalculusFieldElement)field.getOne();
        CalculusFieldElement s = (CalculusFieldElement)field.getOne();
        CalculusFieldElement sum = (CalculusFieldElement)field.getOne();
        CalculusFieldElement value = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v.multiply(-0.5)).exp()).multiply((FieldElement)t)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.add((FieldElement)v)).multiply(-0.5)).exp()).multiply((FieldElement)t)).multiply((FieldElement)sum)));
        for (int i = 1; i < M; ++i) {
            t = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v.multiply(0.5)).divide((double)i)).multiply((FieldElement)t);
            s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.multiply(0.5)).divide((double)i)).multiply((FieldElement)s);
            sum = (CalculusFieldElement)sum.add((FieldElement)s);
            value = (CalculusFieldElement)value.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v.multiply(-0.5)).exp()).multiply((FieldElement)t)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.add((FieldElement)v)).multiply(-0.5)).exp()).multiply((FieldElement)t)).multiply((FieldElement)sum)))));
        }
        return new FieldProbabilityOfCollision<CalculusFieldElement>(value, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public ShortTermEncounter2DPOCMethodType getType() {
        return ShortTermEncounter2DPOCMethodType.CHAN_1997;
    }
}

