/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.special.Erf;
import org.hipparchus.util.FastMath;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.AbstractShortTermEncounter2DPOCMethod;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DPOCMethodType;
import org.orekit.ssa.metrics.FieldProbabilityOfCollision;
import org.orekit.ssa.metrics.ProbabilityOfCollision;

public class Alfano2005
extends AbstractShortTermEncounter2DPOCMethod {
    public Alfano2005() {
        super(ShortTermEncounter2DPOCMethodType.ALFANO_2005.name());
    }

    @Override
    public ProbabilityOfCollision compute(double xm, double ym, double sigmaX, double sigmaY, double radius) {
        int developmentOrderM = this.computeOrderM(xm, ym, sigmaX, sigmaY, radius);
        double xStep = radius / (double)(2 * developmentOrderM);
        double x0 = 0.015 * xStep - radius;
        double m0 = 2.0 * this.getRecurrentPart(x0, xm, ym, sigmaX, sigmaY, radius);
        double mEvenSum = 0.0;
        for (int i = 1; i < developmentOrderM; ++i) {
            double x2i = 2.0 * (double)i * xStep - radius;
            mEvenSum += this.getRecurrentPart(x2i, xm, ym, sigmaX, sigmaY, radius);
        }
        double otherTerm = FastMath.exp((double)(-xm * xm / (2.0 * sigmaX * sigmaX))) * (Erf.erf((double)((-ym + radius) / (FastMath.sqrt((double)2.0) * sigmaY))) - Erf.erf((double)((-ym - radius) / (FastMath.sqrt((double)2.0) * sigmaY))));
        double mEven = 2.0 * (mEvenSum + otherTerm);
        double mOddSum = 0.0;
        for (int i = 1; i <= developmentOrderM; ++i) {
            double x2i_1 = (2.0 * (double)i - 1.0) * xStep - radius;
            mOddSum += this.getRecurrentPart(x2i_1, xm, ym, sigmaX, sigmaY, radius);
        }
        double mOdd = 4.0 * mOddSum;
        double factor = xStep / (3.0 * sigmaX * FastMath.sqrt((double)(Math.PI * 8)));
        double value = factor * (m0 + mEven + mOdd);
        return new ProbabilityOfCollision(value, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(T xm, T ym, T sigmaX, T sigmaY, T radius) {
        CalculusFieldElement zero = (CalculusFieldElement)xm.getField().getZero();
        int developmentOrderM = this.computeOrderM(xm, ym, sigmaX, sigmaY, radius);
        CalculusFieldElement xStep = (CalculusFieldElement)radius.multiply(0.5 / (double)developmentOrderM);
        CalculusFieldElement x0 = (CalculusFieldElement)((CalculusFieldElement)xStep.multiply(0.015)).subtract(radius);
        CalculusFieldElement m0 = (CalculusFieldElement)this.getRecurrentPart(x0, xm, ym, sigmaX, sigmaY, radius).multiply(2.0);
        CalculusFieldElement mEvenSum = zero;
        for (int i = 1; i < developmentOrderM; ++i) {
            CalculusFieldElement x2i = (CalculusFieldElement)((CalculusFieldElement)xStep.multiply(2.0 * (double)i)).subtract(radius);
            mEvenSum = (CalculusFieldElement)mEvenSum.add((FieldElement)this.getRecurrentPart(x2i, xm, ym, sigmaX, sigmaY, radius));
        }
        CalculusFieldElement rootTwoSigmaY = (CalculusFieldElement)sigmaY.multiply(FastMath.sqrt((double)2.0));
        CalculusFieldElement otherTerm = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xm.square()).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sigmaX.multiply(sigmaX)).multiply(-2.0)))).exp()).multiply((FieldElement)((CalculusFieldElement)Erf.erf((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radius.subtract(ym)).divide((FieldElement)rootTwoSigmaY))).subtract((FieldElement)Erf.erf((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radius.add(ym)).negate()).divide((FieldElement)rootTwoSigmaY))))));
        CalculusFieldElement mEven = (CalculusFieldElement)((CalculusFieldElement)mEvenSum.add((FieldElement)otherTerm)).multiply(2.0);
        CalculusFieldElement mOddSum = zero;
        for (int i = 1; i <= developmentOrderM; ++i) {
            CalculusFieldElement x2i_1 = (CalculusFieldElement)((CalculusFieldElement)xStep.multiply(2.0 * (double)i - 1.0)).subtract(radius);
            mOddSum = (CalculusFieldElement)mOddSum.add((FieldElement)this.getRecurrentPart(x2i_1, xm, ym, sigmaX, sigmaY, radius));
        }
        CalculusFieldElement mOdd = (CalculusFieldElement)mOddSum.multiply(4.0);
        CalculusFieldElement factor = (CalculusFieldElement)xStep.divide((FieldElement)((CalculusFieldElement)sigmaX.multiply(3.0 * FastMath.sqrt((double)(Math.PI * 8)))));
        CalculusFieldElement value = (CalculusFieldElement)factor.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m0.add((FieldElement)mEven)).add((FieldElement)mOdd)));
        return new FieldProbabilityOfCollision<CalculusFieldElement>(value, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    private int computeOrderM(double xm, double ym, double sigmaX, double sigmaY, double radius) {
        int M = (int)(5.0 * radius / FastMath.min((double)FastMath.min((double)sigmaX, (double)sigmaY), (double)FastMath.min((double)sigmaX, (double)FastMath.sqrt((double)(xm * xm + ym * ym)))));
        int LOWER_LIMIT = 10;
        int UPPER_LIMIT = 100000;
        if (M >= 100000) {
            return 100000;
        }
        if (M <= 10) {
            return 10;
        }
        return M;
    }

    private <T extends CalculusFieldElement<T>> int computeOrderM(T xm, T ym, T sigmaX, T sigmaY, T radius) {
        double xmR = xm.getReal();
        double ymR = ym.getReal();
        int M = (int)(radius.getReal() * 5.0 / FastMath.min((double)FastMath.min((double)sigmaX.getReal(), (double)sigmaY.getReal()), (double)FastMath.min((double)sigmaX.getReal(), (double)FastMath.sqrt((double)(xmR * xmR + ymR * ymR)))));
        int lowerLimit = 10;
        int upperLimit = 10000;
        if (M >= 10000) {
            return 10000;
        }
        if (M <= 10) {
            return 10;
        }
        return M;
    }

    private double getRecurrentPart(double x, double xm, double ym, double sigmaX, double sigmaY, double radius) {
        return (Erf.erf((double)((-ym + FastMath.sqrt((double)(radius * radius - x * x))) / (FastMath.sqrt((double)2.0) * sigmaY))) - Erf.erf((double)((-ym - FastMath.sqrt((double)(radius * radius - x * x))) / (FastMath.sqrt((double)2.0) * sigmaY)))) * (FastMath.exp((double)(-(x - xm) * (x - xm) / (2.0 * sigmaX * sigmaX))) + FastMath.exp((double)(-(x + xm) * (x + xm) / (2.0 * sigmaX * sigmaX))));
    }

    private <T extends CalculusFieldElement<T>> T getRecurrentPart(T x, T xm, T ym, T sigmaX, T sigmaY, T radius) {
        CalculusFieldElement minusTwoSigmaXSquared = (CalculusFieldElement)((CalculusFieldElement)sigmaX.square()).multiply(-2.0);
        CalculusFieldElement radiusSquaredMinusXSquaredSQRT = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radius.square()).subtract((FieldElement)((CalculusFieldElement)x.square()))).sqrt();
        CalculusFieldElement rootTwoSigmaY = (CalculusFieldElement)sigmaY.multiply(FastMath.sqrt((double)2.0));
        CalculusFieldElement xMinusXm = (CalculusFieldElement)x.subtract(xm);
        CalculusFieldElement xPlusXm = (CalculusFieldElement)x.add(xm);
        return (T)((CalculusFieldElement)((CalculusFieldElement)Erf.erf((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radiusSquaredMinusXSquaredSQRT.subtract(ym)).divide((FieldElement)rootTwoSigmaY))).subtract((FieldElement)Erf.erf((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)radiusSquaredMinusXSquaredSQRT.add(ym)).negate()).divide((FieldElement)rootTwoSigmaY))))).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xMinusXm.square()).divide((FieldElement)minusTwoSigmaXSquared)).exp()).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xPlusXm.square()).divide((FieldElement)minusTwoSigmaXSquared)).exp())))));
    }

    @Override
    public ShortTermEncounter2DPOCMethodType getType() {
        return ShortTermEncounter2DPOCMethodType.ALFANO_2005;
    }
}

