/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.cdm.Cdm;
import org.orekit.files.ccsds.ndm.cdm.CdmData;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadata;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.frames.encounter.EncounterLOFType;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldStateCovariance;
import org.orekit.propagation.StateCovariance;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.FieldShortTermEncounter2DDefinition;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DDefinition;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DPOCMethod;
import org.orekit.ssa.metrics.FieldProbabilityOfCollision;
import org.orekit.ssa.metrics.ProbabilityOfCollision;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.Fieldifier;
import org.orekit.utils.PVCoordinates;

public abstract class AbstractShortTermEncounter2DPOCMethod
implements ShortTermEncounter2DPOCMethod {
    public static final double DEFAULT_TCA_DIFFERENCE_TOLERANCE = 1.0E-6;
    private final String name;

    protected AbstractShortTermEncounter2DPOCMethod(String name) {
        this.name = name;
    }

    @Override
    public ProbabilityOfCollision compute(Cdm cdm, double combinedRadius) {
        CdmRelativeMetadata cdmRelativeMetadata = cdm.getRelativeMetadata();
        CdmData primaryData = cdm.getDataObject1();
        CdmData secondaryData = cdm.getDataObject2();
        DataContext cdmDataContext = cdm.getDataContext();
        Orbit primaryOrbit = this.getObjectOrbitFromCdm(cdmRelativeMetadata, primaryData, cdm.getMetadataObject1(), cdmDataContext);
        StateCovariance primaryCovariance = this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, primaryData);
        Orbit secondaryOrbit = this.getObjectOrbitFromCdm(cdmRelativeMetadata, secondaryData, cdm.getMetadataObject2(), cdmDataContext);
        StateCovariance secondaryCovariance = this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, secondaryData);
        return this.compute(primaryOrbit, primaryCovariance, secondaryOrbit, secondaryCovariance, combinedRadius, 1.0E-15);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(Cdm cdm, T combinedRadius, double zeroThreshold) {
        Field field = combinedRadius.getField();
        CdmRelativeMetadata cdmRelativeMetadata = cdm.getRelativeMetadata();
        CdmData primaryData = cdm.getDataObject1();
        CdmData secondaryData = cdm.getDataObject2();
        CdmMetadata primaryMetadata = cdm.getMetadataObject1();
        CdmMetadata secondaryMetadata = cdm.getMetadataObject2();
        DataContext cdmDataContext = cdm.getDataContext();
        Orbit primaryOrbitFromCdm = this.getObjectOrbitFromCdm(cdmRelativeMetadata, primaryData, primaryMetadata, cdmDataContext);
        FieldOrbit primaryOrbit = primaryOrbitFromCdm.getType().convertToFieldOrbit(field, primaryOrbitFromCdm);
        FieldStateCovariance primaryCovariance = Fieldifier.fieldify(field, this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, primaryData));
        Orbit secondaryOrbitFromCdm = this.getObjectOrbitFromCdm(cdmRelativeMetadata, secondaryData, secondaryMetadata, cdmDataContext);
        FieldOrbit secondaryOrbit = secondaryOrbitFromCdm.getType().convertToFieldOrbit(field, secondaryOrbitFromCdm);
        FieldStateCovariance secondaryCovariance = Fieldifier.fieldify(field, this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, secondaryData));
        return this.compute(primaryOrbit, primaryCovariance, secondaryOrbit, secondaryCovariance, combinedRadius, zeroThreshold);
    }

    @Override
    public ProbabilityOfCollision compute(Orbit primaryAtTCA, StateCovariance primaryCovariance, Orbit secondaryAtTCA, StateCovariance secondaryCovariance, double combinedRadius, double zeroThreshold) {
        ShortTermEncounter2DDefinition shortTermEncounter2DDefinition = new ShortTermEncounter2DDefinition(primaryAtTCA, primaryCovariance, secondaryAtTCA, secondaryCovariance, combinedRadius, EncounterLOFType.DEFAULT, 1.0E-6);
        return this.compute(shortTermEncounter2DDefinition, zeroThreshold);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(FieldOrbit<T> primaryAtTCA, FieldStateCovariance<T> primaryCovariance, FieldOrbit<T> secondaryAtTCA, FieldStateCovariance<T> secondaryCovariance, T combinedRadius, double zeroThreshold) {
        FieldShortTermEncounter2DDefinition<T> FieldShortTermEncounter2DDefinition2 = new FieldShortTermEncounter2DDefinition<T>(primaryAtTCA, primaryCovariance, secondaryAtTCA, secondaryCovariance, combinedRadius, EncounterLOFType.DEFAULT, 1.0E-6);
        return this.compute(FieldShortTermEncounter2DDefinition2, zeroThreshold);
    }

    @Override
    public ProbabilityOfCollision compute(ShortTermEncounter2DDefinition encounter, double zeroThreshold) {
        Vector2D otherPositionAfterRotationInCollisionPlane = encounter.computeOtherPositionInRotatedCollisionPlane(zeroThreshold);
        RealMatrix projectedDiagonalizedCombinedPositionalCovarianceMatrix = encounter.computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix();
        return this.compute(otherPositionAfterRotationInCollisionPlane.getX(), otherPositionAfterRotationInCollisionPlane.getY(), FastMath.sqrt((double)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(0, 0)), FastMath.sqrt((double)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(1, 1)), encounter.getCombinedRadius());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(FieldShortTermEncounter2DDefinition<T> encounter, double zeroThreshold) {
        FieldVector2D<T> otherPositionAfterRotationInCollisionPlane = encounter.computeOtherPositionInRotatedCollisionPlane(zeroThreshold);
        FieldMatrix<T> projectedDiagonalizedCombinedPositionalCovarianceMatrix = encounter.computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix();
        return this.compute(otherPositionAfterRotationInCollisionPlane.getX(), otherPositionAfterRotationInCollisionPlane.getY(), (CalculusFieldElement)((CalculusFieldElement)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(0, 0)).sqrt(), (CalculusFieldElement)((CalculusFieldElement)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(1, 1)).sqrt(), encounter.getCombinedRadius());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAMaximumProbabilityOfCollisionMethod() {
        return false;
    }

    protected Orbit getObjectOrbitFromCdm(CdmRelativeMetadata cdmRelativeMetadata, CdmData cdmData, CdmMetadata cdmMetadata, DataContext cdmDataContext) {
        Frame frame = cdmMetadata.getRefFrame().asFrame();
        AbsoluteDate tca = cdmRelativeMetadata.getTca();
        PVCoordinates pvInFrame = new PVCoordinates(cdmData.getStateVectorBlock().getPositionVector(), cdmData.getStateVectorBlock().getVelocityVector());
        double mu = cdmMetadata.getOrbitCenter().getBody().getGM();
        if (frame.isPseudoInertial()) {
            return new CartesianOrbit(pvInFrame, frame, tca, mu);
        }
        Frame inertial = cdmDataContext.getFrames().getGCRF();
        Transform toInertial = frame.getTransformTo(inertial, cdmRelativeMetadata.getTca());
        PVCoordinates pvInInertial = toInertial.transformPVCoordinates(pvInFrame);
        return new CartesianOrbit(pvInInertial, inertial, tca, mu);
    }

    protected StateCovariance getObjectStateCovarianceFromCdm(CdmRelativeMetadata cdmRelativeMetadata, CdmData cdmData) {
        AbsoluteDate tca = cdmRelativeMetadata.getTca();
        RealMatrix rtnCovarianceMatrix = cdmData.getRTNCovarianceBlock().getRTNCovarianceMatrix().getSubMatrix(0, 5, 0, 5);
        return new StateCovariance(rtnCovarianceMatrix, tca, LOFType.QSW_INERTIAL);
    }
}

