/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.integration.FieldTrapezoidIntegrator;
import org.hipparchus.analysis.integration.FieldUnivariateIntegrator;
import org.hipparchus.analysis.integration.UnivariateIntegrator;
import org.hipparchus.geometry.euclidean.twod.FieldVector2D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.cdm.Cdm;
import org.orekit.files.ccsds.ndm.cdm.CdmData;
import org.orekit.files.ccsds.ndm.cdm.CdmMetadata;
import org.orekit.files.ccsds.ndm.cdm.CdmRelativeMetadata;
import org.orekit.frames.encounter.EncounterLOFType;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldStateCovariance;
import org.orekit.propagation.StateCovariance;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.AbstractShortTermEncounter2DPOCMethod;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.FieldShortTermEncounter2DDefinition;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DDefinition;
import org.orekit.ssa.metrics.FieldProbabilityOfCollision;
import org.orekit.ssa.metrics.ProbabilityOfCollision;
import org.orekit.utils.Fieldifier;

public abstract class AbstractShortTermEncounter1DNumerical2DPOCMethod
extends AbstractShortTermEncounter2DPOCMethod {
    private final UnivariateIntegrator integrator;
    private final int maxNbOfEval;

    protected AbstractShortTermEncounter1DNumerical2DPOCMethod(String name, UnivariateIntegrator integrator, int maxNbOfEval) {
        super(name);
        this.integrator = integrator;
        this.maxNbOfEval = maxNbOfEval;
    }

    public ProbabilityOfCollision compute(Cdm cdm, double primaryRadius, double secondaryRadius, UnivariateIntegrator customIntegrator, int customMaxNbOfEval, double zeroThreshold) {
        CdmRelativeMetadata cdmRelativeMetadata = cdm.getRelativeMetadata();
        CdmData primaryData = cdm.getDataObject1();
        CdmData secondaryData = cdm.getDataObject2();
        DataContext cdmDataContext = cdm.getDataContext();
        Orbit primaryOrbit = this.getObjectOrbitFromCdm(cdmRelativeMetadata, primaryData, cdm.getMetadataObject1(), cdmDataContext);
        StateCovariance primaryCovariance = this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, primaryData);
        Orbit secondaryOrbit = this.getObjectOrbitFromCdm(cdmRelativeMetadata, secondaryData, cdm.getMetadataObject2(), cdmDataContext);
        StateCovariance secondaryCovariance = this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, secondaryData);
        return this.compute(primaryOrbit, primaryCovariance, primaryRadius, secondaryOrbit, secondaryCovariance, secondaryRadius, customIntegrator, customMaxNbOfEval, zeroThreshold);
    }

    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(Cdm cdm, T primaryRadius, T secondaryRadius, FieldUnivariateIntegrator<T> customIntegrator, int customMaxNbOfEval, double zeroThreshold) {
        Field field = primaryRadius.getField();
        CdmRelativeMetadata cdmRelativeMetadata = cdm.getRelativeMetadata();
        CdmData primaryData = cdm.getDataObject1();
        CdmData secondaryData = cdm.getDataObject2();
        CdmMetadata primaryMetadata = cdm.getMetadataObject1();
        CdmMetadata secondaryMetadata = cdm.getMetadataObject2();
        DataContext cdmDataContext = cdm.getDataContext();
        Orbit primaryOrbitFromCdm = this.getObjectOrbitFromCdm(cdmRelativeMetadata, primaryData, primaryMetadata, cdmDataContext);
        FieldOrbit primaryOrbit = primaryOrbitFromCdm.getType().convertToFieldOrbit(field, primaryOrbitFromCdm);
        FieldStateCovariance primaryCovariance = Fieldifier.fieldify(field, this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, primaryData));
        Orbit secondaryOrbitFromCdm = this.getObjectOrbitFromCdm(cdmRelativeMetadata, secondaryData, secondaryMetadata, cdmDataContext);
        FieldOrbit secondaryOrbit = secondaryOrbitFromCdm.getType().convertToFieldOrbit(field, secondaryOrbitFromCdm);
        FieldStateCovariance secondaryCovariance = Fieldifier.fieldify(field, this.getObjectStateCovarianceFromCdm(cdmRelativeMetadata, secondaryData));
        return this.compute(primaryOrbit, primaryCovariance, primaryRadius, secondaryOrbit, secondaryCovariance, secondaryRadius, customIntegrator, customMaxNbOfEval, zeroThreshold);
    }

    public ProbabilityOfCollision compute(Orbit primaryAtTCA, StateCovariance primaryCovariance, double primaryRadius, Orbit secondaryAtTCA, StateCovariance secondaryCovariance, double secondaryRadius, UnivariateIntegrator customIntegrator, int customMaxNbOfEval, double zeroThreshold) {
        ShortTermEncounter2DDefinition encounterDefinition = new ShortTermEncounter2DDefinition(primaryAtTCA, primaryCovariance, primaryRadius, secondaryAtTCA, secondaryCovariance, secondaryRadius, EncounterLOFType.DEFAULT, 1.0E-6);
        return this.compute(encounterDefinition, customIntegrator, customMaxNbOfEval, zeroThreshold);
    }

    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(FieldOrbit<T> primaryAtTCA, FieldStateCovariance<T> primaryCovariance, T primaryRadius, FieldOrbit<T> secondaryAtTCA, FieldStateCovariance<T> secondaryCovariance, T secondaryRadius, FieldUnivariateIntegrator<T> customIntegrator, int customMaxNbOfEval, double zeroThreshold) {
        FieldShortTermEncounter2DDefinition<T> encounterDefinition = new FieldShortTermEncounter2DDefinition<T>(primaryAtTCA, primaryCovariance, primaryRadius, secondaryAtTCA, secondaryCovariance, secondaryRadius, EncounterLOFType.DEFAULT, 1.0E-6);
        return this.compute(encounterDefinition, customIntegrator, customMaxNbOfEval, zeroThreshold);
    }

    public ProbabilityOfCollision compute(ShortTermEncounter2DDefinition encounterDefinition, UnivariateIntegrator customIntegrator, int customMaxNbOfEval, double zeroThreshold) {
        Vector2D otherPositionAfterRotationInCollisionPlane = encounterDefinition.computeOtherPositionInRotatedCollisionPlane(zeroThreshold);
        RealMatrix projectedDiagonalizedCombinedPositionalCovarianceMatrix = encounterDefinition.computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix();
        return this.compute(otherPositionAfterRotationInCollisionPlane.getX(), otherPositionAfterRotationInCollisionPlane.getY(), FastMath.sqrt((double)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(0, 0)), FastMath.sqrt((double)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(1, 1)), encounterDefinition.getCombinedRadius(), customIntegrator, customMaxNbOfEval);
    }

    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(FieldShortTermEncounter2DDefinition<T> encounterDefinition, FieldUnivariateIntegrator<T> customIntegrator, int customMaxNbOfEval, double zeroThreshold) {
        FieldVector2D<T> otherPositionAfterRotationInCollisionPlane = encounterDefinition.computeOtherPositionInRotatedCollisionPlane(zeroThreshold);
        FieldMatrix<T> projectedDiagonalizedCombinedPositionalCovarianceMatrix = encounterDefinition.computeProjectedAndDiagonalizedCombinedPositionalCovarianceMatrix();
        return this.compute((T)otherPositionAfterRotationInCollisionPlane.getX(), (T)otherPositionAfterRotationInCollisionPlane.getY(), (T)((CalculusFieldElement)((CalculusFieldElement)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(0, 0)).sqrt()), (T)((CalculusFieldElement)((CalculusFieldElement)projectedDiagonalizedCombinedPositionalCovarianceMatrix.getEntry(1, 1)).sqrt()), encounterDefinition.getCombinedRadius(), customIntegrator, customMaxNbOfEval);
    }

    @Override
    public ProbabilityOfCollision compute(double xm, double ym, double sigmaX, double sigmaY, double radius) {
        return this.compute(xm, ym, sigmaX, sigmaY, radius, this.integrator, this.maxNbOfEval);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(T xm, T ym, T sigmaX, T sigmaY, T radius) {
        return this.compute(xm, ym, sigmaX, sigmaY, radius, (FieldUnivariateIntegrator<T>)new FieldTrapezoidIntegrator(xm.getField()), this.maxNbOfEval);
    }

    public abstract ProbabilityOfCollision compute(double var1, double var3, double var5, double var7, double var9, UnivariateIntegrator var11, int var12);

    public abstract <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(T var1, T var2, T var3, T var4, T var5, FieldUnivariateIntegrator<T> var6, int var7);
}

