/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.ssa.collision.shorttermencounter.probability.twod;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.linear.BlockFieldMatrix;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.FieldLUDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.LUDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.MathArrays;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.AbstractShortTermEncounter2DPOCMethod;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.FieldShortTermEncounter2DDefinition;
import org.orekit.ssa.collision.shorttermencounter.probability.twod.ShortTermEncounter2DDefinition;
import org.orekit.ssa.metrics.FieldProbabilityOfCollision;
import org.orekit.ssa.metrics.ProbabilityOfCollision;

public abstract class AbstractAlfriend1999
extends AbstractShortTermEncounter2DPOCMethod {
    protected AbstractAlfriend1999(String name) {
        super(name);
    }

    @Override
    public ProbabilityOfCollision compute(double xm, double ym, double sigmaX, double sigmaY, double radius) {
        double squaredMahalanobisDistance = ShortTermEncounter2DDefinition.computeSquaredMahalanobisDistance(xm, ym, sigmaX, sigmaY);
        double covarianceMatrixDeterminant = this.computeCovarianceMatrixDeterminant(sigmaX, sigmaY);
        double value = this.computeValue(radius, squaredMahalanobisDistance, covarianceMatrixDeterminant);
        return new ProbabilityOfCollision(value, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldProbabilityOfCollision<T> compute(T xm, T ym, T sigmaX, T sigmaY, T radius) {
        T squaredMahalanobisDistance = FieldShortTermEncounter2DDefinition.computeSquaredMahalanobisDistance(xm, ym, sigmaX, sigmaY);
        T covarianceMatrixDeterminant = this.computeCovarianceMatrixDeterminant(sigmaX, sigmaY);
        T value = this.computeValue(radius, squaredMahalanobisDistance, covarianceMatrixDeterminant);
        return new FieldProbabilityOfCollision<T>(value, this.getName(), this.isAMaximumProbabilityOfCollisionMethod());
    }

    private double computeCovarianceMatrixDeterminant(double sigmaX, double sigmaY) {
        BlockRealMatrix covarianceMatrix = new BlockRealMatrix((double[][])new double[][]{{sigmaX * sigmaX, 0.0}, {0.0, sigmaY * sigmaY}});
        return new LUDecomposition((RealMatrix)covarianceMatrix).getDeterminant();
    }

    private <T extends CalculusFieldElement<T>> T computeCovarianceMatrixDeterminant(T sigmaX, T sigmaY) {
        CalculusFieldElement[][] covarianceMatrixData = (CalculusFieldElement[][])MathArrays.buildArray((Field)sigmaX.getField(), (int)2, (int)2);
        covarianceMatrixData[0][0] = (CalculusFieldElement)sigmaX.multiply(sigmaX);
        covarianceMatrixData[1][1] = (CalculusFieldElement)sigmaY.multiply(sigmaY);
        BlockFieldMatrix covarianceMatrix = new BlockFieldMatrix((FieldElement[][])covarianceMatrixData);
        return (T)((CalculusFieldElement)new FieldLUDecomposition((FieldMatrix)covarianceMatrix).getDeterminant());
    }

    abstract double computeValue(double var1, double var3, double var5);

    abstract <T extends CalculusFieldElement<T>> T computeValue(T var1, T var2, T var3);
}

