/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;

public class HansenZonalLinear {
    private static final int SLICE = 10;
    private final PolynomialFunction[][] mpvec;
    private final PolynomialFunction[][] mpvecDeriv;
    private final double[][] hansenRoot;
    private final double[][] hansenDerivRoot;
    private final int s;
    private final int offset;
    private final int numSlices;
    private final double twots;
    private final int twosp1;
    private final int twos;
    private final double twosp1otwots;

    public HansenZonalLinear(int nMax, int s) {
        int Nmin = -nMax - 1;
        int N0 = -(s + 2);
        this.offset = nMax + 1;
        this.s = s;
        this.twots = FastMath.pow((double)2.0, (int)s);
        this.twos = 2 * s;
        this.twosp1 = this.twos + 1;
        this.twosp1otwots = (double)this.twosp1 / this.twots;
        int size = nMax - s - 1;
        this.mpvec = new PolynomialFunction[size][];
        this.mpvecDeriv = new PolynomialFunction[size][];
        this.numSlices = FastMath.max((int)((int)FastMath.ceil((double)((double)size / 10.0))), (int)1);
        this.hansenRoot = new double[this.numSlices][2];
        this.hansenDerivRoot = new double[this.numSlices][2];
        HansenUtilities.generateZonalPolynomials(N0, Nmin, this.offset, 10, s, this.mpvec, this.mpvecDeriv);
    }

    public void computeInitValues(double chi) {
        this.hansenRoot[0][0] = 0.0;
        this.hansenRoot[0][1] = FastMath.pow((double)chi, (int)this.twosp1) / this.twots;
        this.hansenDerivRoot[0][0] = 0.0;
        this.hansenDerivRoot[0][1] = this.twosp1otwots * FastMath.pow((double)chi, (int)this.twos);
        int st = -this.s - 1;
        for (int i = 1; i < this.numSlices; ++i) {
            for (int j = 0; j < 2; ++j) {
                PolynomialFunction[] mv = this.mpvec[st - i * 10 - j + this.offset];
                PolynomialFunction[] sv = this.mpvecDeriv[st - i * 10 - j + this.offset];
                this.hansenDerivRoot[i][j] = mv[1].value(chi) * this.hansenDerivRoot[i - 1][1] + mv[0].value(chi) * this.hansenDerivRoot[i - 1][0] + (sv[1].value(chi) * this.hansenRoot[i - 1][1] + sv[0].value(chi) * this.hansenRoot[i - 1][0]) / chi;
                this.hansenRoot[i][j] = mv[1].value(chi) * this.hansenRoot[i - 1][1] + mv[0].value(chi) * this.hansenRoot[i - 1][0];
            }
        }
    }

    public double getValue(int mnm1, double chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        double ret = v[1].value(chi) * this.hansenRoot[sliceNo][1];
        if (this.hansenRoot[sliceNo][0] != 0.0) {
            ret += v[0].value(chi) * this.hansenRoot[sliceNo][0];
        }
        return ret;
    }

    public double getDerivative(int mnm1, double chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        double ret = v[1].value(chi) * this.hansenDerivRoot[sliceNo][1];
        if (this.hansenDerivRoot[sliceNo][0] != 0.0) {
            ret += v[0].value(chi) * this.hansenDerivRoot[sliceNo][0];
        }
        PolynomialFunction[] v1 = this.mpvecDeriv[mnm1 + this.offset];
        double hret = v1[1].value(chi) * this.hansenRoot[sliceNo][1];
        if (this.hansenRoot[sliceNo][0] != 0.0) {
            hret += v1[0].value(chi) * this.hansenRoot[sliceNo][0];
        }
        return ret += hret / chi;
    }
}

