/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.PolynomialFunctionMatrix;

public class HansenUtilities {
    public static final PolynomialFunction ONE = new PolynomialFunction(new double[]{1.0});
    public static final PolynomialFunction ZERO = new PolynomialFunction(new double[]{0.0});

    private HansenUtilities() {
    }

    public static PolynomialFunctionMatrix buildIdentityMatrix2() {
        PolynomialFunctionMatrix matrix = new PolynomialFunctionMatrix(2);
        matrix.setMatrix(new PolynomialFunction[][]{{ONE, ZERO}, {ZERO, ONE}});
        return matrix;
    }

    public static PolynomialFunctionMatrix buildZeroMatrix2() {
        PolynomialFunctionMatrix matrix = new PolynomialFunctionMatrix(2);
        matrix.setMatrix(new PolynomialFunction[][]{{ZERO, ZERO}, {ZERO, ZERO}});
        return matrix;
    }

    public static PolynomialFunctionMatrix buildIdentityMatrix4() {
        PolynomialFunctionMatrix matrix = new PolynomialFunctionMatrix(4);
        matrix.setMatrix(new PolynomialFunction[][]{{ONE, ZERO, ZERO, ZERO}, {ZERO, ONE, ZERO, ZERO}, {ZERO, ZERO, ONE, ZERO}, {ZERO, ZERO, ZERO, ONE}});
        return matrix;
    }

    public static PolynomialFunctionMatrix buildZeroMatrix4() {
        PolynomialFunctionMatrix matrix = new PolynomialFunctionMatrix(4);
        matrix.setMatrix(new PolynomialFunction[][]{{ZERO, ZERO, ZERO, ZERO}, {ZERO, ZERO, ZERO, ZERO}, {ZERO, ZERO, ZERO, ZERO}, {ZERO, ZERO, ZERO, ZERO}});
        return matrix;
    }

    private static PolynomialFunction aZonal(int s, int mnm1) {
        double d1 = (mnm1 + 2) * (2 * mnm1 + 5);
        double d2 = (mnm1 + 2 - s) * (mnm1 + 2 + s);
        return new PolynomialFunction(new double[]{0.0, 0.0, d1 / d2});
    }

    private static PolynomialFunction bZonal(int s, int mnm1) {
        double d1 = (mnm1 + 2) * (mnm1 + 3);
        double d2 = (mnm1 + 2 - s) * (mnm1 + 2 + s);
        return new PolynomialFunction(new double[]{0.0, 0.0, -d1 / d2});
    }

    public static void generateZonalPolynomials(int n0, int nMin, int offset, int slice, int s, PolynomialFunction[][] mpvec, PolynomialFunction[][] mpvecDeriv) {
        int sliceCounter = 0;
        PolynomialFunctionMatrix A = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix D = HansenUtilities.buildZeroMatrix2();
        PolynomialFunctionMatrix E = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix a = HansenUtilities.buildZeroMatrix2();
        a.setElem(0, 1, ONE);
        PolynomialFunctionMatrix B = HansenUtilities.buildZeroMatrix2();
        B.setElem(1, 1, new PolynomialFunction(new double[]{2.0}));
        for (int i = n0 - 1; i > nMin - 1; --i) {
            int index = i + offset;
            a.setMatrixLine(1, new PolynomialFunction[]{HansenUtilities.bZonal(s, i), HansenUtilities.aZonal(s, i)});
            A = A.multiply(a);
            mpvec[index] = A.getMatrixLine(1);
            D = D.multiply(a);
            E = E.multiply(a);
            D = D.add(E.multiply(B));
            mpvecDeriv[index] = D.getMatrixLine(1);
            if (++sliceCounter % slice != 0) continue;
            A = HansenUtilities.buildIdentityMatrix2();
            D = HansenUtilities.buildZeroMatrix2();
            E = HansenUtilities.buildIdentityMatrix2();
        }
    }

    private static PolynomialFunction aTesseral(int s, int mnm1) {
        double r1 = ((double)mnm1 + 2.0) * (2.0 * (double)mnm1 + 5.0);
        double r2 = (2.0 + (double)mnm1 + (double)s) * (2.0 + (double)mnm1 - (double)s);
        return new PolynomialFunction(new double[]{0.0, 0.0, r1 / r2});
    }

    private static PolynomialFunction bTesseral(int j, int s, int mnm1) {
        double r2 = (2.0 + (double)mnm1 + (double)s) * (2.0 + (double)mnm1 - (double)s);
        double d1 = ((double)mnm1 + 3.0) * 2.0 * (double)j * (double)s / (r2 * ((double)mnm1 + 4.0));
        double d2 = ((double)mnm1 + 3.0) * ((double)mnm1 + 2.0) / r2;
        return new PolynomialFunction(new double[]{0.0, -d1, -d2});
    }

    private static PolynomialFunction cTesseral(int j, int s, int mnm1) {
        double r1 = (double)(j * j) * ((double)mnm1 + 2.0);
        double r2 = ((double)mnm1 + 4.0) * (2.0 + (double)mnm1 + (double)s) * (2.0 + (double)mnm1 - (double)s);
        return new PolynomialFunction(new double[]{0.0, 0.0, r1 / r2});
    }

    private static PolynomialFunction dTesseral() {
        return new PolynomialFunction(new double[]{0.0, 0.0, 1.0});
    }

    private static PolynomialFunction fTesseral(int j, int s, int n) {
        double r1 = ((double)n + 3.0) * (double)j * (double)s;
        double r2 = ((double)n + 4.0) * (2.0 + (double)n + (double)s) * (2.0 + (double)n - (double)s);
        return new PolynomialFunction(new double[]{0.0, 0.0, 0.0, r1 / r2});
    }

    public static void generateTesseralPolynomials(int n0, int nMin, int offset, int slice, int j, int s, PolynomialFunction[][] mpvec, PolynomialFunction[][] mpvecDeriv) {
        PolynomialFunctionMatrix A = HansenUtilities.buildIdentityMatrix4();
        PolynomialFunctionMatrix B = HansenUtilities.buildZeroMatrix4();
        PolynomialFunctionMatrix D = HansenUtilities.buildZeroMatrix4();
        PolynomialFunctionMatrix a = HansenUtilities.buildZeroMatrix4();
        a.setMatrixLine(0, new PolynomialFunction[]{ZERO, ONE, ZERO, ZERO});
        a.setMatrixLine(1, new PolynomialFunction[]{ZERO, ZERO, ONE, ZERO});
        a.setMatrixLine(2, new PolynomialFunction[]{ZERO, ZERO, ZERO, ONE});
        int sliceCounter = 0;
        for (int i = n0 - 1; i > nMin - 1; --i) {
            int index = i + offset;
            a.setMatrixLine(3, new PolynomialFunction[]{HansenUtilities.cTesseral(j, s, i), ZERO, HansenUtilities.bTesseral(j, s, i), HansenUtilities.aTesseral(s, i)});
            A = A.multiply(a);
            mpvec[index] = A.getMatrixLine(3);
            D = D.multiply(a);
            B.setMatrixLine(3, new PolynomialFunction[]{ZERO, HansenUtilities.fTesseral(j, s, i), ZERO, HansenUtilities.dTesseral()});
            D = D.add(A.multiply(B));
            mpvecDeriv[index] = D.getMatrixLine(3);
            if (++sliceCounter % slice != 0) continue;
            A = HansenUtilities.buildIdentityMatrix4();
            D = HansenUtilities.buildZeroMatrix4();
        }
    }

    private static PolynomialFunction aThirdBody(int n) {
        double r1 = 2 * n + 1;
        double r2 = n + 1;
        return new PolynomialFunction(new double[]{r1 / r2});
    }

    private static PolynomialFunction bThirdBody(int s, int n) {
        double r1 = (n + s) * (n - s);
        double r2 = n * (n + 1);
        return new PolynomialFunction(new double[]{0.0, 0.0, -r1 / r2});
    }

    private static PolynomialFunction dThirdBody(int s, int n) {
        double r1 = 2 * (n + s) * (n - s);
        double r2 = n * (n + 1);
        return new PolynomialFunction(new double[]{0.0, 0.0, 0.0, r1 / r2});
    }

    public static void generateThirdBodyPolynomials(int n0, int nMax, int slice, int s, PolynomialFunction[][] mpvec, PolynomialFunction[][] mpvecDeriv) {
        int sliceCounter = 0;
        PolynomialFunctionMatrix A = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix B = HansenUtilities.buildZeroMatrix2();
        PolynomialFunctionMatrix D = HansenUtilities.buildZeroMatrix2();
        PolynomialFunctionMatrix E = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix a = HansenUtilities.buildZeroMatrix2();
        a.setElem(0, 1, ONE);
        for (int i = n0 + 2; i <= nMax; ++i) {
            a.setMatrixLine(1, new PolynomialFunction[]{HansenUtilities.bThirdBody(s, i), HansenUtilities.aThirdBody(i)});
            A = A.multiply(a);
            mpvec[i] = A.getMatrixLine(1);
            D = D.multiply(a);
            if (sliceCounter % slice != 0) {
                a.setMatrixLine(1, new PolynomialFunction[]{HansenUtilities.bThirdBody(s, i - 1), HansenUtilities.aThirdBody(i - 1)});
                E = E.multiply(a);
            }
            B.setElem(1, 0, HansenUtilities.dThirdBody(s, i));
            D = D.add(E.multiply(B));
            mpvecDeriv[i] = D.getMatrixLine(1);
            if (++sliceCounter % slice != 0) continue;
            A = HansenUtilities.buildIdentityMatrix2();
            D = HansenUtilities.buildZeroMatrix2();
            E = HansenUtilities.buildIdentityMatrix2();
        }
    }
}

