/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;

public class HansenThirdBodyLinear {
    private static final int SLICE = 10;
    private final PolynomialFunction[][] mpvec;
    private final PolynomialFunction[][] mpvecDeriv;
    private final double[][] hansenRoot;
    private final double[][] hansenDerivRoot;
    private final int numSlices;
    private final int s;
    private double twosp1dfosp1f;
    private final double twosp1dfosp2f;
    private final double two2sp1dfosp2f;
    private final double twosp3;

    public HansenThirdBodyLinear(int nMax, int s) {
        this.s = s;
        this.twosp1dfosp1f = s % 2 == 0 ? 1.0 : -1.0;
        for (int i = s; i >= 1; --i) {
            this.twosp1dfosp1f *= (2.0 * (double)i + 1.0) / ((double)i + 1.0);
        }
        this.twosp1dfosp2f = this.twosp1dfosp1f / ((double)s + 2.0);
        this.twosp3 = 2 * s + 3;
        this.two2sp1dfosp2f = 2.0 * this.twosp1dfosp2f;
        this.mpvec = new PolynomialFunction[nMax + 1][];
        this.mpvecDeriv = new PolynomialFunction[nMax + 1][];
        this.numSlices = FastMath.max((int)1, (int)((nMax - s + 10 - 2) / 10));
        this.hansenRoot = new double[this.numSlices][2];
        this.hansenDerivRoot = new double[this.numSlices][2];
        HansenUtilities.generateThirdBodyPolynomials(s, nMax, 10, s, this.mpvec, this.mpvecDeriv);
    }

    public void computeInitValues(double chitm1, double chitm2, double chitm3) {
        this.hansenRoot[0][0] = this.twosp1dfosp1f;
        this.hansenRoot[0][1] = this.twosp1dfosp2f * (this.twosp3 - chitm2);
        this.hansenDerivRoot[0][0] = 0.0;
        this.hansenDerivRoot[0][1] = this.two2sp1dfosp2f * chitm3;
        for (int i = 1; i < this.numSlices; ++i) {
            for (int j = 0; j < 2; ++j) {
                PolynomialFunction[] mv = this.mpvec[this.s + i * 10 + j];
                PolynomialFunction[] sv = this.mpvecDeriv[this.s + i * 10 + j];
                this.hansenDerivRoot[i][j] = mv[1].value(chitm1) * this.hansenDerivRoot[i - 1][1] + mv[0].value(chitm1) * this.hansenDerivRoot[i - 1][0] + sv[1].value(chitm1) * this.hansenRoot[i - 1][1] + sv[0].value(chitm1) * this.hansenRoot[i - 1][0];
                this.hansenRoot[i][j] = mv[1].value(chitm1) * this.hansenRoot[i - 1][1] + mv[0].value(chitm1) * this.hansenRoot[i - 1][0];
            }
        }
    }

    public double getValue(int n, double chitm1) {
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[n];
        double ret = v[1].value(chitm1) * this.hansenRoot[sliceNo][1];
        if (this.hansenRoot[sliceNo][0] != 0.0) {
            ret += v[0].value(chitm1) * this.hansenRoot[sliceNo][0];
        }
        return ret;
    }

    public double getDerivative(int n, double chitm1) {
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[n];
        double ret = v[1].value(chitm1) * this.hansenDerivRoot[sliceNo][1];
        if (this.hansenDerivRoot[sliceNo][0] != 0.0) {
            ret += v[0].value(chitm1) * this.hansenDerivRoot[sliceNo][0];
        }
        PolynomialFunction[] v1 = this.mpvecDeriv[n];
        ret += v1[1].value(chitm1) * this.hansenRoot[sliceNo][1];
        if (this.hansenRoot[sliceNo][0] != 0.0) {
            ret += v1[0].value(chitm1) * this.hansenRoot[sliceNo][0];
        }
        return ret;
    }
}

